package com.dtyunxi.finance.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* 保险公司投保设置Eo对象
*
* @author longde
* @since 2022-07-15
*/
@Data
@ApiModel(value = "InsuranceSettingsReqDto", description = "保险公司投保设置Eo对象")
public class InsuranceSettingsReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  保险公司编码（唯一，当名称变化则新生成唯一编码，修改时编码不变化）
    */
    @ApiModelProperty(name = "insuranceCode", value = "保险公司编码（唯一，当名称变化则新生成唯一编码，修改时编码不变化）")
    private String insuranceCode;
    /**
    *  保险公司名称（唯一，不能重复；需保存历史修改记录；修改时名称需重新校验是否与其他公司名称冲突）
    */
    @ApiModelProperty(name = "insuranceCompanyName", value = "保险公司名称（唯一，不能重复；需保存历史修改记录；修改时名称需重新校验是否与其他公司名称冲突）")
    private String insuranceCompanyName;
    /**
    *  费率（在0至1之间，保存3位小数通常，最高允许4位）
    */
    @ApiModelProperty(name = "rate", value = "费率（在0至1之间，保存3位小数通常，最高允许4位）")
    private BigDecimal rate;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  备注，前端页显示，填写一些说明信息或修改信息
    */
    @ApiModelProperty(name = "remark", value = "备注，前端页显示，填写一些说明信息或修改信息")
    private String remark;


}
