package com.dtyunxi.finance.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

import javax.persistence.Column;

/**
* 物流公司关联设置Eo对象
*
* @author longde
* @since 2022-07-15
*/
@Data
@ApiModel(value = "LogisticsSetttingsRespDto", description = "物流公司关联设置Eo对象")
public class LogisticsSetttingsRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    /**
     *  物流商编码
     */
    @ApiModelProperty(name = "shipmentEnterpriseCode", value = "物流商编码")
    private String shipmentEnterpriseCode;

    /**
     *  物流公司名称
     */
    @ApiModelProperty(name = "logisticsCompany", value = "物流公司名称")
    private String logisticsCompany;


    /**
     *  承运方式(只能单个),0-海运,1-整车,2-整担
     */
    @ApiModelProperty(name = "logisticsType", value = "承运方式(只能单个),0-海运,1-整车,2-整担")
    private String logisticsType;
    /**
    *  保险公司ID（关联保险公司设置表主键id）
    */
    @ApiModelProperty(name = "insuranceId", value = "保险公司ID（关联保险公司设置表主键id）")
    private Long insuranceId;

    /**
     *  保险公司名称
     */
    @ApiModelProperty(name = "insuranceCompany", value = "保险公司名称")
    private String insuranceCompany;

    /**
     *  保险公司编码
     */
    @ApiModelProperty(name = "insuranceCode", value = "保险公司编码")
    private String insuranceCode;

    /**
     *  费率（在0至1之间，保存3位小数通常，最高允许4位）
     */
    @ApiModelProperty(name = "insuranceRate", value = "费率（在0至1之间，保存3位小数通常，最高允许4位）")
    private BigDecimal insuranceRate;
    /**
     *  合同名称
     */
    @ApiModelProperty(name = "contractName", value = "合同名称")
    private String contractName;
    /**
    *  产品折扣（在0至1之间，保存3位小数通常，最高允许4位）
    */
    @ApiModelProperty(name = "productDiscount", value = "产品折扣（在0至1之间，保存3位小数通常，最高允许4位）")
    private BigDecimal productDiscount;
    /**
    *  物料折扣（在0至1之间，保存3位小数通常，最高允许4位）
    */
    @ApiModelProperty(name = "materialDiscount", value = "物料折扣（在0至1之间，保存3位小数通常，最高允许4位）")
    private BigDecimal materialDiscount;
    /**
    *  有效日期起
    */
    @ApiModelProperty(name = "efffectiveTimeBegin", value = "有效日期起")
    private Date efffectiveTimeBegin;
    /**
    *  有效日期止
    */
    @ApiModelProperty(name = "efffectiveTimeEnd", value = "有效日期止")
    private Date efffectiveTimeEnd;
    /**
    *  备注，前端页显示，填写一些说明信息或修改信息
    */
    @ApiModelProperty(name = "remark", value = "备注，前端页显示，填写一些说明信息或修改信息")
    private String remark;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  状态0未作废、1已作废
    */
    @ApiModelProperty(name = "status", value = "状态0未作废、1已作废")
    private Integer status;

    /**
     *  修改历史
     */
    @ApiModelProperty(name = "modifyRecords", value = "修改历史")
    private List modifyRecords;

    /**
     * 账单额度校验 1 开，0 关
     */
    @ApiModelProperty(name = "billQuotaVerify", value = "账单额度校验 1 开，0 关")
    private Integer billQuotaVerify;



}
