package com.dtyunxi.finance.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.CarrierDeliveryAddressReqDto;
import com.dtyunxi.finance.api.dto.response.CarrierDeliveryAddressRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 承运方式发货地址表服务接口
*
* @author jiaye
* @since 2025-08-20
*/
@Api(tags = {"承运方式发货地址表服务"})
@FeignClient(
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/carrier/delivery",
    url = "${com.dtyunxi.finance.api:}"
)
public interface ICarrierDeliveryAddressQueryApi {

    /**
    * 根据id查询承运方式发货地址表
    *
    * @param id 承运方式发货地址表id
    * @return   承运方式发货地址表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询承运方式发货地址表", notes = "根据id查询承运方式发货地址表")
    RestResponse<CarrierDeliveryAddressRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 承运方式发货地址表分页数据
    *
    * @param filter   承运方式发货地址表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 承运方式发货地址表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "承运方式发货地址表分页数据", notes = "根据filter查询条件查询承运方式发货地址表数据，filter=CarrierDeliveryAddressReqDto")
    RestResponse<PageInfo<CarrierDeliveryAddressRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
