package com.dtyunxi.finance.api.dto.request.logistic;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OilLinkReqDto", description = "油价联动配置Dto")
public class OilLinkReqDto extends BaseVo {

    @ApiModelProperty(name = "id",value = "ID")
    private String id;

    private String warehouseId;

    @ApiModelProperty(name = "warehouseName",value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(name = "postUrl",value = "请求地址")
    private String postUrl;

    @ApiModelProperty(name = "lastTime",value = "记账时间")
    private Date lastTime;

    @ApiModelProperty(name = "adjustDate",value = "调整时间")
    private Date adjustDate;

    @ApiModelProperty(name = "amount",value = "单价（元/升）")
    private BigDecimal amount;
}
