package com.dtyunxi.finance.api.dto.response.logistic;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OilChangeRespDto", description = "油价浮动配置Dto")
public class OilChangeRespDto extends BaseVo {

    @ApiModelProperty(name = "id",value = "ID")
    private Long id;

    @ApiModelProperty(name = "type",value = "幅度类型 0：下降 1：上涨")
    private Integer type;

    @ApiModelProperty(name = "minScope",value = "最小值")
    private Integer minScope;

    @ApiModelProperty(name = "maxScope",value = "最大值")
    private Integer maxScope;

    @ApiModelProperty(name = "scope",value = "调整幅度")
    private BigDecimal scope;

    @ApiModelProperty(name="createTime", value = "创建时间")
    @JsonProperty("createTime")
    private Date createTime;


    @ApiModelProperty(name="updateTime", value = "更新时间")
    @JsonProperty("updateTime")
    private Date updateTime = null;


    @ApiModelProperty(name="createPerson", value = "创建人")
    @JsonProperty("createPerson")
    private String createPerson;


    @ApiModelProperty(name="updatePerson", value = "更新人")
    @JsonProperty("updatePerson")
    private String updatePerson;
}
