package com.dtyunxi.finance.api.query;

import com.dtyunxi.finance.api.dto.response.TransportModeRespDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 承运方式服务接口
*
* @author 天泽
* @since 2022-10-26
*/
@Api(tags = {"承运方式服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ITransportModeQueryApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/transport/mode",
    url = "${com.dtyunxi.finance.api:}"
)
public interface ITransportModeQueryApi {

    /**
    * 根据id查询承运方式
    *
    * @param id 承运方式id
    * @return   承运方式数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询承运方式", notes = "根据id查询承运方式")
    RestResponse<TransportModeRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 承运方式分页数据
    *
    * @param filter   承运方式查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 承运方式分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "承运方式分页数据", notes = "根据filter查询条件查询承运方式数据，filter=TransportModeReqDto")
    RestResponse<PageInfo<TransportModeRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                             @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
