/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.api.exception;

public enum ComparisonOperator {
    GREATER_THAN("GREATER_THAN", ">", "\u5927\u4e8e"),
    GREATER_THAN_OR_EQUAL("GREATER_THAN", ">=", "\u5927\u4e8e\u7b49\u4e8e"),
    LESS_THAN("GREATER_THAN", "<", "\u5c0f\u4e8e"),
    LESS_THAN_OR_EQUAL("GREATER_THAN", "<=", "\u5c0f\u4e8e\u7b49\u4e8e"),
    NOT_EQUAL("GREATER_THAN", "!=", "\u4e0d\u7b49"),
    EQUAL("GREATER_THAN", "=", "\u7b49\u4e8e");

    private String code;
    private String operator;
    private String name;

    private ComparisonOperator(String code, String operator, String name) {
        this.code = code;
        this.operator = operator;
        this.name = name;
    }

    public boolean equalsByCode(String code) {
        return this.code.equals(code);
    }

    public boolean equalsByOperator(String operator) {
        return this.operator.equals(operator);
    }

    public static boolean codeIsExist(String code) {
        for (ComparisonOperator operator : ComparisonOperator.values()) {
            if (!operator.equalsByCode(code)) continue;
            return true;
        }
        return false;
    }

    public static boolean operatorIsExist(String operator) {
        for (ComparisonOperator comparisonOperator : ComparisonOperator.values()) {
            if (!comparisonOperator.equalsByOperator(operator)) continue;
            return true;
        }
        return false;
    }

    public String getCode() {
        return this.code;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getName() {
        return this.name;
    }
}

