package com.dtyunxi.finance.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 承运方式修正配置表Eo对象
 *
 * @author jiaye
 * @since 2025-08-20
 */
@ApiModel(value = "CarrierCorrectionConfigReqDto", description = "承运方式修正配置表Eo对象")
public class CarrierCorrectionConfigReqDto extends RequestDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 物理仓编码
     */
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
    private String physicsWarehouseCode;
    /**
     * 物理仓名称
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;
    /**
     * 物流公司编码
     */
    @ApiModelProperty(name = "logisticsCompanyCode", value = "物流公司编码")
    private String logisticsCompanyCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty(name = "logisticsCompanyName", value = "物流公司名称")
    private String logisticsCompanyName;
    /**
     * 承运方式编码
     */
    @ApiModelProperty(name = "carrierCode", value = "承运方式编码")
    private String carrierCode;
    /**
     * 承运方式名称
     */
    @ApiModelProperty(name = "carrierName", value = "承运方式名称")
    private String carrierName;
    /**
     * 修改后承运方式编码
     */
    @ApiModelProperty(name = "modifiedCarrierCode", value = "修改后承运方式编码")
    private String modifiedCarrierCode;
    /**
     * 修改后承运方式名称
     */
    @ApiModelProperty(name = "modifiedCarrierName", value = "修改后承运方式名称")
    private String modifiedCarrierName;
    /**
     * 体积运算符
     */
    @ApiModelProperty(name = "volumeOperator", value = "体积运算符，枚举：＞、≥、＜、≤、≠、＝")
    private String volumeOperator;
    /**
     * 累计合并体积
     */
    @ApiModelProperty(name = "accumulatedVolume", value = "累计合并体积")
    private BigDecimal accumulatedVolume;
    /**
     * 状态 0-禁用 1-启用
     */
    @ApiModelProperty(name = "status", value = "状态 0-禁用 1-启用")
    private Integer status;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setPhysicsWarehouseCode(String physicsWarehouseCode) {
        this.physicsWarehouseCode = physicsWarehouseCode;
    }

    public String getPhysicsWarehouseCode() {
        return this.physicsWarehouseCode;
    }

    public void setPhysicsWarehouseName(String physicsWarehouseName) {
        this.physicsWarehouseName = physicsWarehouseName;
    }

    public String getPhysicsWarehouseName() {
        return this.physicsWarehouseName;
    }

    public void setLogisticsCompanyCode(String logisticsCompanyCode) {
        this.logisticsCompanyCode = logisticsCompanyCode;
    }

    public String getLogisticsCompanyCode() {
        return this.logisticsCompanyCode;
    }

    public void setLogisticsCompanyName(String logisticsCompanyName) {
        this.logisticsCompanyName = logisticsCompanyName;
    }

    public String getLogisticsCompanyName() {
        return this.logisticsCompanyName;
    }

    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public String getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public String getCarrierName() {
        return this.carrierName;
    }

    public void setModifiedCarrierCode(String modifiedCarrierCode) {
        this.modifiedCarrierCode = modifiedCarrierCode;
    }

    public String getModifiedCarrierCode() {
        return this.modifiedCarrierCode;
    }

    public void setModifiedCarrierName(String modifiedCarrierName) {
        this.modifiedCarrierName = modifiedCarrierName;
    }

    public String getModifiedCarrierName() {
        return this.modifiedCarrierName;
    }

    public void setVolumeOperator(String volumeOperator) {
        this.volumeOperator = volumeOperator;
    }

    public String getVolumeOperator() {
        return this.volumeOperator;
    }

    public void setAccumulatedVolume(BigDecimal accumulatedVolume) {
        this.accumulatedVolume = accumulatedVolume;
    }

    public BigDecimal getAccumulatedVolume() {
        return this.accumulatedVolume;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }
}
