package com.dtyunxi.finance.api.dto.request;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.dto.RequestDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 仓储费用关联明细表Eo对象
*
* @author xuanxin
* @since 2022-07-18
*/
@ApiModel(value = "StorageContractDetailReqDto", description = "仓储费用关联明细表Eo对象")
public class StorageContractDetailReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  关联合同ID
    */
    @ApiModelProperty(name = "contractId", value = "关联合同ID")
    private Long contractId;
    /**
    *  合同月份
    */
    @ApiModelProperty(name = "contractTime", value = "合同月份")
    @JSONField(format = "yyyy-MM")
    private Date contractTime;
    /**
    *  月份单价
    */
    @ApiModelProperty(name = "unitPrice", value = "月份单价")
    private BigDecimal unitPrice;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setContractId(Long contractId){
    this.contractId = contractId;
    }
    public Long getContractId(){
    return this.contractId;
    }
    public void setContractTime(Date contractTime){
    this.contractTime = contractTime;
    }
    public Date getContractTime(){
    return this.contractTime;
    }
    public void setUnitPrice(BigDecimal unitPrice){
    this.unitPrice = unitPrice;
    }
    public BigDecimal getUnitPrice(){
    return this.unitPrice;
    }
}
