package com.dtyunxi.finance.api.dto.request.logistic;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OilChangeReqDto", description = "油价浮动配置Dto")
public class OilChangeReqDto extends BaseVo {

    @ApiModelProperty(name = "id",value = "ID")
    private String id;

    @ApiModelProperty(name = "type",value = "幅度类型 0：下降 1：上涨")
    private Integer type;

    @ApiModelProperty(name = "minScope",value = "最小值")
    private Integer minScope;

    @ApiModelProperty(name = "maxScope",value = "最大值")
    private Integer maxScope;

    @ApiModelProperty(name = "scope",value = "调整幅度")
    private BigDecimal scope;
}
