package com.dtyunxi.finance.api.exception;


import lombok.Getter;

@Getter
public enum ComparisonOperator {
    GREATER_THAN("GREATER_THAN", ">", "大于"),
    GREATER_THAN_OR_EQUAL("GREATER_THAN", ">=", "大于等于"),
    LESS_THAN("GREATER_THAN", "<", "小于"),
    LESS_THAN_OR_EQUAL("GREATER_THAN", "<=", "小于等于"),
    NOT_EQUAL("GREATER_THAN", "!=", "不等"),
    EQUAL("GREATER_THAN", "=", "等于"),
    ;

    private String code;
    private String operator;
    private String name;

    ComparisonOperator(String code, String operator, String name) {
        this.code = code;
        this.operator = operator;
        this.name = name;
    }

    public boolean equalsByCode(String code) {
        return this.code.equals(code);
    }

    public boolean equalsByOperator(String operator) {
        return this.operator.equals(operator);
    }

    /**
     * 判断编码是否存在
     */
    public static boolean codeIsExist(String code) {
        for (ComparisonOperator operator : ComparisonOperator.values()) {
            if (operator.equalsByCode(code)) {
                return true;
            }
        }
        return false;
    }

    public static boolean operatorIsExist(String operator) {
        for (ComparisonOperator comparisonOperator : ComparisonOperator.values()) {
            if (comparisonOperator.equalsByOperator(operator)) {
                return true;
            }
        }
        return false;
    }

}