package com.dtyunxi.finance.api.query;

import com.dtyunxi.finance.api.dto.request.FeeAttributionConfigDetailQueryReqDto;
import com.dtyunxi.finance.api.dto.request.FeeAttributionConfigListQueryReqDto;
import com.dtyunxi.finance.api.dto.request.SubmitFeeAttributionConfigAddReqDto;
import com.dtyunxi.finance.api.dto.request.SubmitFeeAttributionConfigEditReqDto;
import com.dtyunxi.finance.api.dto.response.FeeAttributionConfigRespDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@Api(tags = {"费用归属功能模块：费用归属管理"})
@FeignClient(
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/finance",
        url = "${com.dtyunxi.finance.api:}"
)
public interface FeeAttributionConfigApi {
    @ApiOperation(
        tags = { "financeCenter/feeAttributionConfig" },
        value = "新增费用归属设置",
        nickname = "addFeeAttributionConfig",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/feeAttributionConfig/add",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<Object> addFeeAttributionConfig(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SubmitFeeAttributionConfigAddReqDto submitFeeAttributionConfig
    );

    @ApiOperation(
            tags = { "financeCenter/feeAttributionConfig" },
            value = "编辑费用归属设置",
            nickname = "addFeeAttributionConfig",
            notes = ""
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/feeAttributionConfig/edit",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<Object> editFeeAttributionConfig(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SubmitFeeAttributionConfigEditReqDto submitFeeAttributionConfig
    );

    @ApiOperation(
            tags = { "financeCenter/feeAttributionConfig" },
            value = "批量新增费用归属设置",
            nickname = "addFeeAttributionConfig",
            notes = ""
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/feeAttributionConfig/addBatch",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<Object> addBatchFeeAttributionConfig(@Valid @RequestBody   List<SubmitFeeAttributionConfigAddReqDto> list);

    @ApiOperation(
        tags = { "financeCenter/feeAttributionConfig" },
        value = "获取费用归属设置详情",
        nickname = "detailFeeAttributionConfig",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/feeAttributionConfig/detail",
        produces = { "application/json" }
    )
    RestResponse<FeeAttributionConfigRespDto> detailFeeAttributionConfig(
            @ApiParam(value = "") @Valid @RequestBody(required = false)FeeAttributionConfigDetailQueryReqDto feeAttributionConfigDetailQueryReqDto
    );

    @ApiOperation(
        tags = { "financeCenter/feeAttributionConfig" },
        value = "查询费用归属设置列表",
        nickname = "getFeeAttributionConfigListPage",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/feeAttributionConfig/list",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<PageInfo<FeeAttributionConfigRespDto>> getFeeAttributionConfigListPage(
            @ApiParam(value = "") @Valid @RequestBody(required = false) FeeAttributionConfigListQueryReqDto feeAttributionConfigListQueryReqDto
    );

    @ApiOperation(
            tags = { "financeCenter/feeAttributionConfig" },
            value = "删除费用归属设置",
            nickname = "deleteFeeAttributionConfig",
            notes = ""
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/feeAttributionConfig/delete",
            produces = { "application/json" }
    )
    RestResponse<FeeAttributionConfigRespDto> deleteFeeAttributionConfig(
            @NotNull @ApiParam(value = "费用归属设置id", required = true) @Valid @RequestParam(value = "id", required = true) Long id
    );
}
