package com.dtyunxi.finance.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.LogisticsSettingsLogReqDto;
import com.dtyunxi.finance.api.dto.response.LogisticsSettingsLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 物流公司关联设置修改记录表服务接口
*
* @author longde
* @since 2022-07-22
*/
@Api(tags = {"物流公司关联设置修改记录表服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-query-ILogisticsSettingsLogQueryApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/logistics/settings/log",
    url = "${com.dtyunxi.finance.api:}"
)
public interface ILogisticsSettingsLogQueryApi {

    /**
    * 根据id查询物流公司关联设置修改记录表
    *
    * @param id 物流公司关联设置修改记录表id
    * @return   物流公司关联设置修改记录表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询物流公司关联设置修改记录表", notes = "根据id查询物流公司关联设置修改记录表")
    RestResponse<LogisticsSettingsLogRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 物流公司关联设置修改记录表分页数据
    *
    * @param filter   物流公司关联设置修改记录表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 物流公司关联设置修改记录表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "物流公司关联设置修改记录表分页数据", notes = "根据filter查询条件查询物流公司关联设置修改记录表数据，filter=LogisticsSettingsLogReqDto")
    RestResponse<PageInfo<LogisticsSettingsLogRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
