package com.dtyunxi.finance.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* 分摊基础配置表Eo对象
*
* @author jiaye
* @since 2025-08-20
*/
@ApiModel(value = "ApportionmentConfigRespDto", description = "分摊基础配置表Eo对象")
public class ApportionmentConfigRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  规则编码
    */
    @ApiModelProperty(name = "ruleCode", value = "规则编码")
    private String ruleCode;
    /**
    *  规则名称
    */
    @ApiModelProperty(name = "ruleName", value = "规则名称")
    private String ruleName;
    /**
    *  费用模块编码
    */
    @ApiModelProperty(name = "costModuleCode", value = "费用模块编码")
    private String costModuleCode;
    /**
    *  费用模块名称
    */
    @ApiModelProperty(name = "costModuleName", value = "费用模块名称")
    private String costModuleName;
    /**
    *  是否股份分摊 0-否 1-是
    */
    @ApiModelProperty(name = "isShareholdingApportionment", value = "是否股份分摊 0-否 1-是")
    private Integer isShareholdingApportionment;
    /**
    *  交易分摊日期-截止至次月(表示截止到次月的第几天)
    */
    @ApiModelProperty(name = "tradeApportionmentDeadline", value = "交易分摊日期-截止至次月(表示截止到次月的第几天)")
    private Integer tradeApportionmentDeadline;
    /**
    *  状态 0-禁用 1-启用
    */
    @ApiModelProperty(name = "status", value = "状态 0-禁用 1-启用")
    private Integer status;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setRuleCode(String ruleCode){
    this.ruleCode = ruleCode;
    }
    public String getRuleCode(){
    return this.ruleCode;
    }
    public void setRuleName(String ruleName){
    this.ruleName = ruleName;
    }
    public String getRuleName(){
    return this.ruleName;
    }
    public void setCostModuleCode(String costModuleCode){
    this.costModuleCode = costModuleCode;
    }
    public String getCostModuleCode(){
    return this.costModuleCode;
    }
    public void setCostModuleName(String costModuleName){
    this.costModuleName = costModuleName;
    }
    public String getCostModuleName(){
    return this.costModuleName;
    }
    public void setIsShareholdingApportionment(Integer isShareholdingApportionment){
    this.isShareholdingApportionment = isShareholdingApportionment;
    }
    public Integer getIsShareholdingApportionment(){
    return this.isShareholdingApportionment;
    }
    public void setTradeApportionmentDeadline(Integer tradeApportionmentDeadline){
    this.tradeApportionmentDeadline = tradeApportionmentDeadline;
    }
    public Integer getTradeApportionmentDeadline(){
    return this.tradeApportionmentDeadline;
    }
    public void setStatus(Integer status){
    this.status = status;
    }
    public Integer getStatus(){
    return this.status;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
}
