package com.dtyunxi.finance.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 物流公司关联设置修改记录表Eo对象
*
* @author longde
* @since 2022-07-22
*/
@ApiModel(value = "LogisticsSettingsLogReqDto", description = "物流公司关联设置修改记录表Eo对象")
public class LogisticsSettingsLogReqDto extends RequestDto{
    /**
    *  修改历史记录id
    */
    @ApiModelProperty(name = "id", value = "修改历史记录id")
    private Long id;
    /**
    *  物流公司关联设置表id
    */
    @ApiModelProperty(name = "settingsId", value = "物流公司关联设置表id")
    private Long settingsId;
    /**
    *  修改字段名（保存中文即可，只是查看用）
    */
    @ApiModelProperty(name = "modifyColumn", value = "修改字段名（保存中文即可，只是查看用）")
    private String modifyColumn;
    /**
    *  修改前值（记录用作查看，保存字符串即可）
    */
    @ApiModelProperty(name = "valueBefore", value = "修改前值（记录用作查看，保存字符串即可）")
    private String valueBefore;
    /**
    *  修改后值（记录用作查看，保存字符串即可）
    */
    @ApiModelProperty(name = "valueAfter", value = "修改后值（记录用作查看，保存字符串即可）")
    private String valueAfter;
    /**
    *  修改人姓名
    */
    @ApiModelProperty(name = "updatePersonName", value = "修改人姓名")
    private String updatePersonName;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setSettingsId(Long settingsId){
    this.settingsId = settingsId;
    }
    public Long getSettingsId(){
    return this.settingsId;
    }
    public void setModifyColumn(String modifyColumn){
    this.modifyColumn = modifyColumn;
    }
    public String getModifyColumn(){
    return this.modifyColumn;
    }
    public void setValueBefore(String valueBefore){
    this.valueBefore = valueBefore;
    }
    public String getValueBefore(){
    return this.valueBefore;
    }
    public void setValueAfter(String valueAfter){
    this.valueAfter = valueAfter;
    }
    public String getValueAfter(){
    return this.valueAfter;
    }
    public void setUpdatePersonName(String updatePersonName){
    this.updatePersonName = updatePersonName;
    }
    public String getUpdatePersonName(){
    return this.updatePersonName;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
}
