package com.dtyunxi.finance.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

/**
* 保险公司投保设置修改记录表Eo对象
*
* @author longde
* @since 2022-07-22
*/
@ApiModel(value = "InsuranceSettingsLogRespDto", description = "保险公司投保设置修改记录表Eo对象")
@Data
public class InsuranceSettingsLogRespDto extends BaseRespDto{
    /**
    *  修改历史记录id
    */
    @ApiModelProperty(name = "id", value = "修改历史记录id")
    private Long id;
    /**
    *  投保设置表id
    */
    @ApiModelProperty(name = "settingsId", value = "投保设置表id")
    private Long settingsId;
    /**
    *  修改字段名（保存中文即可，只是查看用）
    */
    @ApiModelProperty(name = "modifyColumn", value = "修改字段名（保存中文即可，只是查看用）")
    private String modifyColumn;
    /**
    *  修改前值（记录用作查看，保存字符串即可）
    */
    @ApiModelProperty(name = "valueBefore", value = "修改前值（记录用作查看，保存字符串即可）")
    private String valueBefore;
    /**
    *  修改后值（记录用作查看，保存字符串即可）
    */
    @ApiModelProperty(name = "valueAfter", value = "修改后值（记录用作查看，保存字符串即可）")
    private String valueAfter;
    /**
    *  修改人姓名
    */
    @ApiModelProperty(name = "updatePersonName", value = "修改人姓名")
    private String updatePersonName;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;




}
