package com.dtyunxi.finance.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>Tile 顺丰电商标快计算方式 详情</p>
 * <p>description</p>
 *
 * @author 天泽
 * @date
 * @since 0.1.0
 */
@Data
public class SfDsBkCostChargeModeInfo implements Serializable {

    @ApiModelProperty(value = "票数最小值")
    private Integer minTicket = 0;

    @ApiModelProperty(value = "票数最大值")
    private Integer maxTicket = 0;

    @ApiModelProperty(value = "首重")
    private BigDecimal firstWeight;

    @ApiModelProperty(value = "阶梯1重量最小值")
    private BigDecimal ladderOneMinWeight;

    @ApiModelProperty(value = "阶梯1重量最大值")
    private BigDecimal ladderOneMaxWeight;

    @ApiModelProperty(value = "阶梯1续重")
    private BigDecimal ladderOneContinuationWeight;

    @ApiModelProperty(value = "阶梯2重量最小值")
    private BigDecimal ladderTwoMinWeight;

    @ApiModelProperty(value = "阶梯2续重1")
    private BigDecimal ladderTwoContinuationWeightOne;

    @ApiModelProperty(value = "阶梯2续重2")
    private BigDecimal ladderTwoContinuationWeightTwo;

    @ApiModelProperty(value = "排序值")
    private Integer sort = 0;

}
