package com.dtyunxi.finance.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.finance.api.dto.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

/**
* 快递费用合同Eo对象
*
* @author 天泽
* @since 2022-11-10
*/
@ApiModel(value = "ExpressCostContractReqDto", description = "快递费用合同Eo对象")
public class ExpressCostContractReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  合同名称
    */
    @ApiModelProperty(name = "contractName", value = "合同名称")
    private String contractName;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  物流公司编码
    */
    @ApiModelProperty(name = "logisticCode", value = "物流公司编码")
    private String logisticCode;
    /**
    *  物流公司
    */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司")
    private String logisticCompany;
    /**
    *  承运方式
    */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
    *  计算方式
    */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private Integer chargeMode;
    /**
    *  计算方式json参数
    */
    @ApiModelProperty(name = "params", value = "计算方式json参数")
    private String params;
    /**
    *  有效开始时间
    */
    @ApiModelProperty(name = "startTime", value = "有效开始时间")
    private Date startTime;
    /**
    *  有效结束时间
    */
    @ApiModelProperty(name = "endTime", value = "有效结束时间")
    private Date endTime;
    /**
    *  重量换算系数
    */
    @ApiModelProperty(name = "weightRatio", value = "重量换算系数")
    private BigDecimal weightRatio;
    /**
    *  包装费
    */
    @ApiModelProperty(name = "packingPrice", value = "包装费")
    private BigDecimal packingPrice;
    /**
    *  投保折扣
    */
    @ApiModelProperty(name = "insureDiscount", value = "投保折扣")
    private BigDecimal insureDiscount;
    /**
    *  保费费率
    */
    @ApiModelProperty(name = "premiumRatio", value = "保费费率")
    private BigDecimal premiumRatio;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  旺季月份
    */
    @ApiModelProperty(name = "peakSeason", value = "旺季月份")
    private String peakSeason;
    /**
    *  上浮比例
    */
    @ApiModelProperty(name = "ascentRatio", value = "上浮比例")
    private BigDecimal ascentRatio;
    /**
    *  折扣类型 1 统一折扣；2 按价格区间
    */
    @ApiModelProperty(name = "discountType", value = "折扣类型 1 统一折扣；2 按价格区间")
    private Integer discountType;
    /**
    *  价格区间json参数
    */
    @ApiModelProperty(name = "priceRange", value = "价格区间json参数")
    private String priceRange;
    /**
    *  优惠条件
    */
    @ApiModelProperty(name = "preferentialConditions", value = "优惠条件")
    private String preferentialConditions;
    /**
    *  优惠折扣
    */
    @ApiModelProperty(name = "preferentialDiscount", value = "优惠折扣")
    private BigDecimal preferentialDiscount;
    /**
    *  状态（0=正常 1=作废）
    */
    @ApiModelProperty(name = "status", value = "状态（0=正常 1=作废）")
    private Integer status;

    @ApiModelProperty(value = "顺丰电商标快-模板1")
    private SfDsBkCostChargeModeDto sfDsBkMode;

    @ApiModelProperty(value = "顺丰卡航-模板2")
    private SfKhCostChargeMode sfKhMode;

    @ApiModelProperty(value = "通用模板首重:【顺丰特快-模板3】、【中通快递-模板7】")
    private BigDecimal currencyModeFirstWeight;

    @ApiModelProperty(value = "顺丰特快包裹-模板4")
    private SfTkPackageCostChargeMode sfTkPackageMode;

    @ApiModelProperty(value = "顺丰标快-模板5")
    private SfBkCostChargeMode sfBkMode;

    @ApiModelProperty(value = "中通快递-模板6")
    private ZtoCostChargeMode zToMode;

    @ApiModelProperty(value = "EMS标快-模板8")
    private EMSBkCostChargeMode eMsBkMode;

    @ApiModelProperty(value = "EMS快递包裹-模板9")
    private EMSPackageCostChargeMode eMsPackageMode;

    @ApiModelProperty(value = "顺丰卡航-价格区间阶梯")
    private List<PriceLadderInfoDto> priceLadders;

    @ApiModelProperty(name = "copyFlag  ", value = "复制标识 true 复制，false 非复制")
    private Boolean copyFlag = Boolean.FALSE ;

    @ApiModelProperty(name = "sourceId  ", value = "被复制的合同ID")
    private Long sourceId ;

    @ApiModelProperty(name = "premiumType  ", value = "保费计费方式，1：固定，2：按投保费率")
    private Integer premiumType;

    @ApiModelProperty(name = "premiumAmount  ", value = "保费固定金额")
    private BigDecimal premiumAmount;

    @ApiModelProperty(name = "renewWeightRule  ", value = "续重取整规则")
    private String renewWeightRule;

    @ApiModelProperty(name = "accretionAmount  ", value = "增值费")
    private BigDecimal accretionAmount;

    @ApiModelProperty(name = "remoteArea  ", value = "偏远地区")
    private String remoteArea;

    @ApiModelProperty(name = "totalRule  ", value = "合计规则，0:按计算结果 1:向上取整")
    private Integer totalRule;

    public Integer getTotalRule() {
        return totalRule;
    }

    public void setTotalRule(Integer totalRule) {
        this.totalRule = totalRule;
    }

    public BigDecimal getAccretionAmount() {
        return accretionAmount;
    }

    public void setAccretionAmount(BigDecimal accretionAmount) {
        this.accretionAmount = accretionAmount;
    }

    public String getRemoteArea() {
        return remoteArea;
    }

    public void setRemoteArea(String remoteArea) {
        this.remoteArea = remoteArea;
    }

    public String getRenewWeightRule() {
        return renewWeightRule;
    }

    public void setRenewWeightRule(String renewWeightRule) {
        this.renewWeightRule = renewWeightRule;
    }

    public Integer getPremiumType() {
        return premiumType;
    }

    public void setPremiumType(Integer premiumType) {
        this.premiumType = premiumType;
    }

    public BigDecimal getPremiumAmount() {
        return premiumAmount;
    }

    public void setPremiumAmount(BigDecimal premiumAmount) {
        this.premiumAmount = premiumAmount;
    }

    public Boolean getCopyFlag() {
        return copyFlag;
    }

    public void setCopyFlag(Boolean copyFlag) {
        this.copyFlag = copyFlag;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public List<PriceLadderInfoDto> getPriceLadders() {
        return priceLadders;
    }

    public void setPriceLadders(List<PriceLadderInfoDto> priceLadders) {
        this.priceLadders = priceLadders;
    }

    public SfDsBkCostChargeModeDto getSfDsBkMode() {
        return sfDsBkMode;
    }

    public void setSfDsBkMode(SfDsBkCostChargeModeDto sfDsBkMode) {
        this.sfDsBkMode = sfDsBkMode;
    }

    public SfKhCostChargeMode getSfKhMode() {
        return sfKhMode;
    }

    public void setSfKhMode(SfKhCostChargeMode sfKhMode) {
        this.sfKhMode = sfKhMode;
    }

    public BigDecimal getCurrencyModeFirstWeight() {
        return currencyModeFirstWeight;
    }

    public void setCurrencyModeFirstWeight(BigDecimal currencyModeFirstWeight) {
        this.currencyModeFirstWeight = currencyModeFirstWeight;
    }

    public SfTkPackageCostChargeMode getSfTkPackageMode() {
        return sfTkPackageMode;
    }

    public void setSfTkPackageMode(SfTkPackageCostChargeMode sfTkPackageMode) {
        this.sfTkPackageMode = sfTkPackageMode;
    }

    public SfBkCostChargeMode getSfBkMode() {
        return sfBkMode;
    }

    public void setSfBkMode(SfBkCostChargeMode sfBkMode) {
        this.sfBkMode = sfBkMode;
    }

    public ZtoCostChargeMode getzToMode() {
        return zToMode;
    }

    public void setzToMode(ZtoCostChargeMode zToMode) {
        this.zToMode = zToMode;
    }

    public EMSBkCostChargeMode geteMsBkMode() {
        return eMsBkMode;
    }

    public void seteMsBkMode(EMSBkCostChargeMode eMsBkMode) {
        this.eMsBkMode = eMsBkMode;
    }

    public EMSPackageCostChargeMode geteMsPackageMode() {
        return eMsPackageMode;
    }

    public void seteMsPackageMode(EMSPackageCostChargeMode eMsPackageMode) {
        this.eMsPackageMode = eMsPackageMode;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setContractName(String contractName){
    this.contractName = contractName;
    }
    public String getContractName(){
    return this.contractName;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setLogisticCode(String logisticCode){
    this.logisticCode = logisticCode;
    }
    public String getLogisticCode(){
    return this.logisticCode;
    }
    public void setLogisticCompany(String logisticCompany){
    this.logisticCompany = logisticCompany;
    }
    public String getLogisticCompany(){
    return this.logisticCompany;
    }
    public void setTransportType(String transportType){
    this.transportType = transportType;
    }
    public String getTransportType(){
    return this.transportType;
    }
    public void setChargeMode(Integer chargeMode){
    this.chargeMode = chargeMode;
    }
    public Integer getChargeMode(){
    return this.chargeMode;
    }
    public void setParams(String params){
    this.params = params;
    }
    public String getParams(){
    return this.params;
    }
    public void setStartTime(Date startTime){
    this.startTime = startTime;
    }
    public Date getStartTime(){
    return this.startTime;
    }
    public void setEndTime(Date endTime){
    this.endTime = endTime;
    }
    public Date getEndTime(){
    return this.endTime;
    }
    public void setWeightRatio(BigDecimal weightRatio){
    this.weightRatio = weightRatio;
    }
    public BigDecimal getWeightRatio(){
    return this.weightRatio;
    }
    public void setPackingPrice(BigDecimal packingPrice){
    this.packingPrice = packingPrice;
    }
    public BigDecimal getPackingPrice(){
    return this.packingPrice;
    }
    public void setInsureDiscount(BigDecimal insureDiscount){
    this.insureDiscount = insureDiscount;
    }
    public BigDecimal getInsureDiscount(){
    return this.insureDiscount;
    }
    public void setPremiumRatio(BigDecimal premiumRatio){
    this.premiumRatio = premiumRatio;
    }
    public BigDecimal getPremiumRatio(){
    return this.premiumRatio;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setPeakSeason(String peakSeason){
    this.peakSeason = peakSeason;
    }
    public String getPeakSeason(){
    return this.peakSeason;
    }
    public void setAscentRatio(BigDecimal ascentRatio){
    this.ascentRatio = ascentRatio;
    }
    public BigDecimal getAscentRatio(){
    return this.ascentRatio;
    }
    public void setDiscountType(Integer discountType){
    this.discountType = discountType;
    }
    public Integer getDiscountType(){
    return this.discountType;
    }
    public void setPriceRange(String priceRange){
    this.priceRange = priceRange;
    }
    public String getPriceRange(){
    return this.priceRange;
    }
    public void setPreferentialConditions(String preferentialConditions){
    this.preferentialConditions = preferentialConditions;
    }
    public String getPreferentialConditions(){
    return this.preferentialConditions;
    }
    public void setPreferentialDiscount(BigDecimal preferentialDiscount){
    this.preferentialDiscount = preferentialDiscount;
    }
    public BigDecimal getPreferentialDiscount(){
    return this.preferentialDiscount;
    }
    public void setStatus(Integer status){
    this.status = status;
    }
    public Integer getStatus(){
    return this.status;
    }
}
