package com.dtyunxi.finance.api.exception;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
/**
 * 快递费合同计算方式枚举
 *
 * @author 天泽
 * @since 2022-11-10
 */
@Getter
public enum ExpressCostChargeModeEnum {
    SF_DS_BK(1,"顺丰电商标快"),
    SF_KH(2,"顺丰卡航"),
    SF_EXPRESS(3,"顺丰特快"),
    SF_EXPRESS_PACKAGE(4,"顺丰特快包裹"),
    SF_BK(5,"顺丰标快"),
    ZTO(6,"中通快递"),
    STO(7,"申通快递"),
    EMS_BK(8,"EMS标准快递"),
    EMS_PACKAGE(9,"EMS快递包裹"),
    ;

    private Integer type;
    private String name;

    ExpressCostChargeModeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static final Map<Integer, ExpressCostChargeModeEnum> CHARGE_MODE_TYPE_MAP = new HashMap<>();

    static {
        CHARGE_MODE_TYPE_MAP.put(SF_DS_BK.getType(), SF_DS_BK);
        CHARGE_MODE_TYPE_MAP.put(SF_EXPRESS.getType(), SF_EXPRESS);
        CHARGE_MODE_TYPE_MAP.put(SF_EXPRESS_PACKAGE.getType(), SF_EXPRESS_PACKAGE);
        CHARGE_MODE_TYPE_MAP.put(SF_KH.getType(), SF_KH);
        CHARGE_MODE_TYPE_MAP.put(SF_BK.getType(), SF_BK);
        CHARGE_MODE_TYPE_MAP.put(ZTO.getType(), ZTO);
        CHARGE_MODE_TYPE_MAP.put(STO.getType(), STO);
        CHARGE_MODE_TYPE_MAP.put(EMS_BK.getType(), EMS_BK);
        CHARGE_MODE_TYPE_MAP.put(EMS_PACKAGE.getType(), EMS_PACKAGE);
    }

    public static ExpressCostChargeModeEnum getChargeMode(Integer type) {
        ExpressCostChargeModeEnum chargeModeEnum = CHARGE_MODE_TYPE_MAP.get(type);
        return chargeModeEnum;
    }
}
