package com.dtyunxi.finance.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.InsuranceSettingsLogReqDto;
import com.dtyunxi.finance.api.dto.response.InsuranceSettingsLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 保险公司投保设置修改记录表服务接口
*
* @author longde
* @since 2022-07-22
*/
@Api(tags = {"保险公司投保设置修改记录表服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-IInsuranceSettingsLogApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/insuranceSettingsLog",
    url = "${com.dtyunxi.finance.api:}"
)
public interface IInsuranceSettingsLogApi {

/**
* 新增保险公司投保设置修改记录表
*
* @param addReqDto 保险公司投保设置修改记录表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增保险公司投保设置修改记录表", notes = "新增保险公司投保设置修改记录表")
RestResponse<Long> addInsuranceSettingsLog(@RequestBody InsuranceSettingsLogReqDto addReqDto);

    /**
    * 修改保险公司投保设置修改记录表
    *
    * @param modifyReqDto 保险公司投保设置修改记录表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改保险公司投保设置修改记录表", notes = "修改保险公司投保设置修改记录表")
    RestResponse<Void> modifyInsuranceSettingsLog(@RequestBody InsuranceSettingsLogReqDto modifyReqDto);

    /**
    * 删除保险公司投保设置修改记录表
    *
    * @param ids        保险公司投保设置修改记录表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除保险公司投保设置修改记录表", notes = "删除保险公司投保设置修改记录表")
    RestResponse<Void> removeInsuranceSettingsLog(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
