package com.dtyunxi.finance.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* 物流公司关联设置Eo对象
*
* @author longde
* @since 2022-07-15
*/
@Data
@ApiModel(value = "LogisticsSetttingsReqDto", description = "物流公司关联设置Eo对象")
public class LogisticsSetttingsReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;


    /**
     *  合同id
     */
    @ApiModelProperty(name = "contractId", value = "合同id")
    private Long contractId;

    /**
     *  合同名称
     */
    @ApiModelProperty(name = "contractName", value = "合同名称")
    private String contractName;

    /**
     *  物流商编码
     */
    @ApiModelProperty(name = "logisticsCode", value = "物流商编码")
    private String logisticsCode;

    /**
     *  承运方式(只能单个),0-海运,1-整车,2-整担
     */
    @ApiModelProperty(name = "modeOfCarriageCode", value = "承运方式(只能单个),0-海运,1-整车,2-整担")
    private String modeOfCarriageCode;


    /**
    *  保险公司ID（关联保险公司设置表主键id）
    */
    @ApiModelProperty(name = "insuranceCode", value = "保险公司ID（关联保险公司设置表主键id）")
    private Long insuranceCode;
    /**
    *  产品折扣（在0至1之间，保存3位小数通常，最高允许4位）
    */
    @ApiModelProperty(name = "productInsuranceDiscount", value = "产品折扣（在0至1之间，保存3位小数通常，最高允许4位）")
    private BigDecimal productInsuranceDiscount;
    /**
    *  物料折扣（在0至1之间，保存3位小数通常，最高允许4位）
    */
    @ApiModelProperty(name = "materialInsuranceDiscount", value = "物料折扣（在0至1之间，保存3位小数通常，最高允许4位）")
    private BigDecimal materialInsuranceDiscount;
    /**
    *  有效日期起
    */
    @ApiModelProperty(name = "effectiveStartTime", value = "有效日期起")
    private Date effectiveStartTime;
    /**
    *  有效日期止
    */
    @ApiModelProperty(name = "effectiveEndTime", value = "有效日期止")
    private Date effectiveEndTime;
    /**
    *  备注，前端页显示，填写一些说明信息或修改信息
    */
    @ApiModelProperty(name = "remark", value = "备注，前端页显示，填写一些说明信息或修改信息")
    private String remark;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  状态0未作废、1已作废
    */
    @ApiModelProperty(name = "status", value = "状态0未作废、1已作废")
    private Integer status;
    /**
     * 账单额度校验 1 开，0 关
     */
    @ApiModelProperty(name = "billQuotaVerify", value = "账单额度校验 1 开，0 关")
    private Integer billQuotaVerify;
    @ApiModelProperty(name = "logisticsTypeName", value = "承运方式名称")
    private String logisticsTypeName;

}
