/**
 * @(#) FeeAttributionConfigRespDto.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.finance.api.dto.response;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.validation.Valid;
import javax.validation.constraints.*;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;
import javax.annotation.Generated;

import lombok.Data;
import com.dtyunxi.vo.BaseVo;

/**
 * FeeAttributionConfigRespDto
 */
@Data
@ApiModel(value = "FeeAttributionConfigRespDto", description = "")
public class FeeAttributionConfigRespDto extends BaseVo{

  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  protected String createPerson;

  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  protected Date createTime;

  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  protected String updatePerson;

  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  protected Date updateTime;
  
  
  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id = null;
  
  
  @ApiModelProperty(name="inWarehouseName", value = "调入仓")
  @JsonProperty("inWarehouseName")
  private String inWarehouseName;
  
  
  @ApiModelProperty(name="inWarehouseCode", value = "调入仓编码")
  @JsonProperty("inWarehouseCode")
  private String inWarehouseCode;
  
  
  @ApiModelProperty(name="outWarehouseName", value = "调出仓")
  @JsonProperty("outWarehouseName")
  private String outWarehouseName;
  
  
  @ApiModelProperty(name="outWarehouseCode", value = "调出仓编码")
  @JsonProperty("outWarehouseCode")
  private String outWarehouseCode;

  /**
   *  调出库存组织编码
   */
  @ApiModelProperty(name="outOrgId", value = "调出库存组织编码")
  @JsonProperty("outOrgId")
  private Long outOrgId;

  /**
   *  调出库存组织编码
   */
  @ApiModelProperty(name="outOrgCode", value = "调出库存组织编码")
  @JsonProperty("outOrgCode")
  private String outOrgCode;

  /**
   *  调出库存组织名称
   */
  @ApiModelProperty(name="outOrgName", value = "调出库存组织编码")
  @JsonProperty("outOrgName")
  private String outOrgName;
  /**
   *  调入库存组织编码
   */
  @ApiModelProperty(name="inOrgId", value = "调出库存组织编码")
  @JsonProperty("inOrgId")
  private Long inOrgId;

  /**
   *  调入库存组织编码
   */
  @ApiModelProperty(name="inOrgCode", value = "调出库存组织编码")
  @JsonProperty("inOrgCode")
  private String inOrgCode;

  /**
   *  调入库存组织名称
   */
  @ApiModelProperty(name="inOrgName", value = "调出库存组织编码")
  @JsonProperty("inOrgName")
  private String inOrgName;

  @NotNull
  @ApiModelProperty(name="costBelongOrgId", required = true, value = "费用归属组织id")
  @JsonProperty("costBelongOrgId")
  private Long costBelongOrgId;

  @NotNull
  @ApiModelProperty(name="costBelongOrgCode", required = true, value = "费用归属组织编码")
  @JsonProperty("costBelongOrgCode")
  private String costBelongOrgCode;

  @NotNull
  @ApiModelProperty(name="costBelongOrgName", required = true, value = "费用归属组织名称")
  @JsonProperty("costBelongOrgName")
  private String costBelongOrgName;
  
  
  @ApiModelProperty(name="remark", value = "备注")
  @JsonProperty("remark")
  private String remark;
  
}

