package com.dtyunxi.finance.api.exception;

import lombok.Getter;

@Getter
public enum LogisticRecordStatusEnum {

    //0待生效，1生效中，2已失效 3已作废
    INITIALIZE(0,"待生效"),
    AMONG(1,"生效中"),
    FAILURE(2,"已失效"),
    INVALID(3,"已作废"),
    DRAFT(4,"草稿"),
    AMONG_FAILURE(10,"生效中和已失效数据"),
    HAS_EXIST(99,"同时间段内重复")
    ;

    private Integer type;
    private String name;

    LogisticRecordStatusEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }
}
