package com.dtyunxi.finance.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.CloseAccSettingReqDto;
import com.dtyunxi.finance.api.dto.response.CloseAccSettingRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 财务关账设置服务接口
*
* @author mc
* @since 2022-11-02
*/
@Api(tags = {"财务关账设置服务"})
@FeignClient(
        contextId = "com-dtyunxi-finance-api-ICloseAccSettingQueryApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/closeAcc",
        url = "${com.dtyunxi.finance.api:}"
)
public interface ICloseAccSettingQueryApi {

    /**
    * 根据id查询财务关账设置
    *
    * @param id 财务关账设置id
    * @return   财务关账设置数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询财务关账设置", notes = "根据id查询财务关账设置")
    RestResponse<CloseAccSettingRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 财务关账设置分页数据
    *
    * @param reqDto   财务关账设置查询条件
    * @return 财务关账设置分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "财务关账设置分页数据", notes = "根据filter查询条件查询财务关账设置数据，filter=CloseAccSettingReqDto")
    RestResponse<PageInfo<CloseAccSettingRespDto>> queryByPage(@RequestBody CloseAccSettingReqDto reqDto);

}
