/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.bulelakespider.service;

import com.dtyunxi.finance.biz.bulelakespider.model.IndexPage;
import com.dtyunxi.finance.biz.bulelakespider.model.SpiderResult;
import com.dtyunxi.finance.biz.bulelakespider.service.IDataWebSpider;
import com.dtyunxi.finance.biz.bulelakespider.service.IIndexWebSpider;
import com.dtyunxi.finance.biz.bulelakespider.service.IProcessWebSpider;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.processor.PageProcessor;

public abstract class ProcessWebSpider
implements IProcessWebSpider {
    private String uriBefore;
    private String uriAfter;
    private String indexUri;

    public String getUriBefore() {
        return this.uriBefore;
    }

    public String getUriAfter() {
        return this.uriAfter;
    }

    public String getIndexUri() {
        return this.indexUri;
    }

    public void setUriBefore(String uriBefore) {
        this.uriBefore = uriBefore;
    }

    public void setUriAfter(String uriAfter) {
        this.uriAfter = uriAfter;
    }

    public void setIndexUri(String indexUri) {
        this.indexUri = indexUri;
    }

    public ProcessWebSpider() {
    }

    public ProcessWebSpider(String uriBefore, String uriAfter, String indexUri) {
        this.uriBefore = uriBefore;
        this.uriAfter = uriAfter;
        this.indexUri = indexUri;
    }

    @Override
    public SpiderResult process(IIndexWebSpider indexWebSpider, IDataWebSpider dataWebSpider, String uriBefore, String uriAfter, String indexUri) {
        String link = ProcessWebSpider.getLink(indexWebSpider, uriBefore, uriAfter, indexUri);
        String liter = ProcessWebSpider.getLiter(link, dataWebSpider);
        IndexPage indexPage = indexWebSpider.getIndexPage();
        SpiderResult spiderResult = new SpiderResult();
        spiderResult.setLiter(liter);
        spiderResult.setAdjustTime(indexPage.getTime());
        spiderResult.setUrl(indexPage.getLink());
        return spiderResult;
    }

    public SpiderResult process(IIndexWebSpider indexWebSpider, IDataWebSpider dataWebSpider) {
        if (this.uriBefore != null && this.uriAfter != null && this.indexUri != null) {
            return this.process(indexWebSpider, dataWebSpider, this.uriBefore, this.uriAfter, this.indexUri);
        }
        throw new NullPointerException("\u8def\u5f84\u672a\u8bbe\u7f6e\uff01");
    }

    protected static String getLink(IIndexWebSpider indexWebSpider, String uriBefore, String uriAfter, String indexUri) {
        String nextUri = null;
        int pageIndex = 0;
        String uri = indexUri;
        Request request = new Request(uri);
        request.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36");
        while (pageIndex <= 10) {
            if (pageIndex++ > 0) {
                uri = uriBefore + pageIndex + uriAfter;
                request = new Request(uri);
            }
            Spider.create((PageProcessor)indexWebSpider).addRequest(new Request[]{request}).thread(1).run();
            if (indexWebSpider.getNextUri() == null) continue;
            nextUri = indexWebSpider.getNextUri();
            break;
        }
        return nextUri;
    }

    protected static String getLiter(String nextUri, IDataWebSpider dataWebSpider) {
        Request request = new Request(nextUri);
        request.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36");
        Spider.create((PageProcessor)dataWebSpider).addRequest(new Request[]{request}).thread(1).run();
        return dataWebSpider.getMaxLiter();
    }

    public abstract SpiderResult process();
}

