/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.VolumeLadderInfoDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.finance.api.exception.SeasonTypeEnum;
import com.dtyunxi.finance.biz.service.query.IAppointAreaQueryService;
import com.dtyunxi.finance.dao.das.AppointAreaDas;
import com.dtyunxi.finance.dao.das.LogisticRecordDas;
import com.dtyunxi.finance.dao.eo.AppointAreaEo;
import com.dtyunxi.finance.dao.eo.LogisticRecordEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppointAreaQueryServiceImpl
implements IAppointAreaQueryService {
    private static final Logger log = LoggerFactory.getLogger(AppointAreaQueryServiceImpl.class);
    @Resource
    private AppointAreaDas appointAreaDas;
    @Resource
    private LogisticRecordDas logisticRecordDas;

    @Override
    public PageInfo<AppointAreaQueryRespDto> queryByPage(AppointAreaQueryReqDto queryReqDto) {
        PageHelper.startPage((int)queryReqDto.getPageNum(), (int)queryReqDto.getPageSize());
        AppointAreaEo appointAreaEo = new AppointAreaEo();
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getTemplateId())) {
            appointAreaEo.setTemplateId(Long.valueOf(queryReqDto.getTemplateId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getProvince())) {
            appointAreaEo.setProvince(queryReqDto.getProvince());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getCity())) {
            appointAreaEo.setCity(queryReqDto.getCity());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getArea())) {
            appointAreaEo.setArea(queryReqDto.getArea());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getFlag())) {
            appointAreaEo.setFlag(queryReqDto.getFlag());
        }
        PageInfo eoPageInfo = new PageInfo(this.appointAreaDas.queryByPage(appointAreaEo));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)list, AppointAreaQueryRespDto.class);
        LogisticRecordEo logisticRecordEo = (LogisticRecordEo)((ExtQueryChainWrapper)this.logisticRecordDas.filter().eq((Object)"id", (Object)queryReqDto.getTemplateId())).one();
        log.info("logisticRecordEo=====:{}", (Object)JSON.toJSONString((Object)logisticRecordEo));
        for (AppointAreaQueryRespDto respDto : list) {
            HashMap bizParams = new HashMap();
            if (StringUtils.isNotEmpty((CharSequence)respDto.getParams())) {
                JSONObject jsonObject = JSONObject.parseObject((String)respDto.getParams());
                for (Object map : jsonObject.entrySet()) {
                    bizParams.put(((Map.Entry)map).getKey().toString(), ((Map.Entry)map).getValue());
                }
                respDto.setBizParams(bizParams);
            }
            if (!Objects.equals(logisticRecordEo.getChargeMode(), ChargeModeEnum.TRANSPORT.getType()) || !Objects.equals(logisticRecordEo.getSeasonType(), SeasonTypeEnum.COMMON.getType()) || !StringUtils.isNotBlank((CharSequence)respDto.getVolumeLadder())) continue;
            List details = JSON.parseArray((String)respDto.getVolumeLadder(), VolumeLadderInfoDto.class);
            details = details.stream().sorted(Comparator.comparing(VolumeLadderInfoDto::getSort)).collect(Collectors.toList());
            String price = "";
            for (int i = 0; i < details.size(); ++i) {
                VolumeLadderInfoDto volumeLadderInfoDto = (VolumeLadderInfoDto)details.get(i);
                price = i != details.size() - 1 ? price + String.format("%sm\u00b3<X<=%sm\u00b3,\u8fd0\u8d39%s\u5143;", volumeLadderInfoDto.getMin(), volumeLadderInfoDto.getMax(), volumeLadderInfoDto.getPrice()) : price + String.format(">=%sm\u00b3,\u8fd0\u8d39%s\u5143", volumeLadderInfoDto.getMin(), volumeLadderInfoDto.getPrice());
            }
            respDto.setPrice(price);
            respDto.setDetails(details);
        }
        dtoPageInfo.setList((List)list);
        return dtoPageInfo;
    }
}

