/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.StorageContractDetailReqDto;
import com.dtyunxi.finance.api.dto.request.StorageContractReqDto;
import com.dtyunxi.finance.api.dto.response.StorageContractDetailRespDto;
import com.dtyunxi.finance.api.dto.response.StorageContractRespDto;
import com.dtyunxi.finance.api.exception.StorageContractEnum;
import com.dtyunxi.finance.biz.service.IStorageContractService;
import com.dtyunxi.finance.dao.das.StorageContractChangeRecordDas;
import com.dtyunxi.finance.dao.das.StorageContractDas;
import com.dtyunxi.finance.dao.das.StorageContractDetailDas;
import com.dtyunxi.finance.dao.eo.StorageContractChangeRecordEo;
import com.dtyunxi.finance.dao.eo.StorageContractDetailEo;
import com.dtyunxi.finance.dao.eo.StorageContractEo;
import com.dtyunxi.finance.dao.mapper.StorageContractMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageContractServiceImpl
implements IStorageContractService {
    @Resource
    private StorageContractMapper storageContractMapper;
    @Resource
    private StorageContractDas storageContractDas;
    @Resource
    private StorageContractDetailDas storageContractDetailDas;
    @Resource
    private StorageContractChangeRecordDas storageContractChangeRecordDas;

    public static void main(String[] args) {
        Date date1 = DateUtil.addDays((Date)new Date(), (int)-1);
        System.out.println(com.dtyunxi.util.DateUtil.format((Date)date1, (String)"yyyy-MM-dd HH:mm:ss"));
        Date dayBegin = DateUtil.getDayBegin((Date)date1);
        System.out.println(com.dtyunxi.util.DateUtil.format((Date)dayBegin, (String)"yyyy-MM-dd HH:mm:ss"));
    }

    @Override
    public List<StorageContractRespDto> addStorageContract(StorageContractReqDto addReqDto) {
        StorageContractEo storageContractEo = new StorageContractEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storageContractEo);
        List<StorageContractRespDto> conflictStorageContract = this.getConflictStorageContract(storageContractEo);
        List currentStorageContractDetailReqDtos = addReqDto.getStorageContractDetailReqDtoList();
        boolean judgeNotToModify = this.isJudgeNotToModify(storageContractEo, currentStorageContractDetailReqDtos, conflictStorageContract);
        if (judgeNotToModify) {
            return null;
        }
        if (conflictStorageContract.size() > 0) {
            return conflictStorageContract;
        }
        this.storageContractDas.insert((BaseEo)storageContractEo);
        ArrayList<StorageContractDetailEo> storageContractDetailEoList = new ArrayList<StorageContractDetailEo>();
        for (StorageContractDetailReqDto dto : currentStorageContractDetailReqDtos) {
            StorageContractDetailEo eo = new StorageContractDetailEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
            eo.setContractId(storageContractEo.getId());
            eo.setExtFields(addReqDto.getExtFields());
            eo.setInstanceId(addReqDto.getInstanceId());
            eo.setTenantId(addReqDto.getTenantId());
            storageContractDetailEoList.add(eo);
        }
        this.storageContractDetailDas.insertBatch(storageContractDetailEoList);
        StorageContractRespDto storageContractRespDto = new StorageContractRespDto();
        storageContractRespDto.setId(storageContractEo.getId());
        ArrayList<StorageContractRespDto> storageContractRespDtos = new ArrayList<StorageContractRespDto>();
        storageContractRespDtos.add(storageContractRespDto);
        return storageContractRespDtos;
    }

    @Override
    public List<StorageContractRespDto> modifyStorageContract(StorageContractReqDto modifyReqDto) {
        StorageContractEo storageContractEo = new StorageContractEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storageContractEo);
        List<StorageContractRespDto> conflictStorageContract = this.getConflictStorageContract(storageContractEo);
        List currentStorageContractDetailReqDtos = modifyReqDto.getStorageContractDetailReqDtoList();
        boolean judgeNotToModify = this.isJudgeNotToModify(storageContractEo, currentStorageContractDetailReqDtos, conflictStorageContract);
        if (judgeNotToModify) {
            return null;
        }
        if (conflictStorageContract.size() > 0) {
            return conflictStorageContract;
        }
        StorageContractEo oldContractEo = (StorageContractEo)this.storageContractDas.selectByPrimaryKey(modifyReqDto.getId());
        List storageContractDetailEos = this.storageContractDetailDas.queryByContractId(storageContractEo.getId());
        ArrayList<StorageContractDetailEo> insertStorageDetailEos = new ArrayList<StorageContractDetailEo>();
        List storageContractDetailReqDtoList = modifyReqDto.getStorageContractDetailReqDtoList();
        ArrayList<Date> contractTimeList = new ArrayList<Date>();
        ArrayList<BigDecimal> unitPriceList = new ArrayList<BigDecimal>();
        for (StorageContractDetailReqDto reqDto : storageContractDetailReqDtoList) {
            contractTimeList.add(reqDto.getContractTime());
            unitPriceList.add(reqDto.getUnitPrice());
        }
        List<StorageContractChangeRecordEo> storageContractChangeRecordEos = this.getStorageContractChangeRecordEos(modifyReqDto, oldContractEo, storageContractDetailEos, contractTimeList, unitPriceList);
        if (storageContractChangeRecordEos.size() == 0) {
            return null;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (StorageContractDetailEo detailEo : storageContractDetailEos) {
            ids.add(detailEo.getId());
        }
        for (int i = 0; contractTimeList.size() > 0 && i < contractTimeList.size(); ++i) {
            StorageContractDetailEo storageContractDetailEo = new StorageContractDetailEo();
            storageContractDetailEo.setContractId(modifyReqDto.getId());
            storageContractDetailEo.setUnitPrice((BigDecimal)unitPriceList.get(i));
            storageContractDetailEo.setContractTime((Date)contractTimeList.get(i));
            storageContractDetailEo.setTenantId(modifyReqDto.getTenantId());
            storageContractDetailEo.setInstanceId(modifyReqDto.getInstanceId());
            insertStorageDetailEos.add(storageContractDetailEo);
        }
        this.storageContractDas.updateSelective((BaseEo)storageContractEo);
        this.storageContractChangeRecordDas.insertBatch(storageContractChangeRecordEos);
        if (ids.size() != 0) {
            this.storageContractDetailDas.deleteByIds(ids);
            this.storageContractDetailDas.insertBatch(insertStorageDetailEos);
        }
        return new ArrayList<StorageContractRespDto>();
    }

    private List<StorageContractChangeRecordEo> getStorageContractChangeRecordEos(StorageContractReqDto modifyReqDto, StorageContractEo oldStorageContractEo, List<StorageContractDetailEo> storageContractDetailEos, List<Date> contractTimeList, List<BigDecimal> unitPriceList) {
        Date oldTime;
        int i;
        LinkedList<StorageContractChangeRecordEo> storageContractChangeRecordEos = new LinkedList<StorageContractChangeRecordEo>();
        String oldContractName = oldStorageContractEo.getContractName();
        if (StringUtils.isNotEmpty((CharSequence)modifyReqDto.getContractName()) && !oldContractName.equals(modifyReqDto.getContractName())) {
            StorageContractChangeRecordEo storageContractChangeRecordEo = new StorageContractChangeRecordEo();
            storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
            storageContractChangeRecordEo.setField("\u5408\u540c\u540d\u79f0");
            storageContractChangeRecordEo.setFieldAfterValue(modifyReqDto.getContractName());
            storageContractChangeRecordEo.setFieldBeforeValue(oldContractName);
            storageContractChangeRecordEos.add(storageContractChangeRecordEo);
        }
        Integer oldChargeMode = oldStorageContractEo.getChargeMode();
        if (modifyReqDto.getChargeMode() != null && !oldChargeMode.equals(modifyReqDto.getChargeMode())) {
            StorageContractChangeRecordEo storageContractChangeRecordEo = new StorageContractChangeRecordEo();
            storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
            storageContractChangeRecordEo.setField("\u8ba1\u7b97\u65b9\u5f0f");
            storageContractChangeRecordEo.setFieldAfterValue(String.valueOf(modifyReqDto.getChargeMode()));
            storageContractChangeRecordEo.setFieldBeforeValue(String.valueOf(oldChargeMode));
            storageContractChangeRecordEos.add(storageContractChangeRecordEo);
        }
        String oldWarehouseName = oldStorageContractEo.getWarehouseName();
        if (StringUtils.isNotEmpty((CharSequence)modifyReqDto.getWarehouseName()) && !oldWarehouseName.equals(modifyReqDto.getWarehouseName())) {
            StorageContractChangeRecordEo storageContractChangeRecordEo = new StorageContractChangeRecordEo();
            storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
            storageContractChangeRecordEo.setField("\u7269\u7406\u4ed3");
            storageContractChangeRecordEo.setFieldAfterValue(modifyReqDto.getWarehouseName());
            storageContractChangeRecordEo.setFieldBeforeValue(oldWarehouseName);
            storageContractChangeRecordEos.add(storageContractChangeRecordEo);
        }
        Integer oldContractAverageSupport = oldStorageContractEo.getContractAverageSupport();
        if (modifyReqDto.getContractAverageSupport() != null && !oldContractAverageSupport.equals(modifyReqDto.getContractAverageSupport())) {
            StorageContractChangeRecordEo storageContractChangeRecordEo = new StorageContractChangeRecordEo();
            storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
            storageContractChangeRecordEo.setField("\u6bcf\u6708\u65e5\u5747\u6700\u4f4e\u677f\u6570");
            storageContractChangeRecordEo.setFieldAfterValue(String.valueOf(modifyReqDto.getContractAverageSupport()));
            storageContractChangeRecordEo.setFieldBeforeValue(String.valueOf(oldContractAverageSupport));
            storageContractChangeRecordEos.add(storageContractChangeRecordEo);
        }
        Date oldValidStartTime = oldStorageContractEo.getValidStartTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (modifyReqDto.getValidStartTime() != null && modifyReqDto.getValidStartTime().compareTo(oldValidStartTime) != 0) {
            StorageContractChangeRecordEo storageContractChangeRecordEo = new StorageContractChangeRecordEo();
            storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
            storageContractChangeRecordEo.setField("\u6709\u6548\u5f00\u59cb\u65f6\u95f4");
            storageContractChangeRecordEo.setFieldAfterValue(dateFormat.format(modifyReqDto.getValidStartTime()));
            storageContractChangeRecordEo.setFieldBeforeValue(dateFormat.format(oldValidStartTime));
            storageContractChangeRecordEos.add(storageContractChangeRecordEo);
        }
        Date oldValidEndTime = oldStorageContractEo.getValidEndTime();
        if (modifyReqDto.getValidEndTime() != null && modifyReqDto.getValidEndTime().compareTo(oldValidEndTime) != 0) {
            StorageContractChangeRecordEo storageContractChangeRecordEo = new StorageContractChangeRecordEo();
            storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
            storageContractChangeRecordEo.setField("\u6709\u6548\u7ed3\u675f\u65f6\u95f4");
            storageContractChangeRecordEo.setFieldAfterValue(dateFormat.format(modifyReqDto.getValidEndTime()));
            storageContractChangeRecordEo.setFieldBeforeValue(dateFormat.format(oldValidEndTime));
            storageContractChangeRecordEos.add(storageContractChangeRecordEo);
        }
        LinkedList oldContractTimeList = new LinkedList();
        LinkedList oldUnitPriceList = new LinkedList();
        storageContractDetailEos.forEach(storageContractDetailEo -> {
            oldContractTimeList.add(storageContractDetailEo.getContractTime());
            oldUnitPriceList.add(storageContractDetailEo.getUnitPrice());
        });
        StorageContractChangeRecordEo storageContractChangeRecordEo = null;
        SimpleDateFormat dt = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        for (i = 0; i < oldContractTimeList.size(); ++i) {
            oldTime = (Date)oldContractTimeList.get(i);
            if (contractTimeList.contains(oldTime)) continue;
            storageContractChangeRecordEo = new StorageContractChangeRecordEo();
            storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
            storageContractChangeRecordEo.setField(dt.format(oldTime) + "\u7684\u4ed3\u50a8\u8d39\u5355\u4ef7\uff08\u5143\uff09");
            storageContractChangeRecordEo.setFieldAfterValue(null);
            storageContractChangeRecordEo.setFieldBeforeValue(String.valueOf(oldUnitPriceList.get(i)));
            storageContractChangeRecordEos.add(storageContractChangeRecordEo);
        }
        for (i = 0; i < oldContractTimeList.size(); ++i) {
            oldTime = (Date)oldContractTimeList.get(i);
            for (int j = 0; j < contractTimeList.size(); ++j) {
                if (contractTimeList.get(j).compareTo(oldTime) != 0 || unitPriceList.get(j).compareTo((BigDecimal)oldUnitPriceList.get(i)) == 0) continue;
                storageContractChangeRecordEo = new StorageContractChangeRecordEo();
                storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
                storageContractChangeRecordEo.setField(dt.format(oldTime) + "\u7684\u4ed3\u50a8\u8d39\u5355\u4ef7\uff08\u5143\uff09");
                storageContractChangeRecordEo.setFieldAfterValue(String.valueOf(unitPriceList.get(j)));
                storageContractChangeRecordEo.setFieldBeforeValue(String.valueOf(oldUnitPriceList.get(i)));
                storageContractChangeRecordEos.add(storageContractChangeRecordEo);
            }
        }
        for (i = 0; i < contractTimeList.size(); ++i) {
            Date newTime = contractTimeList.get(i);
            if (oldContractTimeList.contains(newTime)) continue;
            storageContractChangeRecordEo = new StorageContractChangeRecordEo();
            storageContractChangeRecordEo.setContractId(oldStorageContractEo.getId());
            storageContractChangeRecordEo.setField(dt.format(newTime) + "\u7684\u4ed3\u50a8\u8d39\u5355\u4ef7\uff08\u5143\uff09");
            storageContractChangeRecordEo.setFieldAfterValue(String.valueOf(unitPriceList.get(i)));
            storageContractChangeRecordEo.setFieldBeforeValue(null);
            storageContractChangeRecordEos.add(storageContractChangeRecordEo);
        }
        return storageContractChangeRecordEos;
    }

    private List<StorageContractRespDto> getConflictStorageContract(StorageContractEo storageContractEo) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)storageContractEo.getWarehouseName())) {
            wrapper = (QueryWrapper)wrapper.eq((Object)"warehouse_name", (Object)storageContractEo.getWarehouseName());
        }
        wrapper = (QueryWrapper)wrapper.and(queryWrapper -> {
            String startDate = "";
            String endDate = "";
            if (storageContractEo.getValidStartTime() != null) {
                startDate = DateFormatUtils.format((Date)storageContractEo.getValidStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (storageContractEo.getValidEndTime() != null) {
                endDate = DateFormatUtils.format((Date)storageContractEo.getValidEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (StringUtils.isNotEmpty((CharSequence)startDate) && StringUtils.isNotEmpty((CharSequence)endDate)) {
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.apply("UNIX_TIMESTAMP(valid_end_time) >= UNIX_TIMESTAMP('" + endDate + "')", new Object[0])).apply("UNIX_TIMESTAMP(valid_start_time) <= UNIX_TIMESTAMP('" + endDate + "')", new Object[0])).or()).apply("UNIX_TIMESTAMP(valid_end_time) >= UNIX_TIMESTAMP('" + startDate + "')", new Object[0])).apply("UNIX_TIMESTAMP(valid_start_time) <= UNIX_TIMESTAMP('" + startDate + "')", new Object[0])).or()).apply("UNIX_TIMESTAMP(valid_end_time) <= UNIX_TIMESTAMP('" + endDate + "')", new Object[0])).apply("UNIX_TIMESTAMP(valid_start_time) >= UNIX_TIMESTAMP('" + startDate + "')", new Object[0]);
            }
        });
        wrapper = (QueryWrapper)wrapper.eq((Object)"dr", (Object)0);
        if (storageContractEo.getId() != null) {
            wrapper = (QueryWrapper)wrapper.ne((Object)"id", (Object)storageContractEo.getId());
        }
        List storageContractEos = this.storageContractMapper.selectList((Wrapper)wrapper);
        ArrayList<StorageContractRespDto> storageContractRespDtos = new ArrayList<StorageContractRespDto>();
        for (StorageContractEo storageContractEo1 : storageContractEos) {
            StorageContractRespDto storageContractRespDto = new StorageContractRespDto();
            DtoHelper.eo2Dto((BaseEo)storageContractEo1, (BaseVo)storageContractRespDto);
            Integer status = this.getStatus(storageContractRespDto);
            if (!status.equals(0) && !status.equals(1)) continue;
            storageContractRespDto.setStatus(status);
            storageContractRespDtos.add(storageContractRespDto);
        }
        return storageContractRespDtos;
    }

    private boolean isJudgeNotToModify(StorageContractEo storageContractEo, List<StorageContractDetailReqDto> storageContractDetailReqDtos, List<StorageContractRespDto> storageContractRespDtos) {
        Date validEndTime;
        LinkedList<Date> contractTimeList = new LinkedList<Date>();
        Date validStartTime = storageContractEo.getValidStartTime();
        if (validStartTime.compareTo(validEndTime = storageContractEo.getValidEndTime()) > 0) {
            return true;
        }
        if (storageContractDetailReqDtos == null || storageContractDetailReqDtos.size() == 0) {
            return true;
        }
        for (StorageContractDetailReqDto storageContractDetailReqDto : storageContractDetailReqDtos) {
            if (storageContractDetailReqDto.getUnitPrice() == null) {
                return true;
            }
            contractTimeList.add(storageContractDetailReqDto.getContractTime());
        }
        Calendar startTime = Calendar.getInstance();
        startTime.setTime(validStartTime);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(validEndTime);
        while (startTime.compareTo(endTime) <= 0) {
            boolean judge = true;
            int startMonth = startTime.get(2);
            for (int i = 0; i < contractTimeList.size(); ++i) {
                Date nowMonth = (Date)contractTimeList.get(i);
                Calendar nowMonthTime = Calendar.getInstance();
                nowMonthTime.setTime(nowMonth);
                int month = nowMonthTime.get(2);
                if (startMonth != month) continue;
                judge = false;
                break;
            }
            if (judge) {
                return true;
            }
            startTime.add(2, 1);
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStorageContract(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            Long idl = Long.valueOf(id);
            this.storageContractDas.logicDeleteById(idl);
            this.storageContractDetailDas.logicDeleteByContractId(idl);
            this.storageContractChangeRecordDas.logicDeleteByContractId(idl);
        }
    }

    @Override
    public void modifyStorageContractOfIsCancel(String ids, int isCancel) {
        String[] isCancelIds;
        for (String id : isCancelIds = ids.split(",")) {
            this.storageContractDas.updateIsCancelById(Long.valueOf(id), isCancel);
        }
    }

    @Override
    public StorageContractRespDto queryById(Long id) {
        StorageContractEo storageContractEo = (StorageContractEo)this.storageContractDas.selectByPrimaryKey(id);
        List storageContractDetailEoList = this.storageContractDetailDas.queryByContractId(id);
        StorageContractRespDto storageContractRespDto = new StorageContractRespDto();
        ArrayList storageContractDetailRespDtos = new ArrayList();
        DtoHelper.eo2Dto((BaseEo)storageContractEo, (BaseVo)storageContractRespDto);
        storageContractDetailEoList.forEach(storageContractDetailEo -> {
            StorageContractDetailRespDto storageContractDetailRespDto = new StorageContractDetailRespDto();
            DtoHelper.eo2Dto((BaseEo)storageContractDetailEo, (BaseVo)storageContractDetailRespDto);
            storageContractDetailRespDtos.add(storageContractDetailRespDto);
        });
        storageContractRespDto.setStorageContractDetailRespDtoList(storageContractDetailRespDtos);
        return storageContractRespDto;
    }

    @Override
    public PageInfo<StorageContractRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StorageContractReqDto storageContractReqDto = (StorageContractReqDto)JSON.parseObject((String)filter, StorageContractReqDto.class);
        StorageContractEo storageContractEo = new StorageContractEo();
        DtoHelper.dto2Eo((BaseVo)storageContractReqDto, (BaseEo)storageContractEo);
        QueryWrapper<StorageContractEo> queryWrapper = this.getStorageContractEoQueryWrapper(storageContractReqDto, storageContractEo);
        IPage page = this.storageContractDas.getMapper().selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), queryWrapper);
        PageInfo eoPageInfo = new PageInfo(page.getRecords());
        eoPageInfo.setPageNum(pageNum.intValue());
        eoPageInfo.setPageSize(pageSize.intValue());
        eoPageInfo.setPages((int)page.getPages());
        eoPageInfo.setTotal(page.getTotal());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<StorageContractRespDto> dtoList = new ArrayList<StorageContractRespDto>();
        for (StorageContractEo storageContractEo1 : eoPageInfo.getList()) {
            StorageContractRespDto storageContractRespDto = new StorageContractRespDto();
            DtoHelper.eo2Dto((BaseEo)storageContractEo1, (BaseVo)storageContractRespDto);
            Integer status = this.getStatus(storageContractRespDto);
            storageContractRespDto.setStatus(status);
            dtoList.add(storageContractRespDto);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private QueryWrapper<StorageContractEo> getStorageContractEoQueryWrapper(StorageContractReqDto storageContractReqDto, StorageContractEo storageContractEo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)storageContractEo.getWarehouseCode())) {
            queryWrapper = (QueryWrapper)queryWrapper.eq((Object)"warehouse_code", (Object)storageContractEo.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)storageContractEo.getContractName())) {
            queryWrapper = (QueryWrapper)queryWrapper.like((Object)"contract_name", (Object)storageContractEo.getContractName());
        }
        queryWrapper = (QueryWrapper)queryWrapper.ne((Object)"dr", (Object)1);
        List stateList = storageContractReqDto.getStateList();
        String validStartTime = "valid_start_time";
        String validEndTime = "valid_end_time";
        String startDate = "";
        String endDate = "";
        if (storageContractReqDto.getValidStartTime() != null) {
            startDate = DateFormatUtils.format((Date)storageContractReqDto.getValidStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (storageContractReqDto.getValidEndTime() != null) {
            endDate = DateFormatUtils.format((Date)storageContractReqDto.getValidEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (stateList != null && !stateList.contains(StorageContractEnum.CANCEL)) {
            queryWrapper = (QueryWrapper)queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.isNull((Object)"is_cancel")).or()).ne((Object)"is_cancel", (Object)1);
            });
        }
        if (stateList != null && stateList.size() > 0) {
            queryWrapper = (QueryWrapper)queryWrapper.and(queryWrapper2 -> {
                String nowTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                String bigTime = " 23:59:59";
                String smallTime = " 00:00:00";
                for (StorageContractEnum orderState : stateList) {
                    switch (orderState) {
                        case TO_BE_EFFECTIVE: {
                            queryWrapper2 = (QueryWrapper)queryWrapper2.or(wrapper -> wrapper.apply("UNIX_TIMESTAMP(valid_start_time) > UNIX_TIMESTAMP('" + nowTime + bigTime + "')", new Object[0]));
                            break;
                        }
                        case TAKE_EFFECT: {
                            queryWrapper2 = (QueryWrapper)queryWrapper2.or(wrapper -> {
                                wrapper = (QueryWrapper)wrapper.apply("UNIX_TIMESTAMP(valid_start_time) <= UNIX_TIMESTAMP('" + nowTime + bigTime + "')", new Object[0]);
                                wrapper.apply("UNIX_TIMESTAMP(valid_end_time) >= UNIX_TIMESTAMP('" + nowTime + smallTime + "')", new Object[0]);
                            });
                            break;
                        }
                        case LOSE_EFFICACY: {
                            queryWrapper2 = (QueryWrapper)queryWrapper2.or(wrapper -> wrapper.apply("UNIX_TIMESTAMP(valid_end_time) < UNIX_TIMESTAMP('" + nowTime + smallTime + "')", new Object[0]));
                            break;
                        }
                        case CANCEL: {
                            queryWrapper2 = (QueryWrapper)queryWrapper2.or(wrapper -> wrapper.eq((Object)"is_cancel", (Object)1));
                            break;
                        }
                    }
                }
            });
        }
        if (StringUtils.isNotEmpty((CharSequence)storageContractReqDto.getValidYear())) {
            String validYear = storageContractReqDto.getValidYear();
            String lastTime = validYear + "-12-31 23:59:59";
            String startTime = validYear + "-01-01 00:00:00";
            queryWrapper = (QueryWrapper)((QueryWrapper)queryWrapper.apply("UNIX_TIMESTAMP(valid_start_time) <= UNIX_TIMESTAMP('" + lastTime + "')", new Object[0])).apply("UNIX_TIMESTAMP(valid_end_time) >= UNIX_TIMESTAMP('" + startTime + "')", new Object[0]);
        }
        queryWrapper = (QueryWrapper)queryWrapper.orderByDesc((Object)"create_time");
        return queryWrapper;
    }

    private Integer getStatus(StorageContractRespDto respDto) {
        Integer status = null;
        String validStartTime = "valid_start_time";
        String validEndTime = "valid_end_time";
        Date tStartDate = new Date();
        Date tEndDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (respDto.getValidStartTime() != null) {
            tStartDate = respDto.getValidStartTime();
        }
        if (respDto.getValidEndTime() != null) {
            tEndDate = respDto.getValidEndTime();
        }
        Date earliestTime = new Date();
        Date lastTime = new Date();
        try {
            earliestTime = dateFormat2.parse(dateFormat.format(new Date()) + " 00:00:00");
            lastTime = dateFormat2.parse(dateFormat.format(new Date()) + " 23:59:59");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (respDto.getIsCancel() != null && respDto.getIsCancel() == 1) {
            status = 3;
        } else if (earliestTime.compareTo(tStartDate) < 0) {
            status = 0;
        } else if (lastTime.compareTo(tStartDate) >= 0 && earliestTime.compareTo(tEndDate) <= 0) {
            status = 1;
        } else if (lastTime.compareTo(tEndDate) > 0) {
            status = 2;
        }
        return status;
    }
}

