/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.CarrierCorrectionConfigExtReqDto;
import com.dtyunxi.finance.api.dto.request.CarrierCorrectionConfigReqDto;
import com.dtyunxi.finance.api.dto.request.CarrierCorrectionConfigSaveReqDto;
import com.dtyunxi.finance.api.dto.response.CarrierCorrectionConfigExtRespDto;
import com.dtyunxi.finance.api.dto.response.CarrierCorrectionConfigRespDto;
import com.dtyunxi.finance.api.dto.response.CarrierDeliveryAddressRespDto;
import com.dtyunxi.finance.biz.service.ICarrierCorrectionConfigService;
import com.dtyunxi.finance.biz.service.ICarrierDeliveryAddressService;
import com.dtyunxi.finance.biz.util.AssertUtil;
import com.dtyunxi.finance.dao.das.CarrierCorrectionConfigDas;
import com.dtyunxi.finance.dao.eo.CarrierCorrectionConfigEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CarrierCorrectionConfigServiceImpl
implements ICarrierCorrectionConfigService {
    private static final Logger log = LoggerFactory.getLogger(CarrierCorrectionConfigServiceImpl.class);
    @Resource
    private CarrierCorrectionConfigDas configDas;
    @Resource
    private ICarrierDeliveryAddressService deliveryAddressService;

    @Override
    public void saveConfig(CarrierCorrectionConfigSaveReqDto addReqDto) {
        log.info("\u4fdd\u5b58\u627f\u8fd0\u65b9\u5f0f\u4fee\u6b63\u914d\u7f6e\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)addReqDto));
        this.checkParams(addReqDto);
        Long id = addReqDto.getId();
        List deliveryAddressList = addReqDto.getDeliveryAddressList();
        if (Objects.nonNull(id)) {
            CarrierCorrectionConfigEo configEo = (CarrierCorrectionConfigEo)this.configDas.selectByPrimaryKey(id);
            AssertUtil.isFalse(Objects.isNull(configEo), "\u627f\u8fd0\u65b9\u5f0f\u4fee\u6b63\u914d\u7f6e\u4e0d\u5b58\u5728");
            CarrierCorrectionConfigEo updateEo = new CarrierCorrectionConfigEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)updateEo);
            this.configDas.updateSelective((BaseEo)updateEo);
            this.deliveryAddressService.batchCreate(id, deliveryAddressList);
            return;
        }
        CarrierCorrectionConfigEo configEo = new CarrierCorrectionConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)configEo);
        this.configDas.insert((BaseEo)configEo);
        id = configEo.getId();
        this.deliveryAddressService.batchCreate(id, deliveryAddressList);
    }

    private void checkParams(CarrierCorrectionConfigSaveReqDto addReqDto) {
        String physicsWarehouseCode = addReqDto.getPhysicsWarehouseCode();
        String logisticsCompanyCode = addReqDto.getLogisticsCompanyCode();
        AssertUtil.isFalse(StrUtil.isBlank((CharSequence)physicsWarehouseCode), "\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse(StrUtil.isBlank((CharSequence)addReqDto.getPhysicsWarehouseName()), "\u7269\u7406\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse(StrUtil.isBlank((CharSequence)logisticsCompanyCode), "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse(StrUtil.isBlank((CharSequence)addReqDto.getLogisticsCompanyName()), "\u7269\u6d41\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Long id = addReqDto.getId();
        List configEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.configDas.filter().ne(Objects.nonNull(id), (Object)"id", (Object)id)).eq((Object)"physics_warehouse_code", (Object)physicsWarehouseCode)).eq((Object)"logistics_company_code", (Object)logisticsCompanyCode)).list(Integer.valueOf(1));
        AssertUtil.isFalse(CollUtil.isNotEmpty((Collection)configEos), "\u7269\u6d41\u4ed3\u4e0e\u7269\u6d41\u516c\u53f8\u5173\u8054\u5df2\u5b58\u5728");
    }

    @Override
    public List<CarrierCorrectionConfigExtRespDto> queryListByParams(CarrierCorrectionConfigExtReqDto reqDto) {
        List configEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.configDas.filter().in(CollUtil.isNotEmpty((Collection)reqDto.getPhysicsWarehouseCodeList()), (Object)"physics_warehouse_code", (Collection)reqDto.getPhysicsWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getPhysicsWarehouseCodeList()), (Object)"logistics_company_code", (Collection)reqDto.getLogisticsCompanyCodeList())).list();
        if (CollUtil.isEmpty((Collection)configEos)) {
            return Collections.emptyList();
        }
        return configEos.stream().map(this::getByEo).collect(Collectors.toList());
    }

    @Override
    public CarrierCorrectionConfigExtRespDto queryByParams(CarrierCorrectionConfigReqDto reqDto) {
        CarrierCorrectionConfigEo eo = new CarrierCorrectionConfigEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        List configEos = this.configDas.select((BaseEo)eo);
        if (CollectionUtils.isEmpty((Collection)configEos)) {
            return null;
        }
        CarrierCorrectionConfigEo configEo = (CarrierCorrectionConfigEo)configEos.get(0);
        return this.getByEo(configEo);
    }

    private CarrierCorrectionConfigExtRespDto getByEo(CarrierCorrectionConfigEo configEo) {
        if (Objects.isNull(configEo)) {
            return null;
        }
        Long id = configEo.getId();
        CarrierCorrectionConfigExtRespDto configRespDto = new CarrierCorrectionConfigExtRespDto();
        DtoHelper.eo2Dto((BaseEo)configEo, (BaseVo)configRespDto);
        List<CarrierDeliveryAddressRespDto> deliveryAddressList = this.deliveryAddressService.getByCarrierCorrectionId(id);
        configRespDto.setDeliveryAddressList(deliveryAddressList);
        return configRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCarrierCorrectionConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.configDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CarrierCorrectionConfigRespDto queryById(Long id) {
        CarrierCorrectionConfigEo carrierCorrectionConfigEo = (CarrierCorrectionConfigEo)this.configDas.selectByPrimaryKey(id);
        CarrierCorrectionConfigRespDto carrierCorrectionConfigRespDto = new CarrierCorrectionConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)carrierCorrectionConfigEo, (BaseVo)carrierCorrectionConfigRespDto);
        return carrierCorrectionConfigRespDto;
    }

    @Override
    public PageInfo<CarrierCorrectionConfigExtRespDto> queryByPage(CarrierCorrectionConfigExtReqDto reqDto, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo eoPageInfo = new PageInfo(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.configDas.filter().in(CollUtil.isNotEmpty((Collection)reqDto.getPhysicsWarehouseCodeList()), (Object)"physics_warehouse_code", (Collection)reqDto.getPhysicsWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getLogisticsCompanyCodeList()), (Object)"logistics_company_code", (Collection)reqDto.getLogisticsCompanyCodeList())).orderByDesc((Object)"create_time")).list());
        PageInfo dtoPageInfo = new PageInfo();
        List configEos = eoPageInfo.getList();
        if (CollUtil.isEmpty((Collection)configEos)) {
            return dtoPageInfo;
        }
        List extRespDtos = configEos.stream().map(this::getByEo).collect(Collectors.toList());
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(extRespDtos);
        return dtoPageInfo;
    }
}

