/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.bulelakespider.service.tj;

import com.dtyunxi.finance.biz.bulelakespider.model.IndexPage;
import com.dtyunxi.finance.biz.bulelakespider.service.IIndexWebSpider;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.processor.PageProcessor;

public class TJIndexWebSpider
implements IIndexWebSpider {
    private final Site site = Site.me().setRetryTimes(3).setSleepTime(100);
    private String nextUri;
    private final List<IndexPage> indexPageList = new ArrayList<IndexPage>();

    public void process(Page page) {
        List s = page.getHtml().$(".list-main-group").all();
        String pattern = "isDownLoad[\\s,\\S]+?'(.+?)'[\\s,\\S]+?title=\"(.+?)\"[\\s,\\S]+?list-main-date\">(.+?)<";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher((CharSequence)s.get(0));
        this.extracted(m);
        IndexPage maxPage = this.getIndexPage();
        if (maxPage == null) {
            throw new NullPointerException();
        }
        this.nextUri = maxPage.getLink();
    }

    private void extracted(Matcher m) {
        while (m.find()) {
            IndexPage indexPage = new IndexPage();
            Date date = new Date();
            String link = m.group(1);
            String title = m.group(2);
            String time = m.group(3);
            try {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(time);
                System.out.println(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            indexPage.setTime(date);
            indexPage.setTitle(title);
            indexPage.setLink(link);
            this.indexPageList.add(indexPage);
        }
    }

    @Override
    public IndexPage getIndexPage() {
        IndexPage maxIndexPage = null;
        for (IndexPage page1 : this.indexPageList) {
            if (!page1.getTitle().contains("\u8c03\u6574\u6211\u5e02\u6210\u54c1\u6cb9")) continue;
            if (maxIndexPage == null) {
                maxIndexPage = new IndexPage(page1.getTime(), page1.getTitle(), page1.getLink());
                continue;
            }
            if (page1.getTime().compareTo(maxIndexPage.getTime()) <= 0) continue;
            maxIndexPage = page1;
        }
        return maxIndexPage;
    }

    @Override
    public String getNextUri() {
        return this.nextUri;
    }

    public Site getSite() {
        return this.site;
    }

    public static void main(String[] args) {
        TJIndexWebSpider tjIndexWebSpider = new TJIndexWebSpider();
        Spider spider = Spider.create((PageProcessor)tjIndexWebSpider).addUrl(new String[]{"https://fzgg.tj.gov.cn/xxfb/tzggx/"});
        spider.thread(1).run();
        String nextUri = tjIndexWebSpider.getNextUri();
        System.out.println(nextUri);
    }
}

