/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.finance.api.dto.request.CloseAccSettingEnableReqDto;
import com.dtyunxi.finance.api.dto.request.CloseAccSettingReqDto;
import com.dtyunxi.finance.api.dto.response.CloseAccSettingRespDto;
import com.dtyunxi.finance.biz.service.ICloseAccSettingService;
import com.dtyunxi.finance.biz.util.AssertUtil;
import com.dtyunxi.finance.biz.util.CodeGenerateUtil;
import com.dtyunxi.finance.dao.das.CloseAccSettingDas;
import com.dtyunxi.finance.dao.eo.CloseAccSettingEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CloseAccSettingServiceImpl
implements ICloseAccSettingService {
    @Resource
    private CloseAccSettingDas closeAccSettingDas;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;

    @Override
    public Long addCloseAccSetting(CloseAccSettingReqDto addReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getOrganizationCode()), "\u8d22\u52a1\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getCloseTime()), "\u5173\u8d26\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(this.closeAccSettingDas.selectByLogicKey((Object)addReqDto.getOrganizationCode())), String.format("\u8d22\u52a1\u7ec4\u7ec7\u5df2\u8bbe\u7f6e:%s", addReqDto.getOrganizationCode()));
        CloseAccSettingEo closeAccSettingEo = new CloseAccSettingEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)closeAccSettingEo);
        closeAccSettingEo.setCode(Optional.ofNullable(addReqDto.getCode()).orElseGet(() -> this.codeGenerateUtil.generateNo("PROD", 6)));
        this.closeAccSettingDas.insert((BaseEo)closeAccSettingEo);
        return closeAccSettingEo.getId();
    }

    @Override
    public void modifyCloseAccSetting(CloseAccSettingReqDto modifyReqDto) {
        CloseAccSettingEo closeAccSettingEo = new CloseAccSettingEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)closeAccSettingEo);
        this.closeAccSettingDas.updateSelective((BaseEo)closeAccSettingEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCloseAccSetting(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.closeAccSettingDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CloseAccSettingRespDto queryById(Long id) {
        CloseAccSettingEo closeAccSettingEo = (CloseAccSettingEo)this.closeAccSettingDas.selectByPrimaryKey(id);
        CloseAccSettingRespDto closeAccSettingRespDto = new CloseAccSettingRespDto();
        DtoHelper.eo2Dto((BaseEo)closeAccSettingEo, (BaseVo)closeAccSettingRespDto);
        return closeAccSettingRespDto;
    }

    @Override
    public PageInfo<CloseAccSettingRespDto> queryByPage(CloseAccSettingReqDto closeAccSettingReqDto) {
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.closeAccSettingDas.filter().eq(Objects.nonNull(closeAccSettingReqDto.getOrganizationId()), (Object)"organization_id", (Object)closeAccSettingReqDto.getOrganizationId())).eq(Objects.nonNull(closeAccSettingReqDto.getStatus()), (Object)"status", (Object)closeAccSettingReqDto.getStatus())).ge(Objects.nonNull(closeAccSettingReqDto.getCloseTimeStart()), (Object)"close_time", (Object)closeAccSettingReqDto.getCloseTimeStart())).le(Objects.nonNull(closeAccSettingReqDto.getCloseTimeEnd()), (Object)"close_time", (Object)closeAccSettingReqDto.getCloseTimeEnd())).ge(Objects.nonNull(closeAccSettingReqDto.getCreateTimeStart()), (Object)"create_time", (Object)closeAccSettingReqDto.getCreateTimeStart())).le(Objects.nonNull(closeAccSettingReqDto.getCreateTimeEnd()), (Object)"create_time", (Object)closeAccSettingReqDto.getCreateTimeEnd())).in(CollectionUtils.isNotEmpty((Collection)closeAccSettingReqDto.getOrganizationCodeSet()), (Object)"organization_code", (Collection)closeAccSettingReqDto.getOrganizationCodeSet())).in(CollectionUtils.isNotEmpty((Collection)closeAccSettingReqDto.getOrganizationIdSet()), (Object)"organization_id", (Collection)closeAccSettingReqDto.getOrganizationIdSet())).like(StringUtils.isNotBlank((CharSequence)closeAccSettingReqDto.getOrganizationCode()), (Object)"organization_code", (Object)closeAccSettingReqDto.getOrganizationCode())).like(StringUtils.isNotBlank((CharSequence)closeAccSettingReqDto.getOrganizationName()), (Object)"organization_name", (Object)closeAccSettingReqDto.getOrganizationCode())).like(StringUtils.isNotBlank((CharSequence)closeAccSettingReqDto.getCode()), (Object)"code", (Object)closeAccSettingReqDto.getCode())).orderByDesc((Object)"create_time")).page(closeAccSettingReqDto.getPageNum(), closeAccSettingReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CloseAccSettingRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void enable(CloseAccSettingEnableReqDto enableReqDto) {
        CloseAccSettingEo closeAccSettingEo = new CloseAccSettingEo();
        closeAccSettingEo.setStatus(enableReqDto.getStatus());
        closeAccSettingEo.setRemark(enableReqDto.getRemark());
        closeAccSettingEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", (Object)enableReqDto.getIds())}));
        this.closeAccSettingDas.updateSelectiveSqlFilter((BaseEo)closeAccSettingEo);
    }
}

