/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.EMSBkCostChargeMode;
import com.dtyunxi.finance.api.dto.EMSPackageCostChargeMode;
import com.dtyunxi.finance.api.dto.PriceLadderInfoDto;
import com.dtyunxi.finance.api.dto.SfBkCostChargeMode;
import com.dtyunxi.finance.api.dto.SfDsBkCostChargeModeDto;
import com.dtyunxi.finance.api.dto.SfKhCostChargeMode;
import com.dtyunxi.finance.api.dto.SfTkPackageCostChargeMode;
import com.dtyunxi.finance.api.dto.ZtoCostChargeMode;
import com.dtyunxi.finance.api.dto.request.ExpressAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.ExpressCostAreaReqDto;
import com.dtyunxi.finance.api.dto.request.ExpressCostContractQueryReqDto;
import com.dtyunxi.finance.api.dto.request.ExpressCostContractReqDto;
import com.dtyunxi.finance.api.dto.response.EmsTemplateDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostAreaRespDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostContractRespDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostContractSaveRespDto;
import com.dtyunxi.finance.api.dto.response.SfBkTemplateDto;
import com.dtyunxi.finance.api.dto.response.SfDsBkExpressAreaDto;
import com.dtyunxi.finance.api.dto.response.SfKhTemplateDto;
import com.dtyunxi.finance.api.dto.response.SfTkAndStoTemplateDto;
import com.dtyunxi.finance.api.dto.response.SfTkPackageTemplateDto;
import com.dtyunxi.finance.api.dto.response.ZtoTemplateDto;
import com.dtyunxi.finance.api.exception.ExpressCostChargeModeEnum;
import com.dtyunxi.finance.api.exception.LogisticRecordStatusEnum;
import com.dtyunxi.finance.biz.service.IExpressCostContractService;
import com.dtyunxi.finance.dao.das.ExpressCostAreaDas;
import com.dtyunxi.finance.dao.das.ExpressCostContractDas;
import com.dtyunxi.finance.dao.eo.ExpressCostAreaEo;
import com.dtyunxi.finance.dao.eo.ExpressCostContractEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExpressCostContractServiceImpl
implements IExpressCostContractService {
    private static final Logger log = LoggerFactory.getLogger(ExpressCostContractServiceImpl.class);
    @Resource
    private ExpressCostContractDas expressCostContractDas;
    @Resource
    private ExpressCostAreaDas expressCostAreaDas;

    @Override
    public Long addExpressCostContract(ExpressCostContractReqDto addReqDto) {
        ExpressCostContractEo expressCostContractEo = new ExpressCostContractEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)expressCostContractEo);
        this.expressCostContractDas.insert((BaseEo)expressCostContractEo);
        return expressCostContractEo.getId();
    }

    @Override
    public void modifyExpressCostContract(ExpressCostContractReqDto modifyReqDto) {
        ExpressCostContractEo expressCostContractEo = new ExpressCostContractEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)expressCostContractEo);
        this.expressCostContractDas.updateSelective((BaseEo)expressCostContractEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeExpressCostContract(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.expressCostContractDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ExpressCostContractRespDto queryById(Long id) {
        ExpressCostContractEo expressCostContractEo = (ExpressCostContractEo)this.expressCostContractDas.selectByPrimaryKey(id);
        ExpressCostContractRespDto expressCostContractRespDto = new ExpressCostContractRespDto();
        DtoHelper.eo2Dto((BaseEo)expressCostContractEo, (BaseVo)expressCostContractRespDto);
        this.handleChargeModeJsonToJavaBean(expressCostContractRespDto);
        this.assembleStatus(expressCostContractRespDto);
        return expressCostContractRespDto;
    }

    @Override
    public PageInfo<ExpressCostContractRespDto> queryByPage(ExpressCostContractQueryReqDto queryReqDto) {
        ExpressCostContractEo eo = new ExpressCostContractEo();
        BeanUtils.copyProperties((Object)queryReqDto, (Object)eo);
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getValidYear())) {
            eo.setStartValidYear(String.format("%s-%s", queryReqDto.getValidYear(), "01-01 00:00:00"));
            eo.setEndValidYear(String.format("%s-%s", queryReqDto.getValidYear(), "12-31 23:59:59"));
        }
        PageInfo eoPageInfo = this.expressCostContractDas.queryByPage(eo);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)list, ExpressCostContractRespDto.class);
        dtoPageInfo.setList((List)list);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ExpressCostContractSaveRespDto save(ExpressCostContractReqDto reqDto) {
        log.info("ExpressCostContract.save:{}", (Object)JSON.toJSONString((Object)reqDto));
        ExpressCostContractSaveRespDto respDto = new ExpressCostContractSaveRespDto();
        this.mandatoryFieldCheck(reqDto);
        this.checkTime(reqDto);
        List<ExpressCostContractRespDto> list = this.checkTimeOverlap(reqDto);
        if (CollectionUtil.isNotEmpty(list)) {
            respDto.setDetails(list);
            return respDto;
        }
        ExpressCostContractEo eo = new ExpressCostContractEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        this.handleChargeModeJson(reqDto, eo);
        if (reqDto.getId() == null || reqDto.getId() < 1L) {
            ExpressCostContractEo sourceEo;
            eo.setStatus(LogisticRecordStatusEnum.INITIALIZE.getType());
            this.expressCostContractDas.insert((BaseEo)eo);
            respDto.setId(eo.getId());
            if (reqDto.getCopyFlag().booleanValue() && reqDto.getSourceId() != null && reqDto.getSourceId() > 0L && (sourceEo = (ExpressCostContractEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)reqDto.getId())).last("limit 1")).one()) != null && Objects.equals(sourceEo.getChargeMode(), reqDto.getChargeMode())) {
                Boolean copyAreaFlag = false;
                if (Objects.equals(reqDto.getChargeMode(), ExpressCostChargeModeEnum.SF_KH.getType())) {
                    if (Objects.equals(sourceEo.getDiscountType(), reqDto.getDiscountType())) {
                        copyAreaFlag = true;
                    }
                } else {
                    copyAreaFlag = true;
                }
                if (copyAreaFlag.booleanValue()) {
                    List areaEos = ((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)reqDto.getSourceId())).list(Integer.valueOf(5000));
                    areaEos.stream().forEach(i -> {
                        i.setId(null);
                        i.setContractId(sourceEo.getId());
                    });
                    this.expressCostAreaDas.insertBatch(areaEos);
                }
            }
        } else {
            ExpressCostContractEo one = (ExpressCostContractEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)reqDto.getId())).last("limit 1")).one();
            if (one == null) {
                throw new BizException("\u7f16\u8f91ID\u4e0d\u6b63\u786e");
            }
            if (!Objects.equals(one.getChargeMode(), reqDto.getChargeMode())) {
                List areaEos = ((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)reqDto.getId())).list(Integer.valueOf(5000));
                if (CollectionUtil.isNotEmpty((Collection)areaEos)) {
                    areaEos.stream().forEach(i -> this.expressCostAreaDas.delete((BaseEo)i));
                }
                eo.setStatus(LogisticRecordStatusEnum.DRAFT.getType());
            }
            eo.setId(one.getId());
            eo.setStatus(one.getStatus());
            this.expressCostContractDas.update((BaseEo)eo);
            respDto.setId(eo.getId());
        }
        return respDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void nullify(String ids) {
        String[] nullifyIds = ids.split(",");
        List<String> idList = Arrays.asList(nullifyIds);
        List eos = ((ExtQueryChainWrapper)this.expressCostContractDas.filter().in((Object)"id", idList)).list(Integer.valueOf(idList.size()));
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            eos.forEach(i -> {
                i.setStatus(LogisticRecordStatusEnum.INVALID.getType());
                this.expressCostContractDas.updateSelective((BaseEo)i);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void areaSave(List<ExpressCostAreaReqDto> reqDtoList) {
        ExpressCostContractEo eo;
        if (CollectionUtil.isEmpty(reqDtoList)) {
            return;
        }
        Long contractId = reqDtoList.get(0).getContractId();
        List eos = ((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)contractId)).list(Integer.valueOf(2000));
        Map<Object, Object> eoMap1 = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            eoMap1 = eos.stream().collect(Collectors.toMap(ExpressCostAreaEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        }
        log.info("\u5feb\u9012\u8d39\u7528\u5bfc\u5165,eoMap1:{}", (Object)JSON.toJSONString((Object)eoMap1));
        Map<Object, Object> eoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            eoMap = eos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<ExpressCostAreaEo> insertEos = new ArrayList<ExpressCostAreaEo>();
        ArrayList<ExpressCostAreaEo> updateEos = new ArrayList<ExpressCostAreaEo>();
        if (CollectionUtils.isNotEmpty(reqDtoList)) {
            for (ExpressCostAreaReqDto areaReqDto : reqDtoList) {
                ExpressCostAreaEo areaEo = new ExpressCostAreaEo();
                BeanUtils.copyProperties((Object)areaReqDto, (Object)areaEo);
                areaEo.setContractId(areaReqDto.getContractId());
                String uniqueKey = areaEo.getUniqueKey();
                if (CollectionUtil.isNotEmpty((Map)eoMap1) && eoMap1.containsKey(uniqueKey)) {
                    areaEo.setId(((ExpressCostAreaEo)eoMap1.get(uniqueKey)).getId());
                    updateEos.add(areaEo);
                    continue;
                }
                insertEos.add(areaEo);
            }
        }
        if (CollectionUtils.isNotEmpty(insertEos)) {
            this.expressCostAreaDas.insertBatch(insertEos);
        }
        if (CollectionUtils.isNotEmpty(updateEos)) {
            updateEos.stream().forEach(i -> this.expressCostAreaDas.update((BaseEo)i));
        }
        if ((eo = (ExpressCostContractEo)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)contractId)).one()) != null) {
            eo.setStatus(LogisticRecordStatusEnum.INITIALIZE.getType());
            this.expressCostContractDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public PageInfo<ExpressCostAreaRespDto> queryAreaByPage(ExpressAreaQueryReqDto queryReqDto) {
        PageInfo dtoPageInfo = new PageInfo();
        if (queryReqDto.getContractId() == null) {
            return dtoPageInfo;
        }
        ExpressCostContractEo eo = (ExpressCostContractEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)queryReqDto.getContractId())).last("limit 1")).one();
        if (eo == null) {
            throw new BizException("\u5408\u540cid\u4e0d\u6b63\u786e");
        }
        ExpressCostAreaEo areaEo = new ExpressCostAreaEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)areaEo);
        PageHelper.startPage((int)queryReqDto.getPageNum(), (int)queryReqDto.getPageSize());
        PageInfo eoPageInfo = new PageInfo(this.expressCostAreaDas.queryByPage(areaEo));
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)list, ExpressCostAreaRespDto.class);
        dtoPageInfo.setList((List)list);
        if (CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
            Integer chargeMode = eo.getChargeMode();
            this.handleAreaParams(chargeMode, dtoPageInfo.getList());
        }
        return dtoPageInfo;
    }

    @Override
    public void areaEdit(ExpressCostAreaReqDto reqDto) {
        ExpressCostContractEo one = this.checkParams(reqDto);
        String params = this.handleParamsJavaBeanToJson(one.getChargeMode(), reqDto);
        ExpressCostAreaEo areaEo = new ExpressCostAreaEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)areaEo);
        if (StringUtils.isNotBlank((CharSequence)params)) {
            areaEo.setParams(params);
        }
        this.expressCostAreaDas.updateSelective((BaseEo)areaEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void areaRemoveAll(Long contractId) {
        ExpressCostContractEo eo;
        Integer pageNum = 1;
        ArrayList eos = Lists.newArrayList();
        while (true) {
            PageInfo pageInfo;
            if (CollectionUtil.isNotEmpty((Collection)(pageInfo = ((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)contractId)).page(pageNum, Integer.valueOf(5000))).getList())) {
                eos.addAll(pageInfo.getList());
            }
            if (pageInfo == null || CollectionUtil.isEmpty((Collection)pageInfo.getList()) || pageInfo.getList().size() < 5000) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            eos.forEach(i -> this.expressCostAreaDas.delete((BaseEo)i));
        }
        if ((eo = (ExpressCostContractEo)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)contractId)).one()) != null) {
            eo.setStatus(LogisticRecordStatusEnum.DRAFT.getType());
            this.expressCostContractDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void areaDel(Long id) {
        ExpressCostContractEo eo;
        ExpressCostAreaEo areaEo = (ExpressCostAreaEo)((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"id", (Object)id)).one();
        if (areaEo == null) {
            throw new BizException("\u5220\u9664Id\u4e0d\u6b63\u786e");
        }
        this.expressCostAreaDas.delete((BaseEo)areaEo);
        Integer count = ((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)areaEo.getContractId())).count();
        if ((count == null || Objects.equals(count, 0)) && (eo = (ExpressCostContractEo)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)areaEo.getContractId())).one()) != null) {
            eo.setStatus(LogisticRecordStatusEnum.DRAFT.getType());
            this.expressCostContractDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void areaAdd(ExpressCostAreaReqDto reqDto) {
        ExpressCostContractEo contractEo = this.addCheckParams(reqDto);
        String params = this.handleParamsJavaBeanToJson(contractEo.getChargeMode(), reqDto);
        ExpressCostAreaEo areaEo = new ExpressCostAreaEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)areaEo);
        if (StringUtils.isNotBlank((CharSequence)params)) {
            areaEo.setParams(params);
        }
        this.expressCostAreaDas.insert((BaseEo)areaEo);
    }

    @Override
    public List<ExpressCostAreaRespDto> queryAreaByAreaNames(ExpressAreaQueryReqDto reqDto) {
        if (reqDto.getContractId() == null) {
            throw new BizException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList list = Lists.newArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(ExpressCostAreaEo::getContractId, (Object)reqDto.getContractId())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getProvince()), ExpressCostAreaEo::getProvince, (Object)reqDto.getProvince())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getCity()), ExpressCostAreaEo::getCity, (Object)reqDto.getCity())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getArea()), ExpressCostAreaEo::getArea, (Object)reqDto.getArea());
        List expressCostAreaEos = this.expressCostAreaDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)expressCostAreaEos)) {
            CubeBeanUtils.copyCollection((Collection)list, (Collection)expressCostAreaEos, ExpressCostAreaRespDto.class);
        }
        return list;
    }

    private ExpressCostContractEo addCheckParams(ExpressCostAreaReqDto reqDto) {
        if (reqDto.getContractId() == null) {
            throw new BizException("\u5408\u540cId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getProvince())) {
            throw new BizException("\u5408\u540c\u533a\u57df\u65b0\u589e\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExpressCostContractEo one = (ExpressCostContractEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)reqDto.getContractId())).last("limit 1")).one();
        if (one == null) {
            throw new BizException("\u5408\u540cId\u4e0d\u6b63\u786e");
        }
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)reqDto.getContractId())).eq((Object)"province", (Object)reqDto.getProvince());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCity())) {
            filter.eq((Object)"city", (Object)reqDto.getCity());
        } else {
            filter.isNull((Object)"city");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getArea())) {
            filter.eq((Object)"area", (Object)reqDto.getArea());
        } else {
            filter.isNull((Object)"area");
        }
        Integer count = filter.count();
        if (count != null && count > 0) {
            throw new BizException("\u5408\u540c\u5bf9\u5e94\u7684\u533a\u57df\u4fe1\u606f\u5df2\u5b58\u5728");
        }
        return one;
    }

    private String handleParamsJavaBeanToJson(Integer chargeMode, ExpressCostAreaReqDto reqDto) {
        String params = "";
        switch (ExpressCostChargeModeEnum.getChargeMode((Integer)chargeMode)) {
            case SF_DS_BK: {
                if (reqDto.getSfDsBkExpressAreaInfo() == null) break;
                params = JSON.toJSONString((Object)reqDto.getSfDsBkExpressAreaInfo());
                break;
            }
            case SF_KH: {
                if (reqDto.getSfKhTemplateDto() == null) break;
                params = JSON.toJSONString((Object)reqDto.getSfKhTemplateDto());
                break;
            }
            case SF_EXPRESS: 
            case STO: {
                if (reqDto.getSfTkAndStoTemplateDto() == null) break;
                params = JSON.toJSONString((Object)reqDto.getSfTkAndStoTemplateDto());
                break;
            }
            case SF_EXPRESS_PACKAGE: {
                if (reqDto.getSfTkPackageTemplateDto() == null) break;
                params = JSON.toJSONString((Object)reqDto.getSfTkPackageTemplateDto());
                break;
            }
            case SF_BK: {
                if (reqDto.getSfBkTemplateDto() == null) break;
                params = JSON.toJSONString((Object)reqDto.getSfBkTemplateDto());
                break;
            }
            case ZTO: {
                if (reqDto.getZtoTemplateDto() == null) break;
                params = JSON.toJSONString((Object)reqDto.getZtoTemplateDto());
                break;
            }
            case EMS_BK: 
            case EMS_PACKAGE: {
                if (reqDto.getEmsTemplateDto() == null) break;
                params = JSON.toJSONString((Object)reqDto.getEmsTemplateDto());
                break;
            }
            default: {
                throw new BizException("\u5408\u540c\u8ba1\u7b97\u65b9\u5f0f\u9519\u8bef");
            }
        }
        return params;
    }

    private ExpressCostContractEo checkParams(ExpressCostAreaReqDto reqDto) {
        if (reqDto.getId() == null) {
            throw new BizException("\u7f16\u8f91ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDto.getContractId() == null) {
            throw new BizException("\u5408\u540cId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExpressCostAreaEo area = (ExpressCostAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"id", (Object)reqDto.getId())).last("limit 1")).one();
        if (area == null) {
            throw new BizException("\u7f16\u8f91ID\u4e0d\u6b63\u786e");
        }
        ExpressCostContractEo one = (ExpressCostContractEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)reqDto.getContractId())).last("limit 1")).one();
        if (one == null) {
            throw new BizException("\u5408\u540cId\u4e0d\u6b63\u786e");
        }
        return one;
    }

    private void handleAreaParams(Integer chargeMode, List<ExpressCostAreaRespDto> list) {
        log.info("chargeMode=====:{}", (Object)chargeMode);
        log.info("list=====:{}", (Object)JSON.toJSONString(list));
        ExpressCostChargeModeEnum chargeModeEnum = ExpressCostChargeModeEnum.getChargeMode((Integer)chargeMode);
        log.info("list=====:{}", (Object)JSON.toJSONString((Object)chargeModeEnum));
        switch (chargeModeEnum) {
            case SF_DS_BK: {
                list.forEach(i -> i.setSfDsBkExpressAreaInfo((SfDsBkExpressAreaDto)JSON.parseObject((String)i.getParams(), SfDsBkExpressAreaDto.class)));
                break;
            }
            case SF_KH: {
                list.forEach(i -> i.setSfKhTemplateDto((SfKhTemplateDto)JSON.parseObject((String)i.getParams(), SfKhTemplateDto.class)));
                break;
            }
            case SF_EXPRESS: 
            case STO: {
                list.forEach(i -> i.setSfTkAndStoTemplateDto((SfTkAndStoTemplateDto)JSON.parseObject((String)i.getParams(), SfTkAndStoTemplateDto.class)));
                break;
            }
            case SF_EXPRESS_PACKAGE: {
                list.forEach(i -> i.setSfTkPackageTemplateDto((SfTkPackageTemplateDto)JSON.parseObject((String)i.getParams(), SfTkPackageTemplateDto.class)));
                break;
            }
            case SF_BK: {
                list.forEach(i -> i.setSfBkTemplateDto((SfBkTemplateDto)JSON.parseObject((String)i.getParams(), SfBkTemplateDto.class)));
                break;
            }
            case ZTO: {
                list.forEach(i -> i.setZtoTemplateDto((ZtoTemplateDto)JSON.parseObject((String)i.getParams(), ZtoTemplateDto.class)));
                break;
            }
            case EMS_BK: 
            case EMS_PACKAGE: {
                list.forEach(i -> i.setEmsTemplateDto((EmsTemplateDto)JSON.parseObject((String)i.getParams(), EmsTemplateDto.class)));
                break;
            }
            default: {
                throw new BizException("\u5408\u540c\u8ba1\u7b97\u65b9\u5f0f\u9519\u8bef");
            }
        }
    }

    private void handleChargeModeJsonToJavaBean(ExpressCostContractRespDto respDto) {
        Integer chargeMode = respDto.getChargeMode();
        String params = respDto.getParams();
        if (StringUtils.isBlank((CharSequence)params)) {
            return;
        }
        switch (ExpressCostChargeModeEnum.getChargeMode((Integer)chargeMode)) {
            case SF_DS_BK: {
                SfDsBkCostChargeModeDto sfDsBkMode = (SfDsBkCostChargeModeDto)JSON.parseObject((String)params, SfDsBkCostChargeModeDto.class);
                respDto.setSfDsBkMode(sfDsBkMode);
                break;
            }
            case SF_KH: {
                String priceRange;
                SfKhCostChargeMode sfKhMode = (SfKhCostChargeMode)JSON.parseObject((String)params, SfKhCostChargeMode.class);
                respDto.setSfKhMode(sfKhMode);
                if (!Objects.equals(2, respDto.getDiscountType()) || !StringUtils.isNotBlank((CharSequence)(priceRange = respDto.getPriceRange()))) break;
                respDto.setPriceLadders(JSON.parseArray((String)priceRange, PriceLadderInfoDto.class));
                break;
            }
            case SF_EXPRESS: 
            case STO: {
                BigDecimal currencyModeFirstWeight = (BigDecimal)JSON.parseObject((String)params, BigDecimal.class);
                respDto.setCurrencyModeFirstWeight(currencyModeFirstWeight);
                break;
            }
            case SF_EXPRESS_PACKAGE: {
                SfTkPackageCostChargeMode sfTkPackageMode = (SfTkPackageCostChargeMode)JSON.parseObject((String)params, SfTkPackageCostChargeMode.class);
                respDto.setSfTkPackageMode(sfTkPackageMode);
                break;
            }
            case SF_BK: {
                SfBkCostChargeMode sfBkMode = (SfBkCostChargeMode)JSON.parseObject((String)params, SfBkCostChargeMode.class);
                respDto.setSfBkMode(sfBkMode);
                break;
            }
            case ZTO: {
                ZtoCostChargeMode ztoCostChargeMode = (ZtoCostChargeMode)JSON.parseObject((String)params, ZtoCostChargeMode.class);
                respDto.setzToMode(ztoCostChargeMode);
                break;
            }
            case EMS_BK: {
                EMSBkCostChargeMode emsBkCostChargeMode = (EMSBkCostChargeMode)JSON.parseObject((String)params, EMSBkCostChargeMode.class);
                respDto.seteMsBkMode(emsBkCostChargeMode);
                break;
            }
            case EMS_PACKAGE: {
                EMSPackageCostChargeMode emsPackageCostChargeMode = (EMSPackageCostChargeMode)JSON.parseObject((String)params, EMSPackageCostChargeMode.class);
                respDto.seteMsPackageMode(emsPackageCostChargeMode);
                break;
            }
        }
    }

    private void handleChargeModeJson(ExpressCostContractReqDto reqDto, ExpressCostContractEo eo) {
        Integer chargeMode = reqDto.getChargeMode();
        switch (ExpressCostChargeModeEnum.getChargeMode((Integer)chargeMode)) {
            case SF_DS_BK: {
                SfDsBkCostChargeModeDto sfDsBkMode = reqDto.getSfDsBkMode();
                if (sfDsBkMode == null || CollectionUtil.isEmpty((Collection)sfDsBkMode.getChargeModes())) {
                    throw new BizException("\u987a\u4e30\u7535\u5546\u6807\u5feb\u6a21\u677f\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                eo.setParams(JSON.toJSONString((Object)sfDsBkMode));
                break;
            }
            case SF_KH: {
                SfKhCostChargeMode sfKhMode = reqDto.getSfKhMode();
                if (sfKhMode == null) {
                    throw new BizException("\u987a\u4e30\u5361\u822a\u6a21\u677f\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (Objects.equals(2, reqDto.getDiscountType())) {
                    if (CollectionUtil.isEmpty((Collection)reqDto.getPriceLadders())) {
                        throw new BizException("\u987a\u4e30\u5361\u822a\u6298\u6263\u7c7b\u578b-\u4ef7\u683c\u533a\u95f4\uff0c\u4ef7\u683c\u533a\u95f4\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    eo.setPriceRange(JSON.toJSONString((Object)reqDto.getPriceLadders()));
                }
                eo.setParams(JSON.toJSONString((Object)sfKhMode));
                break;
            }
            case SF_EXPRESS: 
            case STO: {
                BigDecimal currencyModeFirstWeight = reqDto.getCurrencyModeFirstWeight();
                if (currencyModeFirstWeight == null) {
                    if (Objects.equals(chargeMode, ExpressCostChargeModeEnum.SF_EXPRESS.getType())) {
                        throw new BizException("\u987a\u4e30\u7279\u5feb\u8ba1\u7b97\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (Objects.equals(chargeMode, ExpressCostChargeModeEnum.STO.getType())) {
                        throw new BizException("\u987a\u4e30\u5feb\u9012\u8ba1\u7b97\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                eo.setParams(JSON.toJSONString((Object)currencyModeFirstWeight));
                break;
            }
            case SF_EXPRESS_PACKAGE: {
                SfTkPackageCostChargeMode sfTkPackageMode = reqDto.getSfTkPackageMode();
                if (sfTkPackageMode == null) {
                    throw new BizException("\u987a\u4e30\u5feb\u9012\u5305\u88f9\u8ba1\u7b97\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                eo.setParams(JSON.toJSONString((Object)sfTkPackageMode));
                break;
            }
            case SF_BK: {
                SfBkCostChargeMode sfBkeMode = reqDto.getSfBkMode();
                if (sfBkeMode == null) {
                    throw new BizException("\u987a\u4e30\u6807\u5feb\u6a21\u677f\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                eo.setParams(JSON.toJSONString((Object)sfBkeMode));
                break;
            }
            case ZTO: {
                ZtoCostChargeMode ztoCostChargeMode = reqDto.getzToMode();
                if (ztoCostChargeMode == null) {
                    throw new BizException("\u4e2d\u901a\u5feb\u9012\u6a21\u677f\u8ba1\u7b97\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                eo.setParams(JSON.toJSONString((Object)ztoCostChargeMode));
                break;
            }
            case EMS_BK: {
                EMSBkCostChargeMode emsBkCostChargeMode = reqDto.geteMsBkMode();
                if (emsBkCostChargeMode == null) {
                    throw new BizException("EMS\u6807\u51c6\u5feb\u9012\u8ba1\u7b97\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                eo.setParams(JSON.toJSONString((Object)emsBkCostChargeMode));
                break;
            }
            case EMS_PACKAGE: {
                EMSPackageCostChargeMode emsPackageCostChargeMode = reqDto.geteMsPackageMode();
                if (emsPackageCostChargeMode == null) {
                    throw new BizException("EMS\u5feb\u9012\u5305\u88f9\u6a21\u677f\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                eo.setParams(JSON.toJSONString((Object)emsPackageCostChargeMode));
                break;
            }
            default: {
                throw new BizException("\u5feb\u9012\u8d39\u6a21\u677f\u7c7b\u578b\u9519\u8bef");
            }
        }
    }

    private List<ExpressCostContractRespDto> checkTimeOverlap(ExpressCostContractReqDto reqDto) {
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"warehouse_code", (Object)reqDto.getWarehouseCode())).eq((Object)"logistic_code", (Object)reqDto.getLogisticCode())).eq((Object)"transport_type", (Object)reqDto.getTransportType())).eq((Object)"charge_mode", (Object)reqDto.getChargeMode())).in((Object)"status", new Object[]{0, 1});
        if (reqDto.getId() != null && reqDto.getId() > 0L) {
            filter.ne((Object)"id", (Object)reqDto.getId());
        }
        filter.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.or(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"start_time", (Object)reqDto.getStartTime())).ge((Object)"end_time", (Object)reqDto.getStartTime());
            })).or(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"start_time", (Object)reqDto.getEndTime())).ge((Object)"end_time", (Object)reqDto.getEndTime());
            })).or(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"end_time", (Object)reqDto.getEndTime())).ge((Object)"start_time", (Object)reqDto.getStartTime());
            });
        });
        List list = filter.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return list.stream().map(i -> {
                ExpressCostContractRespDto respDto = new ExpressCostContractRespDto();
                DtoHelper.eo2Dto((BaseEo)i, (BaseVo)respDto);
                this.assembleStatus(respDto);
                return respDto;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private void assembleStatus(ExpressCostContractRespDto respDto) {
        Integer status = respDto.getStatus();
        if (Objects.equals(LogisticRecordStatusEnum.INITIALIZE.getType(), status)) {
            if (System.currentTimeMillis() < respDto.getStartTime().getTime()) {
                respDto.setStatus(LogisticRecordStatusEnum.INITIALIZE.getType());
            } else if (System.currentTimeMillis() > respDto.getEndTime().getTime()) {
                respDto.setStatus(LogisticRecordStatusEnum.FAILURE.getType());
            } else {
                respDto.setStatus(LogisticRecordStatusEnum.AMONG.getType());
            }
        }
    }

    private void checkTime(ExpressCostContractReqDto reqDto) {
        Date endTime = reqDto.getEndTime();
        Date startTime = reqDto.getStartTime();
        if (startTime.getTime() > endTime.getTime()) {
            throw new BizException("\u975e\u6cd5\u5f00\u59cb\u65f6\u95f4");
        }
        if (endTime.getTime() < System.currentTimeMillis()) {
            throw new BizException("\u7ed3\u675f\u65f6\u95f4\u5df2\u8fc7\u671f");
        }
    }

    private void mandatoryFieldCheck(ExpressCostContractReqDto reqDto) {
        String contractName = reqDto.getContractName();
        if (StringUtils.isBlank((CharSequence)contractName)) {
            throw new BizException("\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String warehouseCode = reqDto.getWarehouseCode();
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            throw new BizException("\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String warehouseName = reqDto.getWarehouseName();
        if (StringUtils.isBlank((CharSequence)warehouseName)) {
            throw new BizException("\u7269\u7406\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String logisticCode = reqDto.getLogisticCode();
        if (StringUtils.isBlank((CharSequence)logisticCode)) {
            throw new BizException("\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String logisticCompany = reqDto.getLogisticCompany();
        if (StringUtils.isBlank((CharSequence)logisticCompany)) {
            throw new BizException("\u7269\u6d41\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer chargeMode = reqDto.getChargeMode();
        if (chargeMode == null || chargeMode < 1) {
            throw new BizException("\u8ba1\u8d39\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8ba1\u8d39\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
    }
}

