/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.LogisticsSetttingsReqDto;
import com.dtyunxi.finance.api.dto.response.LogisticsSetttingsRespDto;
import com.dtyunxi.finance.api.exception.FinanceExceptionEnum;
import com.dtyunxi.finance.api.exception.LogisticRecordStatusEnum;
import com.dtyunxi.finance.biz.model.LogisticsSettingsLogVO;
import com.dtyunxi.finance.biz.service.ILogisticsSettingsService;
import com.dtyunxi.finance.biz.util.AssertUtil;
import com.dtyunxi.finance.dao.das.InsuranceSettingsDas;
import com.dtyunxi.finance.dao.das.LogisticsSettingsDas;
import com.dtyunxi.finance.dao.das.LogisticsSettingsLogDas;
import com.dtyunxi.finance.dao.eo.InsuranceSettingsEo;
import com.dtyunxi.finance.dao.eo.LogisticsSettingsEo;
import com.dtyunxi.finance.dao.eo.LogisticsSettingsLogEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticsSettingsServiceImpl
implements ILogisticsSettingsService {
    @Resource
    private LogisticsSettingsDas logisticsSettingsDas;
    @Resource
    private InsuranceSettingsDas insuranceSettingsDas;
    @Resource
    private LogisticsSettingsLogDas logisticsSettingsLogDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addLogisticsSetttings(LogisticsSetttingsReqDto addReqDto) {
        this.checkData(addReqDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        LogisticsSettingsEo queryEo = new LogisticsSettingsEo();
        queryEo.setDr(0);
        queryEo.setLogisticsType(addReqDto.getModeOfCarriageCode());
        queryEo.setInsuranceId(addReqDto.getInsuranceCode());
        queryEo.setShipmentEnterpriseCode(addReqDto.getLogisticsCode());
        queryEo.setStatus(Integer.valueOf(0));
        queryWrapper.setEntity((Object)queryEo);
        List logisticsSettingsEos = this.logisticsSettingsDas.getMapper().selectList((Wrapper)queryWrapper.lambda().and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.or(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)addReqDto.getEffectiveStartTime())).ge(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)addReqDto.getEffectiveStartTime());
            })).or(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)addReqDto.getEffectiveEndTime())).ge(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)addReqDto.getEffectiveEndTime());
            })).or(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)addReqDto.getEffectiveEndTime())).ge(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)addReqDto.getEffectiveStartTime());
            });
        }));
        AssertUtil.isTrue(logisticsSettingsEos.isEmpty(), FinanceExceptionEnum.EFFECTIVE_TIME_REPEATABLE.getCode(), FinanceExceptionEnum.EFFECTIVE_TIME_REPEATABLE.getMessage());
        LogisticsSettingsEo logisticsSettingsEo = new LogisticsSettingsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)logisticsSettingsEo);
        this.getSetttingsEo(logisticsSettingsEo, addReqDto);
        this.logisticsSettingsDas.insert((BaseEo)logisticsSettingsEo);
        return logisticsSettingsEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyLogisticsSetttings(LogisticsSetttingsReqDto modifyReqDto) {
        this.checkData(modifyReqDto);
        LogisticsSettingsEo logisticsSettingsEo = new LogisticsSettingsEo();
        this.modifyColumn(modifyReqDto);
        logisticsSettingsEo.setId(modifyReqDto.getId());
        logisticsSettingsEo.setContractName(modifyReqDto.getContractName());
        logisticsSettingsEo.setInsuranceId(modifyReqDto.getInsuranceCode());
        logisticsSettingsEo.setLogisticsType(modifyReqDto.getModeOfCarriageCode());
        logisticsSettingsEo.setShipmentEnterpriseCode(modifyReqDto.getLogisticsCode());
        if (modifyReqDto.getRemark() != null) {
            logisticsSettingsEo.setRemark(modifyReqDto.getRemark());
        }
        logisticsSettingsEo.setEfffectiveTimeBegin(modifyReqDto.getEffectiveStartTime());
        logisticsSettingsEo.setEfffectiveTimeEnd(modifyReqDto.getEffectiveEndTime());
        logisticsSettingsEo.setProductDiscount(modifyReqDto.getProductInsuranceDiscount().setScale(3, RoundingMode.DOWN));
        logisticsSettingsEo.setMaterialDiscount(modifyReqDto.getMaterialInsuranceDiscount().setScale(3, RoundingMode.DOWN));
        logisticsSettingsEo.setBillQuotaVerify(modifyReqDto.getBillQuotaVerify());
        logisticsSettingsEo.setLogisticsTypeName(modifyReqDto.getLogisticsTypeName());
        this.logisticsSettingsDas.updateSelective((BaseEo)logisticsSettingsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLogisticsSetttings(Long id) {
        this.logisticsSettingsDas.deleteById(Long.valueOf(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void tovoidLogisticsSetttings(Long id) {
        LogisticsSettingsEo logisticsSettingsEo = new LogisticsSettingsEo();
        logisticsSettingsEo.setId(id);
        Integer status = 1;
        logisticsSettingsEo.setStatus(status);
        LogisticsSettingsEo queryLogisticsSetttingsDto = (LogisticsSettingsEo)this.logisticsSettingsDas.selectByPrimaryKey(id);
        if (queryLogisticsSetttingsDto == null) {
            return;
        }
        LogisticsSettingsLogEo LogisticsSettingsLogEo2 = new LogisticsSettingsLogEo();
        Date currentDate = new Date();
        if (currentDate.before(queryLogisticsSetttingsDto.getEfffectiveTimeBegin())) {
            LogisticsSettingsLogEo2.setValueBefore(LogisticRecordStatusEnum.INITIALIZE.getName());
        } else if (currentDate.after(queryLogisticsSetttingsDto.getEfffectiveTimeEnd())) {
            LogisticsSettingsLogEo2.setValueBefore(LogisticRecordStatusEnum.FAILURE.getName());
        } else {
            LogisticsSettingsLogEo2.setValueBefore(LogisticRecordStatusEnum.AMONG.getName());
        }
        LogisticsSettingsLogEo2.setSettingsId(id);
        LogisticsSettingsLogEo2.setModifyColumn("\u72b6\u6001");
        LogisticsSettingsLogEo2.setValueAfter(LogisticRecordStatusEnum.INVALID.getName());
        this.logisticsSettingsLogDas.insert((BaseEo)LogisticsSettingsLogEo2);
        this.logisticsSettingsDas.updateSelective((BaseEo)logisticsSettingsEo);
    }

    @Override
    public LogisticsSetttingsRespDto queryById(Long id) {
        LogisticsSettingsEo logisticsSettingsEo = (LogisticsSettingsEo)this.logisticsSettingsDas.selectByPrimaryKey(id);
        LogisticsSetttingsRespDto logisticsSetttingsRespDto = new LogisticsSetttingsRespDto();
        DtoHelper.eo2Dto((BaseEo)logisticsSettingsEo, (BaseVo)logisticsSetttingsRespDto);
        logisticsSetttingsRespDto.setProductDiscount(logisticsSettingsEo.getProductDiscount().setScale(3, RoundingMode.DOWN));
        logisticsSetttingsRespDto.setMaterialDiscount(logisticsSettingsEo.getMaterialDiscount().setScale(3, RoundingMode.DOWN));
        InsuranceSettingsEo insuranceSettingsEo = (InsuranceSettingsEo)this.insuranceSettingsDas.selectByPrimaryKey(logisticsSettingsEo.getInsuranceId());
        if (insuranceSettingsEo != null) {
            logisticsSetttingsRespDto.setInsuranceCompany(insuranceSettingsEo.getInsuranceName());
            logisticsSetttingsRespDto.setInsuranceRate(insuranceSettingsEo.getInsuranceRate());
            logisticsSetttingsRespDto.setInsuranceCode(insuranceSettingsEo.getInsuranceCode());
        }
        LogisticsSettingsLogEo logisticsSettingsLogEo = new LogisticsSettingsLogEo();
        logisticsSettingsLogEo.setSettingsId(logisticsSettingsEo.getId());
        logisticsSettingsLogEo.setOrderByDesc("create_time");
        List logisticsSettingsLogList = this.logisticsSettingsLogDas.selectList((BaseEo)logisticsSettingsLogEo);
        ArrayList<LogisticsSettingsLogVO> modifyRecords = new ArrayList<LogisticsSettingsLogVO>();
        if (CollectionUtils.isNotEmpty((Collection)logisticsSettingsLogList)) {
            for (LogisticsSettingsLogEo logisticsSettingsLog : logisticsSettingsLogList) {
                LogisticsSettingsLogVO logisticsSettingsLogVO = new LogisticsSettingsLogVO();
                DtoHelper.eo2Dto((BaseEo)logisticsSettingsLog, (BaseVo)logisticsSettingsLogVO);
                logisticsSettingsLogVO.setBeforeModification(logisticsSettingsLog.getValueBefore());
                logisticsSettingsLogVO.setAfterModification(logisticsSettingsLog.getValueAfter());
                logisticsSettingsLogVO.setModifyField(logisticsSettingsLog.getModifyColumn());
                modifyRecords.add(logisticsSettingsLogVO);
            }
        }
        logisticsSetttingsRespDto.setModifyRecords(modifyRecords);
        return logisticsSetttingsRespDto;
    }

    @Override
    public PageInfo<LogisticsSetttingsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        LogisticsSetttingsReqDto logisticsSetttingsReqDto = (LogisticsSetttingsReqDto)JSON.parseObject((String)filter, LogisticsSetttingsReqDto.class);
        LogisticsSettingsEo logisticsSettingsEo = new LogisticsSettingsEo();
        if (StringUtils.isNotEmpty((CharSequence)logisticsSetttingsReqDto.getLogisticsCode())) {
            logisticsSettingsEo.setShipmentEnterpriseCode(logisticsSetttingsReqDto.getLogisticsCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsSetttingsReqDto.getModeOfCarriageCode())) {
            logisticsSettingsEo.setLogisticsType(logisticsSetttingsReqDto.getModeOfCarriageCode());
        }
        if (logisticsSetttingsReqDto.getInsuranceCode() != null) {
            logisticsSettingsEo.setInsuranceId(logisticsSetttingsReqDto.getInsuranceCode());
        }
        logisticsSettingsEo.setDr(0);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Date date = new Date();
        QueryWrapper logisticsSettingsEoQueryWrapper = new QueryWrapper();
        logisticsSettingsEoQueryWrapper.setEntity((Object)logisticsSettingsEo);
        Page eoPageInfo = null;
        if (logisticsSetttingsReqDto.getStatus() != null) {
            if (LogisticRecordStatusEnum.INVALID.getType().equals(logisticsSetttingsReqDto.getStatus())) {
                logisticsSettingsEo.setStatus(Integer.valueOf(1));
                eoPageInfo = (Page)this.logisticsSettingsDas.getMapper().selectPage((IPage)page, (Wrapper)logisticsSettingsEoQueryWrapper.lambda().orderByDesc(BaseEo::getCreateTime));
            } else {
                logisticsSettingsEo.setStatus(Integer.valueOf(0));
            }
            if (LogisticRecordStatusEnum.INITIALIZE.getType().equals(logisticsSetttingsReqDto.getStatus())) {
                eoPageInfo = (Page)this.logisticsSettingsDas.getMapper().selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)logisticsSettingsEoQueryWrapper.lambda().gt(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)date)).orderByDesc(BaseEo::getCreateTime));
            } else if (LogisticRecordStatusEnum.AMONG.getType().equals(logisticsSetttingsReqDto.getStatus())) {
                eoPageInfo = (Page)this.logisticsSettingsDas.getMapper().selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)logisticsSettingsEoQueryWrapper.lambda().lt(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)date)).gt(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)date)).orderByDesc(BaseEo::getCreateTime));
            } else if (LogisticRecordStatusEnum.FAILURE.getType().equals(logisticsSetttingsReqDto.getStatus())) {
                eoPageInfo = (Page)this.logisticsSettingsDas.getMapper().selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)logisticsSettingsEoQueryWrapper.lambda().lt(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)date)).orderByDesc(BaseEo::getCreateTime));
            } else if (LogisticRecordStatusEnum.HAS_EXIST.getType().equals(logisticsSetttingsReqDto.getStatus())) {
                eoPageInfo = (Page)this.logisticsSettingsDas.getMapper().selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)logisticsSettingsEoQueryWrapper.lambda().ne(logisticsSetttingsReqDto.getId() != null, BaseEo::getId, (Object)logisticsSetttingsReqDto.getId())).and(q -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.or(w -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)logisticsSetttingsReqDto.getEffectiveStartTime())).ge(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)logisticsSetttingsReqDto.getEffectiveStartTime());
                    })).or(w -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)logisticsSetttingsReqDto.getEffectiveEndTime())).ge(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)logisticsSetttingsReqDto.getEffectiveEndTime());
                    })).or(w -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)logisticsSetttingsReqDto.getEffectiveEndTime())).ge(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)logisticsSetttingsReqDto.getEffectiveStartTime());
                    });
                })).orderByDesc(BaseEo::getCreateTime));
            } else if (LogisticRecordStatusEnum.AMONG_FAILURE.getType().equals(logisticsSetttingsReqDto.getStatus())) {
                eoPageInfo = (Page)this.logisticsSettingsDas.getMapper().selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)logisticsSettingsEoQueryWrapper.lambda().le(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)date)).orderByDesc(BaseEo::getCreateTime));
            }
        } else {
            eoPageInfo = (Page)this.logisticsSettingsDas.getMapper().selectPage((IPage)page, (Wrapper)logisticsSettingsEoQueryWrapper.lambda().orderByDesc(BaseEo::getCreateTime));
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = eoPageInfo.getRecords().stream().map(dto -> {
            LogisticsSetttingsRespDto logisticsSetttingsVO = new LogisticsSetttingsRespDto();
            CubeBeanUtils.copyProperties((Object)logisticsSetttingsVO, (Object)dto, (String[])new String[0]);
            InsuranceSettingsEo insuranceSettingsEo = (InsuranceSettingsEo)this.insuranceSettingsDas.selectByPrimaryKey(dto.getInsuranceId());
            if (insuranceSettingsEo != null) {
                logisticsSetttingsVO.setInsuranceCompany(insuranceSettingsEo.getInsuranceName());
                logisticsSetttingsVO.setInsuranceRate(insuranceSettingsEo.getInsuranceRate());
                logisticsSetttingsVO.setInsuranceCode(insuranceSettingsEo.getId().toString());
            }
            LogisticsSettingsLogEo logisticsSettingsLogEo = new LogisticsSettingsLogEo();
            logisticsSettingsLogEo.setSettingsId(dto.getId());
            List logisticsSettingsLogList = this.logisticsSettingsLogDas.selectList((BaseEo)logisticsSettingsLogEo);
            ArrayList<LogisticsSettingsLogVO> modifyRecords = new ArrayList<LogisticsSettingsLogVO>();
            if (CollectionUtils.isNotEmpty((Collection)logisticsSettingsLogList)) {
                for (LogisticsSettingsLogEo logisticsSettingsLog : logisticsSettingsLogList) {
                    LogisticsSettingsLogVO logisticsSettingsLogVO = new LogisticsSettingsLogVO();
                    DtoHelper.eo2Dto((BaseEo)logisticsSettingsLog, (BaseVo)logisticsSettingsLogVO);
                    logisticsSettingsLogVO.setBeforeModification(logisticsSettingsLog.getValueBefore());
                    logisticsSettingsLogVO.setAfterModification(logisticsSettingsLog.getValueAfter());
                    logisticsSettingsLogVO.setModifyField(logisticsSettingsLog.getModifyColumn());
                    modifyRecords.add(logisticsSettingsLogVO);
                }
            }
            logisticsSetttingsVO.setEfffectiveTimeBegin(dto.getEfffectiveTimeBegin());
            logisticsSetttingsVO.setEfffectiveTimeEnd(dto.getEfffectiveTimeEnd());
            logisticsSetttingsVO.setModifyRecords(modifyRecords);
            return logisticsSetttingsVO;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    public Boolean checkData(LogisticsSetttingsReqDto addReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getContractName()), "\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getLogisticsCode()), "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getModeOfCarriageCode()), "\u627f\u8fd0\u65b9\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getInsuranceCode()), "\u4fdd\u9669\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getProductInsuranceDiscount()), "\u4ea7\u54c1\u6295\u4fdd\u6298\u6263\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal bignum = new BigDecimal(1);
        BigDecimal minnum = new BigDecimal(0);
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getMaterialInsuranceDiscount()), "\u7269\u6599\u6295\u4fdd\u6298\u6263\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(addReqDto.getEffectiveStartTime().before(addReqDto.getEffectiveEndTime()), "\u5f00\u59cb\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
        return true;
    }

    private void getSetttingsEo(LogisticsSettingsEo logisticsSettingsEo, LogisticsSetttingsReqDto ReqDto) {
        logisticsSettingsEo.setShipmentEnterpriseCode(ReqDto.getLogisticsCode());
        logisticsSettingsEo.setLogisticsType(ReqDto.getModeOfCarriageCode());
        logisticsSettingsEo.setInsuranceId(ReqDto.getInsuranceCode());
        logisticsSettingsEo.setProductDiscount(ReqDto.getProductInsuranceDiscount());
        logisticsSettingsEo.setMaterialDiscount(ReqDto.getMaterialInsuranceDiscount());
        logisticsSettingsEo.setEfffectiveTimeBegin(ReqDto.getEffectiveStartTime());
        logisticsSettingsEo.setEfffectiveTimeEnd(ReqDto.getEffectiveEndTime());
        logisticsSettingsEo.setRemark(ReqDto.getRemark());
    }

    private void modifyColumn(LogisticsSetttingsReqDto ReqDto) {
        LogisticsSettingsLogEo LogisticsSettingsLogEo2;
        LogisticsSettingsEo queryLogisticsSetttingsDto = (LogisticsSettingsEo)this.logisticsSettingsDas.selectByPrimaryKey(ReqDto.getId());
        if (queryLogisticsSetttingsDto == null) {
            return;
        }
        List logisticsSettingsEos = this.logisticsSettingsDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(LogisticsSettingsEo::getLogisticsType, (Object)ReqDto.getModeOfCarriageCode())).eq(LogisticsSettingsEo::getInsuranceId, (Object)ReqDto.getInsuranceCode())).eq(LogisticsSettingsEo::getShipmentEnterpriseCode, (Object)ReqDto.getLogisticsCode())).eq(BaseEo::getDr, (Object)0)).eq(LogisticsSettingsEo::getStatus, (Object)0)).ne(BaseEo::getId, (Object)ReqDto.getId())).and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.or(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)ReqDto.getEffectiveStartTime())).ge(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)ReqDto.getEffectiveStartTime());
            })).or(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)ReqDto.getEffectiveEndTime())).ge(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)ReqDto.getEffectiveEndTime());
            })).or(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.le(LogisticsSettingsEo::getEfffectiveTimeEnd, (Object)ReqDto.getEffectiveEndTime())).ge(LogisticsSettingsEo::getEfffectiveTimeBegin, (Object)ReqDto.getEffectiveStartTime());
            });
        }));
        AssertUtil.isTrue(logisticsSettingsEos.isEmpty(), FinanceExceptionEnum.EFFECTIVE_TIME_REPEATABLE.getCode(), FinanceExceptionEnum.EFFECTIVE_TIME_REPEATABLE.getMessage());
        if (!queryLogisticsSetttingsDto.getContractName().equals(ReqDto.getContractName())) {
            LogisticsSettingsLogEo2 = new LogisticsSettingsLogEo();
            LogisticsSettingsLogEo2.setSettingsId(ReqDto.getId());
            LogisticsSettingsLogEo2.setModifyColumn("\u5408\u540c\u540d\u79f0");
            LogisticsSettingsLogEo2.setValueBefore(queryLogisticsSetttingsDto.getContractName());
            LogisticsSettingsLogEo2.setValueAfter(ReqDto.getContractName());
            this.logisticsSettingsLogDas.insert((BaseEo)LogisticsSettingsLogEo2);
        }
        if (queryLogisticsSetttingsDto.getProductDiscount().compareTo(ReqDto.getProductInsuranceDiscount()) != 0) {
            LogisticsSettingsLogEo2 = new LogisticsSettingsLogEo();
            LogisticsSettingsLogEo2.setSettingsId(ReqDto.getId());
            LogisticsSettingsLogEo2.setModifyColumn("\u4ea7\u54c1\u6298\u6263");
            LogisticsSettingsLogEo2.setValueBefore(queryLogisticsSetttingsDto.getProductDiscount().setScale(3, RoundingMode.DOWN).toString());
            LogisticsSettingsLogEo2.setValueAfter(ReqDto.getProductInsuranceDiscount().setScale(3, RoundingMode.DOWN).toString());
            this.logisticsSettingsLogDas.insert((BaseEo)LogisticsSettingsLogEo2);
        }
        if (queryLogisticsSetttingsDto.getMaterialDiscount().compareTo(ReqDto.getMaterialInsuranceDiscount()) != 0) {
            LogisticsSettingsLogEo2 = new LogisticsSettingsLogEo();
            LogisticsSettingsLogEo2.setSettingsId(ReqDto.getId());
            LogisticsSettingsLogEo2.setModifyColumn("\u7269\u6599\u6298\u6263");
            LogisticsSettingsLogEo2.setValueBefore(queryLogisticsSetttingsDto.getMaterialDiscount().setScale(3, RoundingMode.DOWN).toString());
            LogisticsSettingsLogEo2.setValueAfter(ReqDto.getMaterialInsuranceDiscount().setScale(3, RoundingMode.DOWN).toString());
            this.logisticsSettingsLogDas.insert((BaseEo)LogisticsSettingsLogEo2);
        }
        if (!DateUtil.isSameTime((Date)queryLogisticsSetttingsDto.getEfffectiveTimeBegin(), (Date)ReqDto.getEffectiveStartTime())) {
            LogisticsSettingsLogEo2 = new LogisticsSettingsLogEo();
            LogisticsSettingsLogEo2.setSettingsId(ReqDto.getId());
            LogisticsSettingsLogEo2.setModifyColumn("\u6709\u6548\u65e5\u671f\u8d77\u59cb\u65e5");
            LogisticsSettingsLogEo2.setValueBefore(DateUtil.format((Date)queryLogisticsSetttingsDto.getEfffectiveTimeBegin(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            LogisticsSettingsLogEo2.setValueAfter(DateUtil.format((Date)ReqDto.getEffectiveStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            this.logisticsSettingsLogDas.insert((BaseEo)LogisticsSettingsLogEo2);
        }
        if (!DateUtil.isSameTime((Date)queryLogisticsSetttingsDto.getEfffectiveTimeEnd(), (Date)ReqDto.getEffectiveEndTime())) {
            LogisticsSettingsLogEo2 = new LogisticsSettingsLogEo();
            LogisticsSettingsLogEo2.setSettingsId(ReqDto.getId());
            LogisticsSettingsLogEo2.setModifyColumn("\u6709\u6548\u65e5\u671f\u622a\u6b62\u65e5");
            LogisticsSettingsLogEo2.setValueBefore(DateUtil.format((Date)queryLogisticsSetttingsDto.getEfffectiveTimeEnd(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            LogisticsSettingsLogEo2.setValueAfter(DateUtil.format((Date)ReqDto.getEffectiveEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            this.logisticsSettingsLogDas.insert((BaseEo)LogisticsSettingsLogEo2);
        }
    }
}

