/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehousePageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IInventorySharedWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IRelVirtualWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IShareGoodsOrderService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IVirtualWarehouseService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseItemDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualGroupDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedWarehouseEo;
import com.yunxi.dg.base.center.share.eo.RelVirtualWarehouseEo;
import com.yunxi.dg.base.center.share.eo.VirtualGroupEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizVirtualWarehouseService")
public class VirtualWarehouseServiceImpl
implements IVirtualWarehouseService {
    private static final Logger log = LoggerFactory.getLogger(VirtualWarehouseServiceImpl.class);
    @Autowired
    IVirtualWarehouseDomain virtualWarehouseDomain;
    @Autowired
    IVirtualGroupDomain virtualGroupDomain;
    @Autowired
    IInventorySharedWarehouseDomain inventorySharedWarehouseDomain;
    @Autowired
    IInventorySharedDomain inventorySharedDomain;
    @Autowired
    IChannelWarehouseDomain channelWarehouseDomain;
    @Autowired
    IRelVirtualWarehouseDomain relVirtualWarehouseDomain;
    @Autowired
    ICsLogicWarehouseQueryApi csLogicWarehouseApi;
    @Autowired
    ICacheService cacheService;
    @Autowired
    IChannelWarehouseItemDomain channelWarehouseItemDomain;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    IRelVirtualWarehouseService relVirtualWarehouseService;
    @Autowired
    IInventorySharedWarehouseService inventorySharedWarehouseService;
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    IShareGoodsOrderService shareGoodsOrderService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addVirtualWarehouse(VirtualWarehouseReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getWarehouseCode(), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Integer selectCount = this.virtualWarehouseDomain.getMapper().selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)addReqDto.getWarehouseCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (selectCount > 0) {
            throw new BizException(String.format("\u865a\u4ed3\u7f16\u7801: %s, \u5df2\u5b58\u5728", addReqDto.getWarehouseCode()));
        }
        VirtualWarehouseEo csVirtualWarehouseEo = new VirtualWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csVirtualWarehouseEo);
        this.virtualWarehouseDomain.insert((BaseEo)csVirtualWarehouseEo);
        return csVirtualWarehouseEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyVirtualWarehouse(VirtualWarehouseReqDto modifyReqDto) {
        List inventorySharedEos;
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyReqDto.getWarehouseCode(), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)this.virtualWarehouseDomain.selectByPrimaryKey(modifyReqDto.getId());
        AssertUtils.notNull((Object)virtualWarehouseEo, (String)"\u4f9b\u8d27\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5230");
        VirtualWarehouseEo updateVirtualWarehouseEo = new VirtualWarehouseEo();
        updateVirtualWarehouseEo.setId(virtualWarehouseEo.getId());
        updateVirtualWarehouseEo.setWarehouseName(modifyReqDto.getWarehouseName());
        updateVirtualWarehouseEo.setWarehouseType(modifyReqDto.getWarehouseType());
        updateVirtualWarehouseEo.setWarehouseStatus(modifyReqDto.getWarehouseStatus());
        updateVirtualWarehouseEo.setRemark(modifyReqDto.getRemark());
        updateVirtualWarehouseEo.setEasDefaultWarehouseCode(modifyReqDto.getEasDefaultWarehouseCode());
        this.virtualWarehouseDomain.updateSelective((BaseEo)updateVirtualWarehouseEo);
        List<Object> sharedCodes = Lists.newArrayList();
        if (VirtualWarehouseTypeEnum.OVERALL.getCode().equals(virtualWarehouseEo.getWarehouseType()) && CollectionUtils.isNotEmpty((Collection)(inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedEo.class).eq(InventorySharedEo::getVirtualWarehouseCode, (Object)virtualWarehouseEo.getWarehouseCode())).eq(InventorySharedEo::getSharedStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO))))) {
            sharedCodes = inventorySharedEos.stream().map(InventorySharedEo::getSharedCode).distinct().collect(Collectors.toList());
        }
        String warehouseCode = virtualWarehouseEo.getWarehouseCode();
        this.cacheService.hdel("sh_inventory_able_group_virtual_warehouse_code", new String[]{warehouseCode});
        if (StringUtils.equals((CharSequence)virtualWarehouseEo.getWarehouseStatus(), (CharSequence)modifyReqDto.getWarehouseStatus())) {
            return;
        }
        if (EnableDisableEnum.ENABLE.getCode().equals(modifyReqDto.getWarehouseStatus())) {
            this.relVirtualWarehouseService.enable(Lists.newArrayList(), Lists.newArrayList((Object[])new Long[]{virtualWarehouseEo.getId()}));
            if (CollectionUtils.isNotEmpty((Collection)sharedCodes)) {
                this.inventorySharedWarehouseService.enable(sharedCodes, Lists.newArrayList());
            }
            this.calcInventoryService.refreshVirtualInventory((List)Lists.newArrayList((Object[])new String[]{warehouseCode}), (List)Lists.newArrayList());
        } else {
            List<String> calcVirtualWarehouseCodes = this.getCalcVirtualWarehouseCodes(virtualWarehouseEo);
            List preemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).select(new SFunction[]{BaseEo::getId}).in(InventoryPreemptionEo::getWarehouseCode, calcVirtualWarehouseCodes)).eq(InventoryPreemptionEo::getWarehouseClassify, (Object)WarehouseClassifyEnum.VIRTUAL.getCode())).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (CollectionUtils.isNotEmpty((Collection)preemptionEos)) {
                throw new BizException("\u8fd8\u5b58\u5728\u6709\u6548\u9884\u5360\u8bb0\u5f55\uff0c\u4e0d\u53ef\u7981\u7528");
            }
            if (VirtualWarehouseTypeEnum.OVERALL.getCode().equals(virtualWarehouseEo.getWarehouseType())) {
                this.calcInventoryService.clearVirtualInventory(calcVirtualWarehouseCodes, (List)Lists.newArrayList());
                if (CollectionUtils.isNotEmpty((Collection)sharedCodes)) {
                    this.inventorySharedWarehouseService.disable(sharedCodes, Lists.newArrayList());
                }
            } else if (VirtualWarehouseTypeEnum.SUB.getCode().equals(virtualWarehouseEo.getWarehouseType())) {
                this.shareGoodsOrderService.autoShareGoodsByDisableWarehouse(virtualWarehouseEo);
            }
            this.relVirtualWarehouseService.disable(Lists.newArrayList(), Lists.newArrayList((Object[])new Long[]{virtualWarehouseEo.getId()}));
        }
    }

    private List<String> getCalcVirtualWarehouseCodes(VirtualWarehouseEo virtualWarehouseEo) {
        List<Object> virtualWarehouseCodes = Lists.newArrayList((Object[])new String[]{virtualWarehouseEo.getWarehouseCode()});
        if (VirtualWarehouseTypeEnum.OVERALL.getCode().equals(virtualWarehouseEo.getWarehouseType()) && null != virtualWarehouseEo.getGroupId()) {
            List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).eq(VirtualWarehouseEo::getGroupId, (Object)virtualWarehouseEo.getGroupId())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)virtualWarehouseEos, (String)"\u8be5\u4f9b\u8d27\u4e3b\u4ed3\uff0c\u4f9b\u8d27\u7ec4\u4e0b\u4ed3\u5e93\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
            virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        }
        return virtualWarehouseCodes;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeVirtualWarehouse(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.virtualWarehouseDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public VirtualWarehouseRespDto queryById(Long id) {
        VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)this.virtualWarehouseDomain.selectByPrimaryKey(id);
        VirtualWarehouseRespDto virtualWarehouseRespDto = new VirtualWarehouseRespDto();
        DtoHelper.eo2Dto((BaseEo)virtualWarehouseEo, (BaseVo)virtualWarehouseRespDto);
        return virtualWarehouseRespDto;
    }

    @Override
    public VirtualWarehouseRespDto queryByCode(String warehouseCode) {
        VirtualWarehouseEo virtualWarehouseEo = new VirtualWarehouseEo();
        virtualWarehouseEo.setWarehouseCode(warehouseCode);
        virtualWarehouseEo = (VirtualWarehouseEo)this.virtualWarehouseDomain.selectOne((BaseEo)virtualWarehouseEo);
        AssertUtils.notNull((Object)virtualWarehouseEo, (String)"\u4f9b\u8d27\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
        VirtualWarehouseRespDto virtualWarehouseRespDto = new VirtualWarehouseRespDto();
        DtoHelper.eo2Dto((BaseEo)virtualWarehouseEo, (BaseVo)virtualWarehouseRespDto);
        return virtualWarehouseRespDto;
    }

    @Override
    public List<VirtualWarehouseRespDto> queryByList(VirtualWarehouseListReqDto queryDto) {
        AssertUtils.notNull((Object)queryDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = new QueryWrapper();
        if (!CollectionUtils.isEmpty((Collection)queryDto.getVirtualWarehouseIds())) {
            wrapper.in((Object)"id", (Collection)queryDto.getVirtualWarehouseIds());
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getVirtualWarehouseCodes())) {
            wrapper.in((Object)"warehouse_code", (Collection)queryDto.getVirtualWarehouseCodes());
        }
        if (queryDto.getVirtualWarehouseType() != null) {
            wrapper.in((Object)"warehouse_type", new Object[]{queryDto.getVirtualWarehouseType()});
        }
        if (queryDto.getGroupId() != null) {
            wrapper.in((Object)"group_id", new Object[]{queryDto.getGroupId()});
        }
        wrapper.in(CollectionUtils.isNotEmpty((Collection)queryDto.getVirtualWarehouseCodes()), (Object)"warehouse_code", (Collection)queryDto.getVirtualWarehouseCodes());
        HashMap virtualToLogicMap = Maps.newHashMap();
        HashMap virtualToChannelMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLogicWarehouseCodes())) {
            List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", (Collection)queryDto.getLogicWarehouseCodes())).eq((Object)"status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)inventorySharedWarehouseEos)) {
                log.info("\u903b\u8f91\u4ed3\u7f16\u7801\uff1a{}, \u6ca1\u6709\u6709\u6548\u5171\u4eab\u7b56\u7565\u914d\u7f6e", (Object)queryDto.getLogicWarehouseCodes());
                return Lists.newArrayList();
            }
            Map<String, List<InventorySharedWarehouseEo>> logicWarehouseMap = inventorySharedWarehouseEos.stream().collect(Collectors.groupingBy(InventorySharedWarehouseEo::getWarehouseCode));
            Set shareCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getSharedCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(shareCodes)) {
                log.info("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u5171\u4eab\u914d\u7f6e");
                return Lists.newArrayList();
            }
            List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", shareCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)inventorySharedEos)) {
                log.info("\u903b\u8f91\u4ed3\u7f16\u7801\uff1a{}, \u5171\u4eab\u7f16\u7801 {}, \u6ca1\u6709\u5bf9\u5e94\u5171\u4eab\u7b56\u7565", (Object)queryDto.getLogicWarehouseCodes(), shareCodes);
                return Lists.newArrayList();
            }
            Map<String, List<InventorySharedEo>> inventorySharedMap = inventorySharedEos.stream().collect(Collectors.groupingBy(InventorySharedEo::getSharedCode));
            for (Map.Entry<String, List<InventorySharedWarehouseEo>> entry : logicWarehouseMap.entrySet()) {
                String logicWarehouseCode = entry.getKey();
                ArrayList inventorySharedWarehouseEoList = entry.getValue();
                if (null == inventorySharedWarehouseEoList) {
                    inventorySharedWarehouseEoList = Lists.newArrayList();
                }
                for (InventorySharedWarehouseEo sharedWarehouseEo : inventorySharedWarehouseEoList) {
                    ArrayList inventorySharedEoList = inventorySharedMap.get(sharedWarehouseEo.getSharedCode());
                    if (null == inventorySharedEoList) {
                        inventorySharedEoList = Lists.newArrayList();
                    }
                    for (InventorySharedEo inventorySharedEo : inventorySharedEoList) {
                        Set logicWarehouseCodes = (Set)virtualToLogicMap.get(inventorySharedEo.getVirtualWarehouseCode());
                        if (null == logicWarehouseCodes) {
                            logicWarehouseCodes = Sets.newHashSet();
                        }
                        logicWarehouseCodes.add(logicWarehouseCode);
                        virtualToLogicMap.put(inventorySharedEo.getVirtualWarehouseCode(), logicWarehouseCodes);
                    }
                }
            }
            Set virtualWarehouseCodes = inventorySharedEos.stream().map(InventorySharedEo::getVirtualWarehouseCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(virtualWarehouseCodes)) {
                log.info("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u6e20\u9053\u4ed3\u5173\u8054\u865a\u4ed3Code");
                virtualToLogicMap.clear();
                return Lists.newArrayList();
            }
            wrapper.in((Object)"warehouse_code", virtualWarehouseCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getChannelWarehouseCodes())) {
            List channelWarehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", (Collection)queryDto.getChannelWarehouseCodes())).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)channelWarehouseEos)) {
                log.info("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u6e20\u9053\u4ed3\u6570\u636e");
                return Lists.newArrayList();
            }
            Map channelWarehouseMap = channelWarehouseEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            Set channelWarehouseIds = channelWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
            List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"channel_warehouse_id", channelWarehouseIds)).eq((Object)"valid_flag", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
                log.info("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u6e20\u9053\u4ed3\u5173\u8054\u865a\u4ed3\u6570\u636e");
                return Lists.newArrayList();
            }
            Map<Long, List<RelVirtualWarehouseEo>> virtualWarehouseMap = relVirtualWarehouseEos.stream().collect(Collectors.groupingBy(RelVirtualWarehouseEo::getVirtualWarehouseId));
            Set<Long> virtualWarehouseIds = virtualWarehouseMap.keySet();
            if (CollectionUtils.isEmpty(virtualWarehouseIds)) {
                log.info("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u6e20\u9053\u4ed3\u5173\u8054\u865a\u4ed3ID");
                return Lists.newArrayList();
            }
            for (Map.Entry<Long, List<RelVirtualWarehouseEo>> entry : virtualWarehouseMap.entrySet()) {
                Set channelCodes;
                Long virtualWarehouseId = entry.getKey();
                ArrayList relVirtualWarehouseEoList = entry.getValue();
                if (null == relVirtualWarehouseEoList) {
                    relVirtualWarehouseEoList = Lists.newArrayList();
                }
                if (null == (channelCodes = (Set)virtualToChannelMap.get(virtualWarehouseId))) {
                    channelCodes = Sets.newHashSet();
                }
                for (RelVirtualWarehouseEo relVirtualWarehouseEo : relVirtualWarehouseEoList) {
                    Long channelWarehouseId = relVirtualWarehouseEo.getChannelWarehouseId();
                    ChannelWarehouseEo channelWarehouseEo = (ChannelWarehouseEo)channelWarehouseMap.get(channelWarehouseId);
                    if (null == channelWarehouseEo) continue;
                    channelCodes.add(channelWarehouseEo.getWarehouseCode());
                }
                virtualToChannelMap.put(virtualWarehouseId, channelCodes);
            }
            wrapper.in((Object)"id", virtualWarehouseIds);
        }
        wrapper.eq((Object)"dr", (Object)YesNoHelper.NO);
        wrapper.orderByDesc((Object)"create_time");
        List eoList = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)wrapper);
        List<VirtualWarehouseRespDto> virtualWarehouseRespDtos = this.getVirtualWarehouseRespDtos(eoList);
        for (VirtualWarehouseRespDto virtualWarehouseRespDto : virtualWarehouseRespDtos) {
            virtualWarehouseRespDto.setLogicWarehouseCodes((Set)virtualToLogicMap.get(virtualWarehouseRespDto.getWarehouseCode()));
            virtualWarehouseRespDto.setChannelWarehouseCodes((Set)virtualToChannelMap.get(virtualWarehouseRespDto.getId()));
        }
        return virtualWarehouseRespDtos;
    }

    @Override
    public PageInfo<VirtualWarehouseRespDto> queryByPage(VirtualWarehousePageReqDto virtualWarehousePageReqDto) {
        ExtQueryChainWrapper<VirtualWarehouseEo> filter = this.getVirtualWarehouseEoExtQueryChainWrapper(virtualWarehousePageReqDto);
        if (filter == null) {
            return new PageInfo();
        }
        PageInfo eoPageInfo = filter.select(new String[0]).page(virtualWarehousePageReqDto.getPageNum(), virtualWarehousePageReqDto.getPageSize());
        if (CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            return new PageInfo();
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums", "subWarehouseName"});
        List<VirtualWarehouseRespDto> dtoList = this.getVirtualWarehouseRespDtos(eoPageInfo.getList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private ExtQueryChainWrapper<VirtualWarehouseEo> getVirtualWarehouseEoExtQueryChainWrapper(VirtualWarehousePageReqDto virtualWarehousePageReqDto) {
        ExtQueryChainWrapper filter = this.virtualWarehouseDomain.filter();
        if (ObjectUtils.isNotEmpty((Object)virtualWarehousePageReqDto.getGroupId())) {
            filter.eq((Object)"group_id", (Object)virtualWarehousePageReqDto.getGroupId());
        }
        if (virtualWarehousePageReqDto.getGroupIsNull().booleanValue()) {
            filter.isNull((Object)"group_id");
        }
        if (StringUtils.isNotEmpty((CharSequence)virtualWarehousePageReqDto.getWarehouseCode())) {
            filter.like((Object)"warehouse_code", (Object)virtualWarehousePageReqDto.getWarehouseCode());
        }
        if (null != virtualWarehousePageReqDto.getWarehouseName()) {
            filter.like((Object)"warehouse_name", (Object)virtualWarehousePageReqDto.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)virtualWarehousePageReqDto.getWarehouseStatus())) {
            filter.eq((Object)"warehouse_status", (Object)virtualWarehousePageReqDto.getWarehouseStatus());
        }
        if (null != virtualWarehousePageReqDto.getWarehouseType()) {
            filter.eq((Object)"warehouse_type", (Object)virtualWarehousePageReqDto.getWarehouseType());
        }
        if (null != virtualWarehousePageReqDto.getLineType()) {
            filter.eq((Object)"line_type", (Object)virtualWarehousePageReqDto.getLineType());
        }
        filter.orderByDesc((Object)"update_time");
        return filter;
    }

    private List<VirtualWarehouseRespDto> getVirtualWarehouseRespDtos(List<VirtualWarehouseEo> eoList) {
        ArrayList<VirtualWarehouseRespDto> virtualWarehouseRespDtos = new ArrayList<VirtualWarehouseRespDto>();
        if (CollectionUtils.isEmpty(eoList)) {
            return Lists.newArrayList();
        }
        List groupIds = eoList.stream().map(VirtualWarehouseEo::getGroupId).filter(Objects::nonNull).collect(Collectors.toList());
        List mainEoList = eoList.stream().filter(o -> Objects.equals(o.getWarehouseType(), VirtualWarehouseTypeEnum.OVERALL.getCode())).distinct().collect(Collectors.toList());
        List inventorySharedEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(mainEoList)) {
            Set mainVirtualWarehouseCodes = mainEoList.stream().map(VirtualWarehouseEo::getWarehouseCode).collect(Collectors.toSet());
            inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"virtual_warehouse_code", mainVirtualWarehouseCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        }
        List virtualGroupEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(groupIds) && null == (virtualGroupEos = this.virtualGroupDomain.selectByIds(groupIds))) {
            virtualGroupEos = Lists.newArrayList();
        }
        Map<Long, VirtualGroupEo> virtualGroupEoMap = virtualGroupEos.stream().collect(Collectors.toMap(BaseEo::getId, virtualGroup -> virtualGroup));
        for (VirtualWarehouseEo eo : eoList) {
            VirtualWarehouseRespDto virtualWarehouseRespDto = new VirtualWarehouseRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)virtualWarehouseRespDto);
            VirtualGroupEo groupEo = virtualGroupEoMap.get(eo.getGroupId());
            if (null != groupEo) {
                virtualWarehouseRespDto.setGroupName(groupEo.getName());
                virtualWarehouseRespDto.setSubWarehouseName(groupEo.getSubWarehouseName());
            }
            Boolean hasShare = Objects.equals(eo.getWarehouseType(), VirtualWarehouseTypeEnum.OVERALL.getCode()) && null != inventorySharedEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getVirtualWarehouseCode(), (CharSequence)eo.getWarehouseCode())).findFirst().orElse(null);
            virtualWarehouseRespDto.setHasShare(hasShare);
            virtualWarehouseRespDtos.add(virtualWarehouseRespDto);
        }
        return virtualWarehouseRespDtos;
    }

    @Override
    public Map<String, VirtualWarehouseRespDto> queryByCodes(Collection<String> warehouseCodes) {
        List virtualWarehouseEos;
        if (CollectionUtils.isNotEmpty(warehouseCodes) && CollectionUtils.isNotEmpty((Collection)(virtualWarehouseEos = ((ExtQueryChainWrapper)this.virtualWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes)).list()))) {
            ArrayList virtualWarehouseRespDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)virtualWarehouseEos, virtualWarehouseRespDtos, VirtualWarehouseRespDto.class);
            return virtualWarehouseRespDtos.stream().collect(Collectors.toMap(VirtualWarehouseRespDto::getWarehouseCode, a -> a));
        }
        return new HashMap<String, VirtualWarehouseRespDto>();
    }

    @Override
    public void batchUpdateVirtualWarehouseGroup(VirtualWarehouseReqDto addReqDto) {
        this.virtualWarehouseDomain.updateGroupByIds(addReqDto.getGroupId(), addReqDto.getIds());
    }

    @Override
    public List<CsLogicWarehouseRespDto> queryLogicWarehouse(String virtualWarehouseCode) {
        VirtualWarehouseEo mainWarehouseEo;
        AssertUtils.notBlank((String)virtualWarehouseCode, (String)"\u865a\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)virtualWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)virtualWarehouseEos) || CollectionUtils.size((Object)virtualWarehouseEos) > 1) {
            throw new BizException("\u4f9b\u8d27\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u552f\u4e00");
        }
        VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEos.get(0);
        AssertUtils.notNull((Object)virtualWarehouseEo.getGroupId(), (String)"\u4f9b\u8d27\u4ed3\u5206\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (VirtualWarehouseTypeEnum.OVERALL.getCode().equals(virtualWarehouseEo.getWarehouseType())) {
            mainWarehouseEo = virtualWarehouseEo;
        } else {
            List mainVirtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"group_id", (Object)virtualWarehouseEo.getGroupId())).eq((Object)"warehouse_type", (Object)VirtualWarehouseTypeEnum.OVERALL.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)mainVirtualWarehouseEos) || CollectionUtils.size((Object)mainVirtualWarehouseEos) > 1) {
                throw new BizException("\u4f9b\u8d27\u4ed3\u5206\u7ec4\u4e2d\u4e3b\u4f9b\u8d27\u4ed3\u4e0d\u552f\u4e00");
            }
            mainWarehouseEo = (VirtualWarehouseEo)mainVirtualWarehouseEos.get(0);
        }
        AssertUtils.notNull((Object)mainWarehouseEo, (String)"\u4e3b\u4f9b\u8d27\u4ed3\u67e5\u8be2\u4e0d\u5230");
        List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"virtual_warehouse_code", (Object)mainWarehouseEo.getWarehouseCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inventorySharedEos, (String)"\u4e3b\u4f9b\u8d27\u4ed3\u7b56\u7565\u4e0d\u5b58\u5728");
        List shareCodes = inventorySharedEos.stream().map(InventorySharedEo::getSharedCode).distinct().collect(Collectors.toList());
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", shareCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inventorySharedWarehouseEos, (String)"\u4f9b\u8d27\u7b56\u7565\u627e\u4e0d\u5230\u5173\u8054\u903b\u8f91\u4ed3\u5173\u7cfb");
        List logicWarehouseCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getWarehouseCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        AssertUtils.notEmpty(logicWarehouseCodes, (String)"\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u903b\u8f91\u4ed3\u7f16\u7801");
        CsLogicWarehouseQueryDto csLogicWarehouseQueryDto = new CsLogicWarehouseQueryDto();
        csLogicWarehouseQueryDto.setWarehouseCodeList(logicWarehouseCodes);
        return (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseApi.queryByParam(csLogicWarehouseQueryDto));
    }
}

