/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.mq.vo.DisplacePreemptVo;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelInventoryExposedService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_SHARE_DISPLACE_PREEMPT_TOPIC", tag="DISPLACE_PREEMPT_ASYNC")
public class DisplacePreemptProcess
implements IMessageProcessor<List<DisplacePreemptVo>> {
    private static final Logger log = LoggerFactory.getLogger(DisplacePreemptProcess.class);
    @Autowired
    IChannelInventoryExposedService channelInventoryExposedService;
    @Autowired
    ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(List<DisplacePreemptVo> message) {
        String messageData = JSON.toJSONString(message);
        log.info("[\u63a5\u6536\u5230\u8425\u517b\u5bb6\u7f6e\u6362\u8ba2\u5355MQ\u8bf7\u6c42]\u6d88\u606f\uff1a{}", (Object)messageData);
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        try {
            long start = System.currentTimeMillis();
            String parentNo = message.get(0).getDisplaceSourceNo();
            log.info("ChannelInventoryExposedServiceImpl#doDisplacePreemptProcess:{}", (Object)parentNo);
            Mutex mutex = this.lockService.lock("ChannelInventoryExposedServiceImpl#doDisplacePreemptProcess", parentNo, 600, 605, TimeUnit.SECONDS);
            try {
                this.channelInventoryExposedService.doDisplacePreemptProcess(message);
            }
            finally {
                this.lockService.unlock(mutex);
            }
            log.info("doDisplacePreemptProcess \u6267\u884c\u65f6\u95f4:{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - start));
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.error("\u8425\u517b\u5bb6\u7f6e\u6362\u8ba2\u5355MQ\u8bf7\u6c42\u5931\u8d25", (Object)e.getMessage(), (Object)e);
            return MessageResponse.ERROR;
        }
    }
}

