/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsAutoAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IShareGoodsOrderService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IVirtualWarehouseService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="SHARE_GOODS_AUTO_AUDIT")
public class ShareGoodsOrderProcess
implements IMessageProcessor<ShareGoodsAutoAuditReqDto> {
    private static final Logger logger = LoggerFactory.getLogger(ShareGoodsOrderProcess.class);
    @Resource
    private IShareGoodsOrderService shareGoodsOrderService;
    @Resource
    private IVirtualWarehouseService virtualWarehouseService;

    public MessageResponse process(ShareGoodsAutoAuditReqDto message) {
        String messageData = JSON.toJSONString((Object)message);
        logger.info("[\u63a5\u6536\u5230\u5206\u8d27\u5355MQ\u8bf7\u6c42]\u6d88\u606f\uff1a{}", (Object)messageData);
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        try {
            this.shareGoodsOrderService.createAndAuditShareGoodsOrder(message);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }
}

