/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.adapter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelInventoryExposedService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.share.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.share.dto.calc.DisplacePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptAndOutDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.UpdatePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class ChannelInventoryExposedApiImpl
implements IChannelInventoryExposedApi {
    private static final Logger log = LoggerFactory.getLogger(ChannelInventoryExposedApiImpl.class);
    @Autowired
    IChannelInventoryExposedService channelInventoryExposedService;
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> preemptInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(inventoryOperateReqDto.getSourceNo());
        preemptParam.setSourceType(inventoryOperateReqDto.getSourceType());
        preemptParam.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
        preemptParam.setIsShoutVirtualWarehouse(inventoryOperateReqDto.getIsShoutVirtualWarehouse());
        preemptParam.setShoutVirtualWarehouseCode(inventoryOperateReqDto.getShoutVirtualWarehouseCode());
        preemptParam.setRemark("");
        ArrayList details = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto operateCargoReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
            OperationDetailDto detail = new OperationDetailDto();
            detail.setSkuCode(operateCargoReqDto.getSkuCode());
            detail.setWarehouseCode(operateCargoReqDto.getWarehouseCode());
            detail.setNum(operateCargoReqDto.getChangeInventory());
            details.add(detail);
        }
        preemptParam.setDetails((List)details);
        this.calcInventoryService.preempt(preemptParam);
        return RestResponse.VOID;
    }

    public RestResponse<Void> releaseInventoryByPreemption(CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(releasePreemptOperateReqDto.getSourceNo());
        releasePreemptParam.setSourceType(releasePreemptOperateReqDto.getSourceType());
        releasePreemptParam.setExternalOrderNo(releasePreemptOperateReqDto.getPlatformOrderNo());
        releasePreemptParam.setValidNegative(Boolean.valueOf(false));
        this.calcInventoryService.releasePreempt(releasePreemptParam);
        return RestResponse.VOID;
    }

    public RestResponse<Void> releasePreempt(ReleasePreemptDto releasePreemptParam) {
        releasePreemptParam.setValidNegative(Boolean.valueOf(false));
        this.calcInventoryService.releasePreempt(releasePreemptParam);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchInventoryByPreemption(List<CsInventoryOperateReqDto> inventoryOperateReqDtos) {
        this.channelInventoryExposedService.batchInventoryByPreemption(inventoryOperateReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updatePreempt(UpdatePreemptDto updatePreemptParam) {
        HashMap cargoValidNegativeMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)updatePreemptParam.getReleasePreemptParamList()) && CollectionUtils.isNotEmpty((Collection)updatePreemptParam.getPreemptParamList()) && updatePreemptParam.getReleasePreemptParamList().size() == 1 && updatePreemptParam.getPreemptParamList().size() == 1) {
            for (ReleasePreemptDto releasePreemptParam : updatePreemptParam.getReleasePreemptParamList()) {
                List csInventoryPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).eq(InventoryPreemptionEo::getSourceNo, (Object)releasePreemptParam.getSourceNo())).eq(InventoryPreemptionEo::getWarehouseClassify, (Object)WarehouseClassifyEnum.CHANNEL.getCode())).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                if (!CollectionUtils.isNotEmpty((Collection)csInventoryPreemptionEos)) continue;
                HashMap preemptNumMap = Maps.newHashMap();
                for (InventoryPreemptionEo csInventoryPreemptionEo : csInventoryPreemptionEos) {
                    BigDecimal bigDecimal = preemptNumMap.getOrDefault(csInventoryPreemptionEo.getSkuCode(), BigDecimal.ZERO);
                    preemptNumMap.put(csInventoryPreemptionEo.getSkuCode(), BigDecimalUtils.add((BigDecimal)bigDecimal, (BigDecimal)csInventoryPreemptionEo.getPreemptNum()));
                }
                HashMap reqNumMap = Maps.newHashMap();
                for (OperationDetailDto operationDetailDto : ((PreemptDto)updatePreemptParam.getPreemptParamList().get(0)).getDetails()) {
                    reqNumMap.put(operationDetailDto.getSkuCode(), BigDecimalUtils.add((BigDecimal)((BigDecimal)reqNumMap.get(operationDetailDto.getSkuCode())), (BigDecimal)operationDetailDto.getNum()));
                }
                for (Map.Entry entry : reqNumMap.entrySet()) {
                    String cargoCode = (String)entry.getKey();
                    BigDecimal preemptNum = (BigDecimal)preemptNumMap.get(cargoCode);
                    Boolean validNegative = BigDecimalUtils.gt((BigDecimal)((BigDecimal)entry.getValue()), (BigDecimal)preemptNum);
                    cargoValidNegativeMap.put(cargoCode, validNegative);
                }
            }
            log.info("\u66f4\u65b0\u9884\u5360\u5bf9\u6bd4\u4e0e\u9884\u5360\u8bb0\u5f55\u662f\u5426\u76f8\u7b49\uff0ccargoValidNegativeMap: {}", (Object)LogUtils.buildLogContent((Object)cargoValidNegativeMap));
            for (OperationDetailDto preemptDetail : ((PreemptDto)updatePreemptParam.getPreemptParamList().get(0)).getDetails()) {
                preemptDetail.setValidNegative(cargoValidNegativeMap.getOrDefault(preemptDetail.getSkuCode(), true));
            }
        } else if (CollectionUtils.isNotEmpty((Collection)updatePreemptParam.getPreemptParamList())) {
            for (PreemptDto param : updatePreemptParam.getPreemptParamList()) {
                for (OperationDetailDto detail : param.getDetails()) {
                    detail.setValidNegative(param.getValidNegative());
                }
            }
        }
        this.calcInventoryService.updatePreempt(updatePreemptParam.getReleasePreemptParamList(), updatePreemptParam.getPreemptParamList());
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updateInventoryByPreemption(List<CsInventoryOperateReqDto> inventoryOperateReqDtos) {
        HashMap cargoValidNegativeMap = Maps.newHashMap();
        for (CsInventoryOperateReqDto inventoryOperateReqDto : inventoryOperateReqDtos) {
            List csInventoryPreemptionEos;
            if (StringUtils.equals((CharSequence)inventoryOperateReqDto.getReleaseSourceNo(), (CharSequence)inventoryOperateReqDto.getSourceNo()) && CollectionUtils.isNotEmpty((Collection)(csInventoryPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).eq(InventoryPreemptionEo::getSourceNo, (Object)inventoryOperateReqDto.getSourceNo())).eq(InventoryPreemptionEo::getWarehouseClassify, (Object)WarehouseClassifyEnum.CHANNEL.getCode())).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO))))) {
                Map<String, BigDecimal> preemptNumMap = csInventoryPreemptionEos.stream().collect(Collectors.toMap(InventoryPreemptionEo::getSkuCode, InventoryPreemptionEo::getPreemptNum));
                HashMap reqNumMap = Maps.newHashMap();
                for (CsInventoryOperateCargoReqDto csInventoryOperateCargoReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
                    reqNumMap.put(csInventoryOperateCargoReqDto.getSkuCode(), BigDecimalUtils.add((BigDecimal)((BigDecimal)reqNumMap.get(csInventoryOperateCargoReqDto.getSkuCode())), (BigDecimal)csInventoryOperateCargoReqDto.getChangeInventory()));
                }
                for (Map.Entry entry : reqNumMap.entrySet()) {
                    String cargoCode = (String)entry.getKey();
                    BigDecimal preemptNum = preemptNumMap.get(cargoCode);
                    Boolean validNegative = BigDecimalUtils.gt((BigDecimal)((BigDecimal)entry.getValue()), (BigDecimal)preemptNum);
                    cargoValidNegativeMap.put(cargoCode, validNegative);
                }
            }
            log.info("\u66f4\u65b0\u9884\u5360\u5bf9\u6bd4\u4e0e\u9884\u5360\u8bb0\u5f55\u662f\u5426\u76f8\u7b49\uff0ccargoValidNegativeMap: {}", (Object)LogUtils.buildLogContent((Object)cargoValidNegativeMap));
            ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
            releasePreemptParam.setSourceNo(inventoryOperateReqDto.getSourceNo());
            if (StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getReleaseSourceNo())) {
                releasePreemptParam.setSourceNo(inventoryOperateReqDto.getReleaseSourceNo());
            }
            releasePreemptParam.setSourceType(inventoryOperateReqDto.getSourceType());
            releasePreemptParam.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
            releasePreemptParam.setIsErrorForNotFoundPreempt(Boolean.valueOf(false));
            PreemptDto preemptParam = new PreemptDto();
            preemptParam.setSourceNo(inventoryOperateReqDto.getSourceNo());
            preemptParam.setSourceType(inventoryOperateReqDto.getSourceType());
            preemptParam.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
            preemptParam.setRemark("");
            preemptParam.setIsShoutVirtualWarehouse(inventoryOperateReqDto.getIsShoutVirtualWarehouse());
            preemptParam.setShoutVirtualWarehouseCode(inventoryOperateReqDto.getShoutVirtualWarehouseCode());
            ArrayList details = Lists.newArrayList();
            for (CsInventoryOperateCargoReqDto csInventoryOperateCargoReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
                OperationDetailDto detail = new OperationDetailDto();
                detail.setSkuCode(csInventoryOperateCargoReqDto.getSkuCode());
                detail.setWarehouseCode(csInventoryOperateCargoReqDto.getWarehouseCode());
                detail.setNum(csInventoryOperateCargoReqDto.getChangeInventory());
                detail.setValidNegative((Boolean)cargoValidNegativeMap.get(detail.getSkuCode()));
                details.add(detail);
            }
            preemptParam.setDetails((List)details);
            if (YesNoHelper.NO.equals(inventoryOperateReqDto.getNegativeValidate())) {
                preemptParam.setValidNegative(Boolean.FALSE);
            }
            this.calcInventoryService.updatePreempt((List)Lists.newArrayList((Object[])new ReleasePreemptDto[]{releasePreemptParam}), (List)Lists.newArrayList((Object[])new PreemptDto[]{preemptParam}));
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> supplyByChannelWarehouseCode(String channelWarehouseCode, List<String> cargoCodes) {
        this.calcInventoryService.refreshChannelInventory((List)Lists.newArrayList((Object[])new String[]{channelWarehouseCode}), cargoCodes);
        this.calcInventoryService.reloadChannel((List)Lists.newArrayList((Object[])new String[]{channelWarehouseCode}), cargoCodes);
        return RestResponse.VOID;
    }

    public RestResponse<Void> releasePreemptAndOut(ReleasePreemptAndOutDto param) {
        this.calcInventoryService.releasePreemptAndOut(param);
        return RestResponse.VOID;
    }

    public RestResponse<Void> displacePreempt(DisplacePreemptDto param) {
        this.calcInventoryService.displacePreempt(param);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> preempt(PreemptDto param) {
        this.calcInventoryService.preempt(param);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> preemptVirtual(PreemptDto param) {
        this.calcInventoryService.preemptVirtual(param);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> supplyByLogicLogs(@RequestBody List<CsInventoryLogRespDto> logs) {
        this.calcInventoryService.supplyByLogicLogs(logs);
        return RestResponse.VOID;
    }
}

