/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseItemAddListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelWarehouseItemService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelWarehouseService;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseItemDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.enums.ShareItemTypeEnum;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseItemEo;
import com.yunxi.dg.base.center.share.eo.RelVirtualWarehouseEo;
import com.yunxi.dg.base.center.share.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizChannelWarehouseItemService")
public class ChannelWarehouseItemServiceImpl
implements IChannelWarehouseItemService {
    private static final Logger log = LoggerFactory.getLogger(ChannelWarehouseItemServiceImpl.class);
    @Resource
    IChannelWarehouseItemDomain channelWarehouseItemDomain;
    @Resource
    IRelVirtualWarehouseDomain relVirtualWarehouseDomain;
    @Resource
    IChannelWarehouseService channelWarehouseService;
    @Resource
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addChannelWarehouseItem(ChannelWarehouseItemAddListReqDto addListReqDto) {
        this.validParams(addListReqDto);
        RelVirtualWarehouseEo relVirtualWarehouseEo = (RelVirtualWarehouseEo)this.relVirtualWarehouseDomain.selectByPrimaryKey(addListReqDto.getRelVirtualWarehouseId());
        relVirtualWarehouseEo.setRelItemType(addListReqDto.getRelItemType());
        this.relVirtualWarehouseDomain.updateSelective((BaseEo)relVirtualWarehouseEo);
        ChannelWarehouseRespDto respDto = this.channelWarehouseService.selectByPrimaryKey(relVirtualWarehouseEo.getChannelWarehouseId());
        AssertUtils.notNull((Object)respDto, (String)"\u6e20\u9053\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
        ArrayList eoList = new ArrayList();
        List<ChannelWarehouseItemRespDto> warehouseItemRespDtos = this.queryByListOnly(addListReqDto.getRelVirtualWarehouseId());
        log.info("\u8bfb\u53d6\u5df2\u7ecf\u914d\u7f6e\u7684\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(warehouseItemRespDtos));
        if (ShareItemTypeEnum.PART_ITEM.getCode().equals(addListReqDto.getRelItemType())) {
            this.channelWarehouseItemDomain.deleteByRelVirtualWarehouseId(relVirtualWarehouseEo.getId());
            addListReqDto.getChannelWarehouseItemAddReqDtos().forEach(addDto -> {
                ChannelWarehouseItemEo channelWarehouseItemEo = new ChannelWarehouseItemEo();
                channelWarehouseItemEo.setRelVirtualWarehouseId(addListReqDto.getRelVirtualWarehouseId());
                channelWarehouseItemEo.setItemCode(addDto.getItemCode());
                eoList.add(channelWarehouseItemEo);
            });
            int i = this.channelWarehouseItemDomain.getMapper().insertBatch(eoList);
            log.info("\u6279\u91cf\u63d2\u5165\u5b8c\u6210\uff0c\u6267\u884c\u4e86{}\u6761\u6570\u636e", (Object)i);
        } else {
            this.channelWarehouseItemDomain.deleteByRelVirtualWarehouseId(relVirtualWarehouseEo.getId());
        }
    }

    private void validParams(ChannelWarehouseItemAddListReqDto addListReqDto) {
        AssertUtils.notNull((Object)addListReqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((!ShareItemTypeEnum.PART_ITEM.getCode().equals(addListReqDto.getRelItemType()) || !CollectionUtils.isEmpty((Collection)addListReqDto.getChannelWarehouseItemAddReqDtos()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u5173\u7cfb\u6570\u636e\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addListReqDto.getRelVirtualWarehouseId(), (String)"id\u9519\u8bef");
        log.info("\u914d\u7f6e\u6e20\u9053\u5546\u54c1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)addListReqDto));
    }

    @Override
    public void modifyChannelWarehouseItem(ChannelWarehouseItemReqDto modifyReqDto) {
        ChannelWarehouseItemEo channelWarehouseItemEo = new ChannelWarehouseItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)channelWarehouseItemEo);
        this.channelWarehouseItemDomain.updateSelective((BaseEo)channelWarehouseItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeChannelWarehouseItem(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.channelWarehouseItemDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ChannelWarehouseItemRespDto queryById(Long id) {
        ChannelWarehouseItemEo channelWarehouseItemEo = (ChannelWarehouseItemEo)this.channelWarehouseItemDomain.selectByPrimaryKey(id);
        ChannelWarehouseItemRespDto channelWarehouseItemRespDto = new ChannelWarehouseItemRespDto();
        DtoHelper.eo2Dto((BaseEo)channelWarehouseItemEo, (BaseVo)channelWarehouseItemRespDto);
        return channelWarehouseItemRespDto;
    }

    @Override
    public List<ChannelWarehouseItemRespDto> queryByList(Long relVirtualWarehouseId) {
        AssertUtils.notNull((Object)relVirtualWarehouseId, (String)"id\u9519\u8bef");
        List channelWarehouseItemEos = ((ExtQueryChainWrapper)this.channelWarehouseItemDomain.filter().eq((Object)"rel_virtual_warehouse_id", (Object)relVirtualWarehouseId)).list();
        ArrayList<ChannelWarehouseItemRespDto> channelWarehouseItemRespDtos = new ArrayList<ChannelWarehouseItemRespDto>();
        channelWarehouseItemEos.forEach(eo -> {
            ChannelWarehouseItemRespDto channelWarehouseItemRespDto = new ChannelWarehouseItemRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)channelWarehouseItemRespDto);
            channelWarehouseItemRespDtos.add(channelWarehouseItemRespDto);
        });
        return channelWarehouseItemRespDtos;
    }

    @Override
    public List<ChannelWarehouseItemRespDto> queryByListOnly(Long relVirtualWarehouseId) {
        AssertUtils.notNull((Object)relVirtualWarehouseId, (String)"id\u9519\u8bef");
        List channelWarehouseItemEos = ((ExtQueryChainWrapper)this.channelWarehouseItemDomain.filter().eq((Object)"rel_virtual_warehouse_id", (Object)relVirtualWarehouseId)).list();
        ArrayList<ChannelWarehouseItemRespDto> channelWarehouseItemRespDtos = new ArrayList<ChannelWarehouseItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)channelWarehouseItemEos, channelWarehouseItemRespDtos, ChannelWarehouseItemRespDto.class);
        return channelWarehouseItemRespDtos;
    }

    @Override
    public PageInfo<ChannelWarehouseItemRespDto> queryByPage(Long relVirtualWarehouseId, Integer pageNum, Integer pageSize) {
        ChannelWarehouseItemEo channelWarehouseItemEo = new ChannelWarehouseItemEo();
        channelWarehouseItemEo.setRelVirtualWarehouseId(relVirtualWarehouseId);
        PageInfo eoPageInfo = this.channelWarehouseItemDomain.selectPage((BaseEo)channelWarehouseItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        eoPageInfo.getList().forEach(eo -> {
            ChannelWarehouseItemRespDto respDto = new ChannelWarehouseItemRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
            dtoList.add(respDto);
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<String, ItemSkuDto> queryBySkuCodes(List<String> skuCodes) {
        List skuDtoList = this.itemSkuProxy.queryBySkuCodes(skuCodes);
        if (CollectionUtils.isEmpty((Collection)skuDtoList)) {
            return new HashMap<String, ItemSkuDto>();
        }
        return skuDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, skuDto -> skuDto));
    }
}

