/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IShareGoodsOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IVirtualInventoryService;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.domain.entity.IShareGoodsOrderDetailDomain;
import com.yunxi.dg.base.center.share.domain.entity.IShareGoodsOrderDomain;
import com.yunxi.dg.base.center.share.eo.ShareGoodsOrderDetailEo;
import com.yunxi.dg.base.center.share.eo.ShareGoodsOrderEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizShareGoodsOrderDetailService")
public class ShareGoodsOrderDetailServiceImpl
implements IShareGoodsOrderDetailService {
    @Resource
    IShareGoodsOrderDetailDomain shareGoodsOrderDetailDomain;
    @Resource
    IShareGoodsOrderDomain shareGoodsOrderDomain;
    @Resource
    IVirtualInventoryService virtualInventoryService;

    @Override
    public Long addShareGoodsOrderDetail(ShareGoodsOrderDetailReqDto addReqDto) {
        ShareGoodsOrderDetailEo shareGoodsOrderDetailEo = new ShareGoodsOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)shareGoodsOrderDetailEo);
        this.shareGoodsOrderDetailDomain.insert((BaseEo)shareGoodsOrderDetailEo);
        return shareGoodsOrderDetailEo.getId();
    }

    @Override
    public void modifyShareGoodsOrderDetail(ShareGoodsOrderDetailReqDto modifyReqDto) {
        ShareGoodsOrderDetailEo shareGoodsOrderDetailEo = new ShareGoodsOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)shareGoodsOrderDetailEo);
        this.shareGoodsOrderDetailDomain.updateSelective((BaseEo)shareGoodsOrderDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShareGoodsOrderDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.shareGoodsOrderDetailDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ShareGoodsOrderDetailRespDto queryById(Long id) {
        ShareGoodsOrderDetailEo shareGoodsOrderDetailEo = (ShareGoodsOrderDetailEo)this.shareGoodsOrderDetailDomain.selectByPrimaryKey(id);
        ShareGoodsOrderDetailRespDto shareGoodsOrderDetailRespDto = new ShareGoodsOrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)shareGoodsOrderDetailEo, (BaseVo)shareGoodsOrderDetailRespDto);
        return shareGoodsOrderDetailRespDto;
    }

    @Override
    public PageInfo<ShareGoodsOrderDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ShareGoodsOrderDetailReqDto shareGoodsOrderDetailReqDto = (ShareGoodsOrderDetailReqDto)JSON.parseObject((String)filter, ShareGoodsOrderDetailReqDto.class);
        ShareGoodsOrderDetailEo shareGoodsOrderDetailEo = new ShareGoodsOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)shareGoodsOrderDetailReqDto, (BaseEo)shareGoodsOrderDetailEo);
        PageInfo eoPageInfo = this.shareGoodsOrderDetailDomain.selectPage((BaseEo)shareGoodsOrderDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<ShareGoodsOrderDetailRespDto> dtoList = new ArrayList<ShareGoodsOrderDetailRespDto>();
        this.getDetailRespDto(shareGoodsOrderDetailReqDto.getOrderNo(), eoPageInfo.getList(), dtoList);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ShareGoodsOrderDetailRespDto> queryByList(String orderNo) {
        List shareGoodsOrderDetailEos = ((ExtQueryChainWrapper)this.shareGoodsOrderDetailDomain.filter().eq((Object)"order_no", (Object)orderNo)).list();
        ArrayList<ShareGoodsOrderDetailRespDto> detailRespDtos = new ArrayList<ShareGoodsOrderDetailRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)shareGoodsOrderDetailEos)) {
            this.getDetailRespDto(orderNo, shareGoodsOrderDetailEos, detailRespDtos);
        }
        return detailRespDtos;
    }

    private void getDetailRespDto(String orderNo, List<ShareGoodsOrderDetailEo> shareGoodsOrderDetailEos, List<ShareGoodsOrderDetailRespDto> detailRespDtos) {
        ShareGoodsOrderEo shareGoodsOrderEo = (ShareGoodsOrderEo)((ExtQueryChainWrapper)this.shareGoodsOrderDomain.filter().eq((Object)"order_no", (Object)orderNo)).one();
        if (ObjectUtils.isNotEmpty((Object)shareGoodsOrderEo)) {
            List<String> skuCodes = shareGoodsOrderDetailEos.stream().map(ShareGoodsOrderDetailEo::getSkuCode).collect(Collectors.toList());
            List<VirtualInventoryRespDto> virtualInventoryRespDtos = this.virtualInventoryService.queryByCargoCodes(skuCodes, shareGoodsOrderEo.getSupplyWarehouseCode());
            Map<String, VirtualInventoryRespDto> virtualInventoryRespDtoMap = virtualInventoryRespDtos.stream().collect(Collectors.toMap(VirtualInventoryRespDto::getCargoCode, virtualInventory -> virtualInventory));
            shareGoodsOrderDetailEos.forEach(shareGoodsOrderDetailEo -> {
                ShareGoodsOrderDetailRespDto detailRespDto = new ShareGoodsOrderDetailRespDto();
                DtoHelper.eo2Dto((BaseEo)shareGoodsOrderDetailEo, (BaseVo)detailRespDto);
                detailRespDto.setInventoryQuantity(((VirtualInventoryRespDto)virtualInventoryRespDtoMap.get(shareGoodsOrderDetailEo.getSkuCode())).getAvailable());
                detailRespDtos.add(detailRespDto);
            });
        }
    }
}

