/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.VirtualGroupDetailDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.enums.MainWarehouseEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualGroupReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualGroupDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualGroupRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IVirtualGroupService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualGroupDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.dto.entity.VirtualGroupPageReqDto;
import com.yunxi.dg.base.center.share.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.eo.VirtualGroupEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizVirtualGroupService")
public class VirtualGroupServiceImpl
implements IVirtualGroupService {
    @Resource
    IVirtualGroupDomain virtualGroupDomain;
    @Resource
    IVirtualWarehouseDomain virtualWarehouseDomain;
    @Autowired
    ICacheService cacheService;

    @Override
    public Long addVirtualGroup(VirtualGroupReqDto addReqDto) {
        VirtualGroupEo virtualGroupEo = new VirtualGroupEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)virtualGroupEo);
        this.virtualGroupDomain.insert((BaseEo)virtualGroupEo);
        return virtualGroupEo.getId();
    }

    @Override
    public void modifyVirtualGroup(VirtualGroupReqDto modifyReqDto) {
        VirtualGroupEo virtualGroupEo = new VirtualGroupEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)virtualGroupEo);
        this.virtualGroupDomain.updateSelective((BaseEo)virtualGroupEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveVirtualGroup(VirtualGroupReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        if (null == reqDto.getId()) {
            this.insertVirtualGroup(reqDto);
        } else {
            this.editVirtualGroup(reqDto);
        }
    }

    private void insertVirtualGroup(VirtualGroupReqDto reqDto) {
        VirtualWarehouseEo virtualWarehouseEo;
        AssertUtils.notBlank((String)reqDto.getName(), (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List virtualWarehouseList = reqDto.getVirtualWarehouseList();
        if (null == virtualWarehouseList) {
            virtualWarehouseList = Lists.newArrayList();
        }
        List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().isNull((Object)"group_id")).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtils.notNull((Object)virtualWarehouseEos, (String)"\u6ca1\u6709\u53ef\u7528\u865a\u4ed3");
        Map virtualWarehouseEoMap = virtualWarehouseEos.stream().collect(Collectors.toMap(VirtualWarehouseEo::getWarehouseCode, Function.identity()));
        Map<Integer, List<VirtualWarehouseReqDto>> virtualWarehouseGroupMap = virtualWarehouseList.stream().collect(Collectors.groupingBy(VirtualWarehouseReqDto::getWarehouseType));
        List<VirtualWarehouseReqDto> mainList = virtualWarehouseGroupMap.get(MainWarehouseEnum.IS_MAIN_YES.getCode());
        if (CollectionUtil.isEmpty(mainList) || mainList.size() > 1) {
            throw new BizException("\u8be5\u5206\u7ec4\u6ca1\u6709\u8bbe\u7f6e\u4e3b\u865a\u4ed3 \u6216\u8005 \u4e3b\u865a\u4ed3\u4e0d\u552f\u4e00");
        }
        VirtualWarehouseEo mainVirtualWarehouse = (VirtualWarehouseEo)virtualWarehouseEoMap.get(mainList.get(0).getWarehouseCode());
        Integer status = reqDto.getStatus();
        if (null == status) {
            status = YesNoHelper.YES;
        }
        VirtualGroupEo virtualGroupEo = new VirtualGroupEo();
        virtualGroupEo.setName(reqDto.getName());
        virtualGroupEo.setWarehouseNum(Integer.valueOf(virtualWarehouseList.size()));
        virtualGroupEo.setStatus(status);
        virtualGroupEo.setOverallWarehouseName(mainVirtualWarehouse.getWarehouseName());
        virtualGroupEo.setExtension(reqDto.getRemark());
        ArrayList virtualNameList = Lists.newArrayList();
        for (VirtualWarehouseReqDto virtualWarehouseReqDto : virtualWarehouseList) {
            virtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEoMap.get(virtualWarehouseReqDto.getWarehouseCode());
            AssertUtils.notNull((Object)virtualWarehouseEo, (String)"\u865a\u4ed3\u5df2\u6709\u5206\u7ec4, \u865a\u4ed3\u7f16\u7801: %s", (Object[])new Object[]{virtualWarehouseReqDto.getWarehouseCode()});
            if (!Objects.equals(MainWarehouseEnum.IS_MAIN_NO.getCode(), virtualWarehouseReqDto.getWarehouseType())) continue;
            virtualNameList.add(virtualWarehouseEo.getWarehouseName());
        }
        virtualGroupEo.setSubWarehouseName(StringUtils.join((Iterable)virtualNameList, (String)","));
        this.virtualGroupDomain.insert((BaseEo)virtualGroupEo);
        for (VirtualWarehouseReqDto virtualWarehouseReqDto : virtualWarehouseList) {
            virtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEoMap.get(virtualWarehouseReqDto.getWarehouseCode());
            VirtualWarehouseEo updateVirtualWarehouseEo = new VirtualWarehouseEo();
            updateVirtualWarehouseEo.setId(virtualWarehouseEo.getId());
            updateVirtualWarehouseEo.setWarehouseType(virtualWarehouseReqDto.getWarehouseType());
            updateVirtualWarehouseEo.setLineType(virtualWarehouseReqDto.getLineType());
            updateVirtualWarehouseEo.setGroupId(virtualGroupEo.getId());
            this.virtualWarehouseDomain.updateSelective((BaseEo)updateVirtualWarehouseEo);
        }
        this.cacheService.hdel("sh_inventory_able_group_virtual_warehouse_code", virtualWarehouseEoMap.keySet().toArray(new String[0]));
    }

    private void editVirtualGroup(VirtualGroupReqDto reqDto) {
        VirtualGroupEo virtualGroupEo = (VirtualGroupEo)this.virtualGroupDomain.selectByPrimaryKey(reqDto.getId());
        AssertUtils.notNull((Object)virtualGroupEo, (String)"\u865a\u4ed3\u5206\u7ec4\u67e5\u8be2\u4e0d\u5b58\u5728");
        VirtualGroupEo updateVirtualGroupEo = new VirtualGroupEo();
        List virtualWarehouseList = reqDto.getVirtualWarehouseList();
        if (null == virtualWarehouseList) {
            virtualWarehouseList = Lists.newArrayList();
        }
        List warehouseCodes = virtualWarehouseList.stream().map(VirtualWarehouseReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"group_id", (Object)virtualGroupEo.getId())).eq((Object)"dr", (Object)YesNoHelper.NO));
        ArrayList deleteEos = Lists.newArrayList();
        ArrayList editEos = Lists.newArrayList();
        for (VirtualWarehouseEo virtualWarehouseEo : virtualWarehouseEos) {
            if (warehouseCodes.contains(virtualWarehouseEo.getWarehouseCode())) {
                editEos.add(virtualWarehouseEo);
                continue;
            }
            deleteEos.add(virtualWarehouseEo);
        }
        Map editVirtualWarehouseMap = editEos.stream().collect(Collectors.toMap(VirtualWarehouseEo::getWarehouseCode, Function.identity()));
        Map<Integer, List<VirtualWarehouseReqDto>> virtualWarehouseGroupMap = virtualWarehouseList.stream().collect(Collectors.groupingBy(VirtualWarehouseReqDto::getWarehouseType));
        List<VirtualWarehouseReqDto> mainList = virtualWarehouseGroupMap.get(MainWarehouseEnum.IS_MAIN_YES.getCode());
        if (CollectionUtil.isEmpty(mainList) || mainList.size() > 1) {
            throw new BizException("\u8be5\u5206\u7ec4\u6ca1\u6709\u8bbe\u7f6e\u4e3b\u865a\u4ed3 \u6216\u8005 \u4e3b\u865a\u4ed3\u4e0d\u552f\u4e00");
        }
        String mainWarehouseCode = mainList.get(0).getWarehouseCode();
        List mainVirtualWarehouseList = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)mainWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtil.isEmpty((Collection)mainVirtualWarehouseList) || mainVirtualWarehouseList.size() > 1) {
            throw new BizException("\u8be5\u5206\u7ec4\u6ca1\u6709\u8bbe\u7f6e\u4e3b\u865a\u4ed3 \u6216\u8005 \u4e3b\u865a\u4ed3\u4e0d\u552f\u4e00");
        }
        VirtualWarehouseEo mainVirtualWarehouse = (VirtualWarehouseEo)mainVirtualWarehouseList.get(0);
        List noGroupVirtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().isNull((Object)"group_id")).eq((Object)"dr", (Object)YesNoHelper.NO));
        Map noGroupVirtualWarehouseEoMap = noGroupVirtualWarehouseEos.stream().collect(Collectors.toMap(VirtualWarehouseEo::getWarehouseCode, Function.identity()));
        ArrayList virtualNameList = Lists.newArrayList();
        for (VirtualWarehouseReqDto virtualWarehouseReqDto : virtualWarehouseList) {
            VirtualWarehouseEo editVirtualWarehouseEo = (VirtualWarehouseEo)editVirtualWarehouseMap.get(virtualWarehouseReqDto.getWarehouseCode());
            if (null != editVirtualWarehouseEo) {
                if (Objects.equals(MainWarehouseEnum.IS_MAIN_NO.getCode(), virtualWarehouseReqDto.getWarehouseType())) {
                    virtualNameList.add(editVirtualWarehouseEo.getWarehouseName());
                }
                VirtualWarehouseEo updateVirtualWarehouseEo = new VirtualWarehouseEo();
                updateVirtualWarehouseEo.setId(editVirtualWarehouseEo.getId());
                updateVirtualWarehouseEo.setWarehouseType(virtualWarehouseReqDto.getWarehouseType());
                this.virtualWarehouseDomain.updateSelective((BaseEo)updateVirtualWarehouseEo);
                continue;
            }
            VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)noGroupVirtualWarehouseEoMap.get(virtualWarehouseReqDto.getWarehouseCode());
            AssertUtils.notNull((Object)virtualWarehouseEo, (String)"\u865a\u4ed3\u5df2\u6709\u5206\u7ec4, \u865a\u4ed3\u7f16\u7801: %s", (Object[])new Object[]{virtualWarehouseReqDto.getWarehouseCode()});
            if (Objects.equals(MainWarehouseEnum.IS_MAIN_NO.getCode(), virtualWarehouseReqDto.getWarehouseType())) {
                virtualNameList.add(virtualWarehouseEo.getWarehouseName());
            }
            VirtualWarehouseEo updateVirtualWarehouseEo = new VirtualWarehouseEo();
            updateVirtualWarehouseEo.setId(virtualWarehouseEo.getId());
            updateVirtualWarehouseEo.setWarehouseType(virtualWarehouseReqDto.getWarehouseType());
            updateVirtualWarehouseEo.setLineType(virtualWarehouseReqDto.getLineType());
            updateVirtualWarehouseEo.setGroupId(virtualGroupEo.getId());
            this.virtualWarehouseDomain.updateSelective((BaseEo)updateVirtualWarehouseEo);
        }
        for (VirtualWarehouseEo virtualWarehouseEo : deleteEos) {
            virtualWarehouseEo.setGroupId(null);
            virtualWarehouseEo.setWarehouseType(VirtualWarehouseTypeEnum.OVERALL.getCode());
            this.virtualWarehouseDomain.update((BaseEo)virtualWarehouseEo);
        }
        updateVirtualGroupEo.setId(virtualGroupEo.getId());
        updateVirtualGroupEo.setName(reqDto.getName());
        updateVirtualGroupEo.setWarehouseNum(Integer.valueOf(virtualWarehouseList.size()));
        updateVirtualGroupEo.setStatus(reqDto.getStatus());
        updateVirtualGroupEo.setExtension(reqDto.getRemark());
        updateVirtualGroupEo.setOverallWarehouseName(mainVirtualWarehouse.getWarehouseName());
        updateVirtualGroupEo.setSubWarehouseName(StringUtils.join((Iterable)virtualNameList, (String)","));
        this.virtualGroupDomain.updateSelective((BaseEo)updateVirtualGroupEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeVirtualGroup(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.virtualGroupDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public VirtualGroupDetailDto queryById(Long id) {
        VirtualGroupEo virtualGroupEo = (VirtualGroupEo)this.virtualGroupDomain.selectByPrimaryKey(id);
        VirtualGroupDetailDto virtualGroupDetailDto = new VirtualGroupDetailDto();
        DtoHelper.eo2Dto((BaseEo)virtualGroupEo, (BaseVo)virtualGroupDetailDto);
        List detailEoList = ((ExtQueryChainWrapper)this.virtualWarehouseDomain.filter().eq((Object)"group_id", (Object)id)).list();
        if (CollectionUtil.isNotEmpty((Collection)detailEoList)) {
            virtualGroupDetailDto.setWarehouseNum(Integer.valueOf(detailEoList.size()));
            ArrayList detailRespDtoList = Lists.newArrayList();
            for (VirtualWarehouseEo virtualWarehouseEo : detailEoList) {
                VirtualGroupDetailRespDto detailRespDto = new VirtualGroupDetailRespDto();
                BeanUtils.copyProperties((Object)virtualWarehouseEo, (Object)detailRespDto);
                detailRespDto.setWarehouseType(String.valueOf(virtualWarehouseEo.getWarehouseType()));
                detailRespDtoList.add(detailRespDto);
            }
            virtualGroupDetailDto.setDetailRespDtoList((List)detailRespDtoList);
        }
        return virtualGroupDetailDto;
    }

    @Override
    public PageInfo<VirtualGroupRespDto> queryByPage(VirtualGroupPageReqDto reqDto) {
        ExtQueryChainWrapper extQueryChainWrapper = new ExtQueryChainWrapper((BaseMapper)this.virtualGroupDomain.getMapper(), true);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getName())) {
            extQueryChainWrapper = (ExtQueryChainWrapper)extQueryChainWrapper.like((Object)"name", (Object)reqDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSubWarehouseName())) {
            extQueryChainWrapper = (ExtQueryChainWrapper)extQueryChainWrapper.like((Object)"sub_warehouse_name", (Object)reqDto.getSubWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOverallWarehouseName())) {
            extQueryChainWrapper = (ExtQueryChainWrapper)extQueryChainWrapper.like((Object)"overall_warehouse_name", (Object)reqDto.getOverallWarehouseName());
        }
        extQueryChainWrapper = (ExtQueryChainWrapper)extQueryChainWrapper.orderByDesc((Object)"create_time");
        PageInfo eoPageInfo = extQueryChainWrapper.page(reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, VirtualGroupRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

