/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="PUBLISH_TOPIC", tag="INVENTORY_ORDER_PREEMPT_LOGIC_TAG")
public class PreemptVirtualByOrderProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(PreemptVirtualByOrderProcess.class);
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    ICommonsMqService commonsMqService;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        log.info("INVENTORY_ORDER_PREEMPT_LOGIC_TAG:\u6d88\u606f={}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        try {
            String jsonStr = (String)messageData;
            PreemptDto param = (PreemptDto)JSONObject.parseObject((String)jsonStr, PreemptDto.class);
            param.setSourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode());
            this.calcInventoryService.preemptVirtual(param);
            if (StringUtils.isNotBlank((CharSequence)param.getExternalOrderNo())) {
                try {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)param.getExternalOrderNo());
                    this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PREEMPT_VIRTUAL_BY_LOGIC_SUCCESS", (Object)messageVo);
                }
                catch (Exception e) {
                    log.error("\u9884\u5360\u903b\u8f91\u4ed3\u53cd\u5411\u9884\u5360\u4f9b\u8d27\u4ed3\u6210\u529f\uff0c\u5e7f\u64ad\u6d88\u606f\u5f02\u5e38: {}", (Throwable)e);
                }
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }
}

