/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelVirtualWarehouseBatchAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelVirtualWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.RelVirtualWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IRelVirtualWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IVirtualWarehouseService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.enums.ShareItemTypeEnum;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.RelVirtualWarehouseEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizRelVirtualWarehouseService")
public class RelVirtualWarehouseServiceImpl
implements IRelVirtualWarehouseService {
    private static final Logger log = LoggerFactory.getLogger(RelVirtualWarehouseServiceImpl.class);
    @Autowired
    IRelVirtualWarehouseDomain relVirtualWarehouseDomain;
    @Autowired
    IVirtualWarehouseService virtualWarehouseService;
    @Autowired
    IVirtualWarehouseDomain virtualWarehouseDomain;
    @Autowired
    IChannelWarehouseDomain channelWarehouseDomain;
    @Autowired
    IChannelWarehouseService channelWarehouseService;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    ICalcInventoryService calcInventoryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addRelVirtualWarehouse(RelVirtualWarehouseReqDto addReqDto) {
        AssertUtils.isTrue((addReqDto.getChannelWarehouseId() != null && addReqDto.getVirtualWarehouseId() != null ? 1 : 0) != 0, (String)"\u5173\u952e\u53c2\u6570\u4e3a\u7a7a");
        RelVirtualWarehouseEo eo = (RelVirtualWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relVirtualWarehouseDomain.filter().eq((Object)"channel_warehouse_id", (Object)addReqDto.getChannelWarehouseId())).eq((Object)"virtual_warehouse_id", (Object)addReqDto.getVirtualWarehouseId())).one();
        if (eo != null) {
            return eo.getId();
        }
        RelVirtualWarehouseEo relVirtualWarehouseEo = new RelVirtualWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)relVirtualWarehouseEo);
        relVirtualWarehouseEo.setChannelWarehouseId(addReqDto.getWarehouseId());
        this.relVirtualWarehouseDomain.insert((BaseEo)relVirtualWarehouseEo);
        return relVirtualWarehouseEo.getId();
    }

    @Override
    public void modifyRelVirtualWarehouse(RelVirtualWarehouseReqDto modifyReqDto) {
        AssertUtils.isTrue((modifyReqDto.getChannelWarehouseId() != null && modifyReqDto.getVirtualWarehouseId() != null ? 1 : 0) != 0, (String)"\u5173\u952e\u53c2\u6570\u4e3a\u7a7a");
        AssertUtils.isTrue((modifyReqDto.getId() != null ? 1 : 0) != 0, (String)"\u5173\u952e\u53c2\u6570\u4e3a\u7a7a");
        RelVirtualWarehouseEo relVirtualWarehouseEo = new RelVirtualWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)relVirtualWarehouseEo);
        this.relVirtualWarehouseDomain.updateSelective((BaseEo)relVirtualWarehouseEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelVirtualWarehouse(String ids, String channelWarehouseId) {
        String[] removeIds = ids.split(",");
        ChannelWarehouseRespDto channelWarehouseEo = this.channelWarehouseService.selectByPrimaryKey(Long.valueOf(channelWarehouseId));
        AssertUtils.notNull((Object)channelWarehouseEo, (String)"\u83b7\u53d6\u4e0d\u5230\u6e20\u9053\u4ed3\u4fe1\u606f");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : removeIds) {
            idList.add(Long.valueOf(id));
        }
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.selectByIds(idList);
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            return;
        }
        List virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).distinct().collect(Collectors.toList());
        List preemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).in(InventoryPreemptionEo::getWarehouseId, virtualWarehouseIds)).eq(InventoryPreemptionEo::getWarehouseClassify, (Object)WarehouseClassifyEnum.VIRTUAL.getCode())).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)preemptionEos)) {
            throw new BizException("\u79fb\u9664\u4f9b\u8d27\u4ed3\u8fd8\u5b58\u5728\u9884\u5360\u8bb0\u5f55");
        }
        this.relVirtualWarehouseDomain.getMapper().deleteBatchIds(idList);
        this.calcInventoryService.reloadChannel((List)Lists.newArrayList((Object[])new String[]{channelWarehouseEo.getWarehouseCode()}), (List)Lists.newArrayList());
    }

    @Override
    public RelVirtualWarehouseRespDto queryById(Long id) {
        RelVirtualWarehouseEo relVirtualWarehouseEo = (RelVirtualWarehouseEo)this.relVirtualWarehouseDomain.selectByPrimaryKey(id);
        RelVirtualWarehouseRespDto relVirtualWarehouseRespDto = new RelVirtualWarehouseRespDto();
        DtoHelper.eo2Dto((BaseEo)relVirtualWarehouseEo, (BaseVo)relVirtualWarehouseRespDto);
        return relVirtualWarehouseRespDto;
    }

    @Override
    public PageInfo<RelVirtualWarehouseRespDto> queryByPage(Long channelWarehouseId, Integer pageNum, Integer pageSize) {
        RelVirtualWarehouseEo relVirtualWarehouseEo = new RelVirtualWarehouseEo();
        relVirtualWarehouseEo.setChannelWarehouseId(channelWarehouseId);
        PageInfo eoPageInfo = this.relVirtualWarehouseDomain.selectPage((BaseEo)relVirtualWarehouseEo, pageNum, pageSize);
        List virtualWarehouseIds = eoPageInfo.getList().stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).collect(Collectors.toList());
        VirtualWarehouseListReqDto virtualWarehouseListReqDto = new VirtualWarehouseListReqDto();
        virtualWarehouseListReqDto.setVirtualWarehouseIds(virtualWarehouseIds);
        ArrayList virtualWarehouseRespDtos = this.virtualWarehouseService.queryByList(virtualWarehouseListReqDto);
        if (null == virtualWarehouseRespDtos) {
            virtualWarehouseRespDtos = Lists.newArrayList();
        }
        Map<Long, VirtualWarehouseRespDto> virtualWarehouseMap = virtualWarehouseRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, virtualWarehouseRespDto -> virtualWarehouseRespDto));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        eoPageInfo.getList().forEach(eo -> {
            RelVirtualWarehouseRespDto respDto = new RelVirtualWarehouseRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
            VirtualWarehouseRespDto virtualWarehouseRespDto = (VirtualWarehouseRespDto)virtualWarehouseMap.get(eo.getVirtualWarehouseId());
            if (null != virtualWarehouseRespDto) {
                respDto.setVirtualWarehouseCode(virtualWarehouseRespDto.getWarehouseCode());
                respDto.setVirtualWarehouseName(virtualWarehouseRespDto.getWarehouseName());
                respDto.setVirtualWarehouseStatus(virtualWarehouseRespDto.getWarehouseStatus());
                respDto.setVirtualWarehouseType(virtualWarehouseRespDto.getWarehouseType());
            }
            dtoList.add(respDto);
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRelVirtualWarehouseBatch(RelVirtualWarehouseBatchAddReqDto addReqDto) {
        Long channelWarehouseId = addReqDto.getChannelWarehouseId();
        AssertUtils.notNull((Object)channelWarehouseId, (String)"\u6e20\u9053\u4ed3ID\u4e0d\u5b58\u5728");
        ChannelWarehouseRespDto channelWarehouseRespDto = this.channelWarehouseService.selectByPrimaryKey(addReqDto.getChannelWarehouseId());
        AssertUtils.notNull((Object)channelWarehouseRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u6e20\u9053\u4ed3\u4fe1\u606f");
        List relVirtualWarehouseReqDtoList = addReqDto.getAddList();
        AssertUtils.notEmpty((Collection)relVirtualWarehouseReqDtoList, (String)"\u5173\u8054\u865a\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        List addVirtualWarehouseIds = relVirtualWarehouseReqDtoList.stream().map(RelVirtualWarehouseReqDto::getVirtualWarehouseId).filter(Objects::nonNull).collect(Collectors.toList());
        AssertUtils.notEmpty(addVirtualWarehouseIds, (String)"\u6dfb\u52a0\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        List virtualWarehouseEos = this.virtualWarehouseDomain.selectByIds(addVirtualWarehouseIds);
        AssertUtils.notEmpty((Collection)virtualWarehouseEos, (String)"\u6dfb\u52a0\u4f9b\u8d27\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        Map virtualWarehouseEoMap = virtualWarehouseEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List relVirtualWarehouseEoList = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).eq(RelVirtualWarehouseEo::getChannelWarehouseId, (Object)channelWarehouseId)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (null == relVirtualWarehouseEoList) {
            relVirtualWarehouseEoList = Lists.newArrayList();
        }
        int count = relVirtualWarehouseEoList.size();
        ArrayList relVirtualWarehouseEos = Lists.newArrayList();
        for (RelVirtualWarehouseReqDto relVirtualWarehouseReqDto : relVirtualWarehouseReqDtoList) {
            RelVirtualWarehouseEo relVirtualWarehouseEo = new RelVirtualWarehouseEo();
            relVirtualWarehouseEo.setChannelWarehouseId(channelWarehouseId);
            Long virtualWarehouseId = relVirtualWarehouseReqDto.getVirtualWarehouseId();
            AssertUtils.notNull((Object)virtualWarehouseId, (String)"\u660e\u7ec6\u5305\u542b\u865a\u4ed3ID\u4e3a\u7a7a");
            RelVirtualWarehouseEo searchVirtualWarehouse = relVirtualWarehouseEoList.stream().filter(o -> Objects.equals(o.getVirtualWarehouseId(), virtualWarehouseId)).findFirst().orElse(null);
            if (null != searchVirtualWarehouse) continue;
            VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEoMap.get(virtualWarehouseId);
            relVirtualWarehouseEo.setVirtualWarehouseId(virtualWarehouseEo.getId());
            relVirtualWarehouseEo.setVirtualWarehouseCode(virtualWarehouseEo.getWarehouseCode());
            relVirtualWarehouseEo.setChannelWarehouseCode(channelWarehouseRespDto.getWarehouseCode());
            relVirtualWarehouseEo.setRelItemType(ShareItemTypeEnum.ALL_ITEM.getCode());
            relVirtualWarehouseEo.setPriority(relVirtualWarehouseReqDto.getPriority());
            if (null == relVirtualWarehouseEo.getPriority()) {
                relVirtualWarehouseEo.setPriority(Integer.valueOf(count++));
            }
            relVirtualWarehouseEo.setShareRatio(relVirtualWarehouseReqDto.getShareRatio());
            if (null == relVirtualWarehouseEo.getShareRatio()) {
                relVirtualWarehouseEo.setShareRatio(BigDecimalUtils.ONE_HUNDRED);
            }
            relVirtualWarehouseEos.add(relVirtualWarehouseEo);
        }
        AssertUtils.notEmpty((Collection)relVirtualWarehouseEos, (String)"\u6dfb\u52a0\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u8be5\u4f9b\u8d27\u4ed3\u5173\u7cfb\u5df2\u5b58\u5728");
        List virtualWarehouseCodes = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseCode).distinct().collect(Collectors.toList());
        this.relVirtualWarehouseDomain.insertBatch((List)relVirtualWarehouseEos);
        this.calcInventoryService.refreshRelChannelAndVirtual((List)Lists.newArrayList((Object[])new String[]{channelWarehouseRespDto.getWarehouseCode()}), virtualWarehouseCodes);
        this.calcInventoryService.refreshChannelInventory((List)Lists.newArrayList((Object[])new String[]{channelWarehouseRespDto.getWarehouseCode()}), (List)Lists.newArrayList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateChannelWarehouseShareRatio(RelVirtualWarehouseReqDto reqDto) {
        String virtualWarehouseCode = reqDto.getVirtualWarehouseCode();
        AssertUtils.notBlank((String)virtualWarehouseCode, (String)"\u865a\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String channelWarehouseCode = reqDto.getChannelWarehouseCode();
        AssertUtils.notBlank((String)channelWarehouseCode, (String)"\u6e20\u9053\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal shareRatio = reqDto.getShareRatio();
        if (BigDecimalUtils.leZero((BigDecimal)shareRatio).booleanValue()) {
            throw new BizException("\u5171\u4eab\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0%");
        }
        if (BigDecimalUtils.gt((BigDecimal)shareRatio, (BigDecimal)BigDecimalUtils.ONE_HUNDRED).booleanValue()) {
            throw new BizException("\u5171\u4eab\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e100%");
        }
        Integer priority = reqDto.getPriority();
        AssertUtils.notNull((Object)priority, (String)"\u4f18\u5148\u7ea7\u4e3a\u7a7a");
        List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)virtualWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)virtualWarehouseEos) || virtualWarehouseEos.size() > 1) {
            throw new BizException("\u865a\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u552f\u4e00");
        }
        VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEos.get(0);
        List channelWarehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)channelWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)channelWarehouseEos) || channelWarehouseEos.size() > 1) {
            throw new BizException("\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u552f\u4e00");
        }
        ChannelWarehouseEo channelWarehouseEo = (ChannelWarehouseEo)channelWarehouseEos.get(0);
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).eq(RelVirtualWarehouseEo::getChannelWarehouseId, (Object)channelWarehouseEo.getId())).eq(RelVirtualWarehouseEo::getVirtualWarehouseId, (Object)virtualWarehouseEo.getId())).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos) || relVirtualWarehouseEos.size() > 1) {
            throw new BizException("\u6e20\u9053\u4ed3\u5173\u8054\u865a\u4ed3\u5173\u7cfb\u4e0d\u5b58\u5728 \u6216\u8005 \u4e0d\u552f\u4e00");
        }
        RelVirtualWarehouseEo relVirtualWarehouseEo = (RelVirtualWarehouseEo)relVirtualWarehouseEos.get(0);
        RelVirtualWarehouseEo updateRelVirtualWarehouseEo = new RelVirtualWarehouseEo();
        updateRelVirtualWarehouseEo.setId(relVirtualWarehouseEo.getId());
        updateRelVirtualWarehouseEo.setShareRatio(reqDto.getShareRatio());
        updateRelVirtualWarehouseEo.setPriority(reqDto.getPriority());
        this.relVirtualWarehouseDomain.updateSelective((BaseEo)updateRelVirtualWarehouseEo);
        this.calcInventoryService.reloadChannel((List)Lists.newArrayList((Object[])new String[]{channelWarehouseEo.getWarehouseCode()}), (List)Lists.newArrayList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeChannelWarehouse(RelVirtualWarehouseReqDto reqDto) {
        Long channelWarehouseId = reqDto.getChannelWarehouseId();
        AssertUtils.notNull((Object)channelWarehouseId, (String)"\u6e20\u9053\u4ed3ID\u4e0d\u5b58\u5728");
        ChannelWarehouseRespDto channelWarehouseRespDto = this.channelWarehouseService.selectByPrimaryKey(reqDto.getChannelWarehouseId());
        AssertUtils.notNull((Object)channelWarehouseRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u6e20\u9053\u4ed3\u4fe1\u606f");
        List virtualWarehouseIds = reqDto.getVirtualWarehouseIds();
        AssertUtils.notEmpty((Collection)virtualWarehouseIds, (String)"\u865a\u4ed3ID\u96c6\u5408\u4e3a\u7a7a");
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).eq(RelVirtualWarehouseEo::getChannelWarehouseId, (Object)channelWarehouseId)).in(RelVirtualWarehouseEo::getVirtualWarehouseId, (Collection)virtualWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)relVirtualWarehouseEos, (String)"\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u6e20\u9053\u4ed3\u5173\u8054\u4f9b\u8d27\u4ed3\u6d88\u606f");
        for (RelVirtualWarehouseEo relVirtualWarehouseEo : relVirtualWarehouseEos) {
            this.relVirtualWarehouseDomain.deleteById(relVirtualWarehouseEo.getId());
        }
        this.calcInventoryService.refreshChannelInventory((List)Lists.newArrayList((Object[])new String[]{channelWarehouseRespDto.getWarehouseCode()}), (List)Lists.newArrayList());
    }

    @Override
    public void enable(List<Long> channelWarehouseIds, List<Long> virtualWarehouseIds) {
        if (CollectionUtils.isEmpty(channelWarehouseIds) && CollectionUtils.isEmpty(virtualWarehouseIds)) {
            throw new BizException("\u6e20\u9053\u4ed3ID\uff0c\u4f9b\u8d27\u4ed3ID \u542f\u7528 \u5173\u7cfb\u65f6\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a");
        }
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(CollectionUtils.isNotEmpty(channelWarehouseIds), RelVirtualWarehouseEo::getChannelWarehouseId, channelWarehouseIds)).in(CollectionUtils.isNotEmpty(virtualWarehouseIds), RelVirtualWarehouseEo::getVirtualWarehouseId, virtualWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.DISABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            return;
        }
        List ids = relVirtualWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        this.relVirtualWarehouseDomain.updateStatus(ids, EnableDisableEnum.ENABLE.getCode());
    }

    @Override
    public void disable(List<Long> channelWarehouseIds, List<Long> virtualWarehouseIds) {
        if (CollectionUtils.isEmpty(channelWarehouseIds) && CollectionUtils.isEmpty(virtualWarehouseIds)) {
            throw new BizException("\u6e20\u9053\u4ed3ID\uff0c\u4f9b\u8d27\u4ed3ID \u7981\u7528 \u5173\u7cfb\u65f6\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a");
        }
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(CollectionUtils.isNotEmpty(channelWarehouseIds), RelVirtualWarehouseEo::getChannelWarehouseId, channelWarehouseIds)).in(CollectionUtils.isNotEmpty(virtualWarehouseIds), RelVirtualWarehouseEo::getVirtualWarehouseId, virtualWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            return;
        }
        List ids = relVirtualWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        this.relVirtualWarehouseDomain.updateStatus(ids, EnableDisableEnum.DISABLE.getCode());
    }
}

