/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.svr.rest;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryReleasePreemptOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.share.dto.calc.DisplacePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptAndOutDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.UpdatePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/csChannelInventoryExposed"})
public class ChannelInventoryExposedRest
implements IChannelInventoryExposedApi {
    @Resource(name="${yunxi.dg.base.project}_ChannelInventoryExposedApi")
    IChannelInventoryExposedApi channelInventoryExposedApi;
    @Autowired
    ILockService lockService;
    final String shareKey = "SHARE_KEY_INVENTORY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> preemptInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto) {
        String lockKey = inventoryOperateReqDto.getSourceNo();
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.preemptInventory(inventoryOperateReqDto);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> releaseInventoryByPreemption(@Validated @RequestBody CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        String lockKey = releasePreemptOperateReqDto.getSourceNo();
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.releaseInventoryByPreemption(releasePreemptOperateReqDto);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> releasePreempt(@Validated @RequestBody ReleasePreemptDto releasePreemptParam) {
        String lockKey = releasePreemptParam.getSourceNo();
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.releasePreempt(releasePreemptParam);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> batchInventoryByPreemption(List<CsInventoryOperateReqDto> inventoryOperateReqDtos) {
        String lockKey = inventoryOperateReqDtos.stream().map(CsInventoryOperateReqDto::getSourceNo).distinct().sorted().collect(Collectors.joining(","));
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.batchInventoryByPreemption(inventoryOperateReqDtos);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> updatePreempt(@Validated @RequestBody UpdatePreemptDto updatePreemptParam) {
        String lockKey = updatePreemptParam.getPreemptParamList().stream().map(OperationDto::getSourceNo).distinct().sorted().collect(Collectors.joining(","));
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.updatePreempt(updatePreemptParam);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> updateInventoryByPreemption(@Validated @RequestBody List<CsInventoryOperateReqDto> inventoryOperateReqDtos) {
        String lockKey = inventoryOperateReqDtos.stream().map(CsInventoryOperateReqDto::getSourceNo).distinct().sorted().collect(Collectors.joining(","));
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.updateInventoryByPreemption(inventoryOperateReqDtos);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> supplyByChannelWarehouseCode(@PathVariable(value="channelWarehouseCode") String channelWarehouseCode, @RequestBody List<String> cargoCodes) {
        String lockKey = channelWarehouseCode + "_" + cargoCodes.stream().distinct().sorted().collect(Collectors.joining(","));
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.supplyByChannelWarehouseCode(channelWarehouseCode, cargoCodes);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> releasePreemptAndOut(@Validated @RequestBody ReleasePreemptAndOutDto param) {
        String lockKey = param.getSourceNo();
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.releasePreemptAndOut(param);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> displacePreempt(@Validated @RequestBody DisplacePreemptDto param) {
        String lockKey = param.getDisplaceSourceNo();
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.displacePreempt(param);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> preempt(@Validated @RequestBody PreemptDto param) {
        String lockKey = param.getSourceNo();
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.preempt(param);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> preemptVirtual(@Validated @RequestBody PreemptDto param) {
        String lockKey = param.getSourceNo();
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.preemptVirtual(param);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Void> supplyByLogicLogs(@RequestBody List<CsInventoryLogRespDto> logs) {
        String lockKey = logs.stream().map(CsInventoryLogRespDto::getSourceNo).distinct().sorted().collect(Collectors.joining(","));
        Mutex lock = this.lockService.lock("SHARE_KEY_INVENTORY", lockKey, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.channelInventoryExposedApi.supplyByLogicLogs(logs);
            return restResponse;
        }
        finally {
            Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
    }
}

