/**
 * @(#) PlatformOrderType.java 1.0 2022/3/10/010
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 平台订单状态枚举
 *
 * @author zimu
 * @date 2022/3/10/010
 * @since 1.0.0
 */
public enum PlatformTransformOrderStatus {

    // 转单状态 -1初始化 0-正常 1-异常 2-作废,3-已合并,4-待物流初审,5-待仓库复审,6-已审核
    STATUS_INIT_1(-1, "初始化"),
    STATUS_0(0, "正常"),
    STATUS_1(1, "异常"),
    STATUS_2(2, "作废"),
    STATUS_3(3, "已合并"),
    //物流索赔单
    STATUS_4(4, "待物流初审"),
    STATUS_5(5, "待仓库复审"),
    STATUS_6(6, "已审核"),
    ;

    PlatformTransformOrderStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public final int code;
    public final String desc;
    public static final Map<Integer, PlatformTransformOrderStatus> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    public static final Map<Integer, String> CODE_DESC_MAP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));

    public static PlatformTransformOrderStatus forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
