package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderRemarkReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRemarkRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 平台订单备注表服务接口
*
* @author zimu
* @since 2022-03-08
*/
@Api(tags = {"平台订单备注表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-IPlatformOrderRemarkQueryApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/orderRemark",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPlatformOrderRemarkQueryApi {

    /**
    * 根据id查询平台订单备注表
    *
    * @param id 平台订单备注表id
    * @return   平台订单备注表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询平台订单备注表", notes = "根据id查询平台订单备注表")
    RestResponse<PlatformOrderRemarkRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 平台订单备注表分页数据
    *
    * @param filter   平台订单备注表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 平台订单备注表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "平台订单备注表分页数据", notes = "根据filter查询条件查询平台订单备注表数据，filter=PlatformOrderRemarkReqDto")
    RestResponse<PageInfo<PlatformOrderRemarkRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
