/**
 * @(#) PcpOrderReqDto.java 1.0 2022/3/8/008
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.dto.request;

import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * pcp销售订单请求对象
 *
 * @author zimu
 * @date 2022/3/8/008
 * @since 1.0.0
 */
@Data
@ApiModel(value = "PcpOrderReqDto", description = "pcp销售订单请求对象")
public class PcpOrderReqDto extends PlatformOrderReqDto {

    /**
     *  订单扩展内容
     */
    @ApiModelProperty(name = "platformOrderPcpExtendReqDto", value = "订单扩展内容")
    private PlatformOrderPcpExtendReqDto platformOrderPcpExtendReqDto;

    /**
     *  订单商品集合
     */
    @ApiModelProperty(name = "itemList", value = "订单商品集合")
    private List<PlatformOrderItemReqDto> itemReqDtoList;

    /**
     *  订单商品集合
     */
    @ApiModelProperty(name = "platformOrderAddrReqDto", value = "订单收货地址")
    private PlatformOrderAddrReqDto platformOrderAddrReqDto;


    @ApiModelProperty(name = "outCreatePerson", value = "外部创建人")
    private String outCreatePerson;

    /**
     * @see PlatformOrderStatusEnum
     */
    @ApiModelProperty(name = "platformOrderStatus", value = "平台订单状态： submit:提交订单;audit_pass:审核成功;audit_not_pass:审核不通过;cancel:取消订单;")
    private String platformOrderStatus;

//    @ApiModelProperty(name = "sourceOrderNo", value = "来源单号,经销订单传平台单号和积分单号，英文逗号隔开")
//    private String sourceOrderNo;

    @ApiModelProperty(name = "thirdOrgID", value = "org_id(营销云组织编码)")
    private String thirdOrgID;

    /**
     *  订单扩展内容
     */
    @ApiModelProperty(name = "spExtReqDto", value = "索赔订单扩展内容")
    private PlatformOrderSpExtReqDto spExtReqDto;

}

