package com.dtyunxi.yundt.cube.center.transform.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

/**
* 平台订单表Eo对象
*
* @author zimu
* @since 2022-05-17
*/
@ApiModel(value = "PlatformOrderReqDto", description = "平台订单表Eo对象")
public class PlatformOrderReqDto extends BaseRequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
    *  平台订单号
    */
    @ApiModelProperty(name = "platformOrderNo", value = "平台订单号")
    private String platformOrderNo;
    /**
    *  平台父订单号
    */
    @ApiModelProperty(name = "platformParentOrderNo", value = "平台父订单号")
    private String platformParentOrderNo;
    /**
    *  平台下单时间
    */
    @ApiModelProperty(name = "platformCreateTime", value = "平台下单时间")
    private Date platformCreateTime;
    /**
    *  订单类型，common_order: '普通订单',agency_order: '经销订单',shoppe_order: '专柜订单', integral_order: '积分订单',replenishment_order: '货补订单',activity_order: '活动订单',customer_refunding_order: '消费者退换货',compensation_order: '索赔订单',quality_refunding_order: '质量退换货',replenish_order: '少货补发'
    */
    @ApiModelProperty(name = "orderType", value = "订单类型，common_order: '普通订单',agency_order: '经销订单',shoppe_order: '专柜订单', integral_order: '积分订单',replenishment_order: '货补订单',activity_order: '活动订单',customer_refunding_order: '消费者退换货',compensation_order: '索赔订单',quality_refunding_order: '质量退换货',replenish_order: '少货补发'")
    private String orderType;
    /**
    *  内部订单号
    */
    @ApiModelProperty(name = "saleOrderNo", value = "内部订单号")
    private String saleOrderNo;

    /**
     *  内部订单号
     */
    @ApiModelProperty(name = "newSaleOrderNo", value = "新的内部销售单号")
    private String newSaleOrderNo;
    /**
    *  转单状态 0-正常 1-异常 2-作废
    */
    @ApiModelProperty(name = "transferOrderStatus", value = "转单状态 0-正常 1-异常 2-作废")
    private Integer transferOrderStatus;
    /**
    *  转单时间
    */
    @ApiModelProperty(name = "transferOrderTime", value = "转单时间")
    private Date transferOrderTime;
    /**
    *  异常原因
    */
    @ApiModelProperty(name = "exceptionReason", value = "异常原因")
    private String exceptionReason;
    /**
    *  店铺id
    */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
    *  店铺编号
    */
    @ApiModelProperty(name = "shopCode", value = "店铺编号")
    private String shopCode;
    /**
    *  店铺名称
    */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
    *  店铺渠道ID
    */
    @ApiModelProperty(name = "shopChannelId", value = "店铺渠道ID")
    private Long shopChannelId;
    /**
    *  店铺渠道code
    */
    @ApiModelProperty(name = "shopChannelCode", value = "店铺渠道code")
    private String shopChannelCode;
    /**
    *  店铺渠道
    */
    @ApiModelProperty(name = "shopChannel", value = "店铺渠道")
    private String shopChannel;
    /**
    *  订单渠道id
    */
    @ApiModelProperty(name = "orderChannelId", value = "订单渠道id")
    private Long orderChannelId;
    /**
    *  订单渠道code
    */
    @ApiModelProperty(name = "orderChannelCode", value = "订单渠道code")
    private String orderChannelCode;
    /**
    *  订单渠道名称
    */
    @ApiModelProperty(name = "orderChannelName", value = "订单渠道名称")
    private String orderChannelName;
    /**
    *   订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
    */
    @ApiModelProperty(name = "orderSource", value = " 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private Integer orderSource;
    /**
    *  销售订单创建时间
    */
    @ApiModelProperty(name = "saleCreateTime", value = "销售订单创建时间")
    private Date saleCreateTime;
    /**
    *  订单来源：0：线下 1: 线上
    */
    @ApiModelProperty(name = "isOnline", value = "订单来源：0：线下 1: 线上")
    private Integer isOnline;
    /**
    *  是否允许拆单标识：0-否 1-是
    */
    @ApiModelProperty(name = "canSplitFlag", value = "是否允许拆单标识 0-否 1-是")
    private Integer canSplitFlag;
    /**
    *  经销渠道
    */
    @ApiModelProperty(name = "saleChannel", value = "经销渠道")
    private String saleChannel;
    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
    *  客户名称
    */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
    *  客户id
    */
    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;
    /**
    *  作废人
    */
    @ApiModelProperty(name = "obsoletePerson", value = "作废人")
    private String obsoletePerson;
    /**
    *  作废时间
    */
    @ApiModelProperty(name = "obsoleteTime", value = "作废时间")
    private Date obsoleteTime;
    /**
    *  作废原因
    */
    @ApiModelProperty(name = "obsoleteReason", value = "作废原因")
    private String obsoleteReason;
    /**
    *  商品总数量
    */
    @ApiModelProperty(name = "goodsTotalNum", value = "商品总数量")
    private BigDecimal goodsTotalNum;
    /**
    *  商品sku总数量
    */
    @ApiModelProperty(name = "goodsSkuTotalNum", value = "商品sku总数量")
    private BigDecimal goodsSkuTotalNum;
    /**
    *  商品总金额
    */
    @ApiModelProperty(name = "goodsTotalAmount", value = "商品总金额")
    private BigDecimal goodsTotalAmount;
    /**
    *  应付金额
    */
    @ApiModelProperty(name = "orderTotalAmount", value = "应付金额")
    private BigDecimal orderTotalAmount;
    /**
    *  实付金额
    */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;
    /**
    *  支付时间
    */
    @ApiModelProperty(name = "payTime", value = "支付时间")
    private Date payTime;
    /**
    *  支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付
    */
    @ApiModelProperty(name = "payWay", value = "支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付")
    private String payWay;
    /**
    *  支付状态（0-未支付、1-已支付）
    */
    @ApiModelProperty(name = "payStatus", value = "支付状态（0-未支付、1-已支付）")
    private Integer payStatus;
    /**
    *  渠道仓库id
    */
    @ApiModelProperty(name = "channelWarehouseId", value = "渠道仓库id")
    private Long channelWarehouseId;
    /**
    *  渠道仓库编码
    */
    @ApiModelProperty(name = "channelWarehouseCode", value = "渠道仓库编码")
    private String channelWarehouseCode;
    /**
    *  渠道仓库名称
    */
    @ApiModelProperty(name = "channelWarehouseName", value = "渠道仓库名称")
    private String channelWarehouseName;
    /**
    *  默认发货仓id
    */
    @ApiModelProperty(name = "defaultWarehouseId", value = "默认发货仓id")
    private Long defaultWarehouseId;
    /**
    *  默认发货仓编码
    */
    @ApiModelProperty(name = "defaultWarehouseCode", value = "默认发货仓编码")
    private String defaultWarehouseCode;
    /**
    *  默认发货仓编码名称
    */
    @ApiModelProperty(name = "defaultWarehouseName", value = "默认发货仓编码名称")
    private String defaultWarehouseName;
    /**
    *  订单备注 
    */
    @ApiModelProperty(name = "remark", value = "订单备注 ")
    private String remark;
    /**
    *  商家备注
    */
    @ApiModelProperty(name = "sellerRemark", value = "商家备注")
    private String sellerRemark;
    /**
    *  第三方客户租户id
    */
    @ApiModelProperty(name = "thirdPartyId", value = "第三方客户租户id")
    private String thirdPartyId;

    @ApiModelProperty(name = "platformOrderNoList", value = "平台订单号集合")
    private List<String> platformOrderNoList;

    @ApiModelProperty(name = "rdc", value = "来发货仓库标识, 珠海:RDC_ZH,天津:RDC_TJ")
    private String rdc;

    @ApiModelProperty(name = "ifEas", value = "是否财务后置单 0是1 否；默认0")
    private Integer ifEas;

    @ApiModelProperty(name = "orderBizType", value = "订单业务类型 0:普通订单,1:非药业-财务前置")
    private Integer orderBizType;


    @ApiModelProperty(name = "easOrgId", value = "EAS必须-组织编码")
    private String easOrgId;

    @ApiModelProperty(name = "deliveryDate", value = "交货日期")
    private String deliveryDate;
    @ApiModelProperty(name = "sendDate", value = "发货日期")
    private String sendDate;

    @ApiModelProperty(name = "oldOrderId", value = "合单前的旧订单id")
    private String oldOrderId;

    /**
     * 第三方来源订单号(csp经销订单传平台订单号和积分订单平台订单号)
     */
    @ApiModelProperty(name = "sourceOrderNo",value = "第三方来源订单号(csp经销订单传平台订单号和积分订单平台订单号)")
    private String sourceOrderNo;


    /**
     * 转单号
     */
    @ApiModelProperty(name = "transformOrderNo",value = "转单号")
    private String transformOrderNo;

    /**
     * 关联转单号
     */
    @ApiModelProperty(name = "reTransformOrderNo",value = "关联转单号")
    private String reTransformOrderNo;

    /**
     * 是否预占库存 0否，1是,默认1
     */
    @ApiModelProperty(name = "releaseState",value = "是否预占库存 0否，1是,默认1")
    private Integer releaseState;

    /**
     * 客户表easCode
     */
    @ApiModelProperty(name = "easCode",value = "客户表easCode")
    private String easCode;

    @ApiModelProperty(name = "extension",value = "扩展字段")
    private String extension;

    /**
     * csp传下来的rdc物理仓(与rdc字段无关)
     */
    @ApiModelProperty(name = "storagePlace",value = "csp传下来的rdc物理仓(与rdc字段无关)")
    private String storagePlace;


    /**
     * 指定供货仓id
     */
    @ApiModelProperty(name = "storagePlaceId",value = "指定供货仓id")
    private Long storagePlaceId;

    /**
     * 指定供货仓
     */
    @ApiModelProperty(name = "storagePlaceName",value = "指定供货仓名称")
    private String storagePlaceName;

    /**
     * 实际收货客户
     */
    @ApiModelProperty(name = "actualCustomerCode",value = "实际收货客户编码")
    private String actualCustomerCode;


    /**
     * 实际收货客户Id
     */
    @ApiModelProperty(name = "actualCustomerId",value = "实际收货客户Id")
    private Long actualCustomerId;

    /**
     * 实际收货客户名称
     */
    @ApiModelProperty(name = "actualCustomerName",value = "实际收货客户名称")
    private String actualCustomerName;

    /**
     * 区域编号
     */
    @ApiModelProperty(name = "regionCode", value = "区域编号")
    private String regionCode;
    /**
     * 区域名称
     */
    @ApiModelProperty(name = "regionName", value = "区域名称")
    private String regionName;

    @ApiModelProperty(name = "allotType", value = "麦优调拨类型：maiyou_cc_allot:cc跨组织调拨;maiyou_bc_allot:bc跨组织调拨")
    private String allotType;
    @ApiModelProperty(name = "allotOutWarehouseCode", value = "调出仓")
    private String allotOutWarehouseCode;
    @ApiModelProperty(name = "allotOutWarehouseName", value = "调出仓名称")
    private String allotOutWarehouseName;
    @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓")
    private String allotInWarehouseCode;
    @ApiModelProperty(name = "allotInWarehouseName", value = "调入仓名称")
    private String allotInWarehouseName;

    @ApiModelProperty(name = "costCenter", value = "成本中心")
    private String costCenter;
    @ApiModelProperty(name = "budgetCode", value = "预算项目编码")
    private String budgetCode;
    @ApiModelProperty(name = "billingCustomerName", value = "开票客户名称")
    private String billingCustomerName;
    @ApiModelProperty(name = "billingCustomerCode", value = "开票客户编码")
    private String billingCustomerCode;

    @ApiModelProperty(name = "easVerifyStatus", value = "easVerifyStatus")
    private Integer easVerifyStatus;

    @ApiModelProperty(name = "sapPlatformOrderNo", value = "SAP单号")
    private Integer sapPlatformOrderNo;

    public Integer getSapPlatformOrderNo() {
        return sapPlatformOrderNo;
    }

    public void setSapPlatformOrderNo(Integer sapPlatformOrderNo) {
        this.sapPlatformOrderNo = sapPlatformOrderNo;
    }

    public Integer getEasVerifyStatus() {
        return easVerifyStatus;
    }

    public void setEasVerifyStatus(Integer easVerifyStatus) {
        this.easVerifyStatus = easVerifyStatus;
    }

    public String getCostCenter() {
        return costCenter;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    public String getBudgetCode() {
        return budgetCode;
    }

    public void setBudgetCode(String budgetCode) {
        this.budgetCode = budgetCode;
    }

    public String getBillingCustomerName() {
        return billingCustomerName;
    }

    public void setBillingCustomerName(String billingCustomerName) {
        this.billingCustomerName = billingCustomerName;
    }

    public String getBillingCustomerCode() {
        return billingCustomerCode;
    }

    public void setBillingCustomerCode(String billingCustomerCode) {
        this.billingCustomerCode = billingCustomerCode;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationCode(String organizationCode){
    this.organizationCode = organizationCode;
    }
    public String getOrganizationCode(){
    return this.organizationCode;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setPlatformOrderNo(String platformOrderNo){
    this.platformOrderNo = platformOrderNo;
    }
    public String getPlatformOrderNo(){
    return this.platformOrderNo;
    }
    public void setPlatformParentOrderNo(String platformParentOrderNo){
    this.platformParentOrderNo = platformParentOrderNo;
    }
    public String getPlatformParentOrderNo(){
    return this.platformParentOrderNo;
    }
    public void setPlatformCreateTime(Date platformCreateTime){
    this.platformCreateTime = platformCreateTime;
    }
    public Date getPlatformCreateTime(){
    return this.platformCreateTime;
    }
    public void setOrderType(String orderType){
    this.orderType = orderType;
    }
    public String getOrderType(){
    return this.orderType;
    }
    public void setSaleOrderNo(String saleOrderNo){
    this.saleOrderNo = saleOrderNo;
    }
    public String getSaleOrderNo(){
    return this.saleOrderNo;
    }
    public void setTransferOrderStatus(Integer transferOrderStatus){
    this.transferOrderStatus = transferOrderStatus;
    }
    public Integer getTransferOrderStatus(){
    return this.transferOrderStatus;
    }
    public void setTransferOrderTime(Date transferOrderTime){
    this.transferOrderTime = transferOrderTime;
    }
    public Date getTransferOrderTime(){
    return this.transferOrderTime;
    }
    public void setExceptionReason(String exceptionReason){
    this.exceptionReason = exceptionReason;
    }
    public String getExceptionReason(){
    return this.exceptionReason;
    }
    public void setShopId(Long shopId){
    this.shopId = shopId;
    }
    public Long getShopId(){
    return this.shopId;
    }
    public void setShopCode(String shopCode){
    this.shopCode = shopCode;
    }
    public String getShopCode(){
    return this.shopCode;
    }
    public void setShopName(String shopName){
    this.shopName = shopName;
    }
    public String getShopName(){
    return this.shopName;
    }
    public void setShopChannelId(Long shopChannelId){
    this.shopChannelId = shopChannelId;
    }
    public Long getShopChannelId(){
    return this.shopChannelId;
    }
    public void setShopChannelCode(String shopChannelCode){
    this.shopChannelCode = shopChannelCode;
    }
    public String getShopChannelCode(){
    return this.shopChannelCode;
    }
    public void setShopChannel(String shopChannel){
    this.shopChannel = shopChannel;
    }
    public String getShopChannel(){
    return this.shopChannel;
    }
    public void setOrderChannelId(Long orderChannelId){
    this.orderChannelId = orderChannelId;
    }
    public Long getOrderChannelId(){
    return this.orderChannelId;
    }
    public void setOrderChannelCode(String orderChannelCode){
    this.orderChannelCode = orderChannelCode;
    }
    public String getOrderChannelCode(){
    return this.orderChannelCode;
    }
    public void setOrderChannelName(String orderChannelName){
    this.orderChannelName = orderChannelName;
    }
    public String getOrderChannelName(){
    return this.orderChannelName;
    }
    public void setOrderSource(Integer orderSource){
    this.orderSource = orderSource;
    }
    public Integer getOrderSource(){
    return this.orderSource;
    }
    public void setSaleCreateTime(Date saleCreateTime){
    this.saleCreateTime = saleCreateTime;
    }
    public Date getSaleCreateTime(){
    return this.saleCreateTime;
    }
    public void setIsOnline(Integer isOnline){
    this.isOnline = isOnline;
    }
    public Integer getIsOnline(){
    return this.isOnline;
    }
    public void setCanSplitFlag(Integer canSplitFlag){
    this.canSplitFlag = canSplitFlag;
    }
    public Integer getCanSplitFlag(){
    return this.canSplitFlag;
    }
    public void setSaleChannel(String saleChannel){
    this.saleChannel = saleChannel;
    }
    public String getSaleChannel(){
    return this.saleChannel;
    }
    public void setCustomerCode(String customerCode){
    this.customerCode = customerCode;
    }
    public String getCustomerCode(){
    return this.customerCode;
    }
    public void setCustomerName(String customerName){
    this.customerName = customerName;
    }
    public String getCustomerName(){
    return this.customerName;
    }
    public void setCustomerId(Long customerId){
    this.customerId = customerId;
    }
    public Long getCustomerId(){
    return this.customerId;
    }
    public void setObsoletePerson(String obsoletePerson){
    this.obsoletePerson = obsoletePerson;
    }
    public String getObsoletePerson(){
    return this.obsoletePerson;
    }
    public void setObsoleteTime(Date obsoleteTime){
    this.obsoleteTime = obsoleteTime;
    }
    public Date getObsoleteTime(){
    return this.obsoleteTime;
    }
    public void setObsoleteReason(String obsoleteReason){
    this.obsoleteReason = obsoleteReason;
    }
    public String getObsoleteReason(){
    return this.obsoleteReason;
    }
    public void setGoodsTotalNum(BigDecimal goodsTotalNum){
    this.goodsTotalNum = goodsTotalNum;
    }
    public BigDecimal getGoodsTotalNum(){
    return this.goodsTotalNum;
    }
    public void setGoodsSkuTotalNum(BigDecimal goodsSkuTotalNum){
    this.goodsSkuTotalNum = goodsSkuTotalNum;
    }
    public BigDecimal getGoodsSkuTotalNum(){
    return this.goodsSkuTotalNum;
    }
    public void setGoodsTotalAmount(BigDecimal goodsTotalAmount){
    this.goodsTotalAmount = goodsTotalAmount;
    }
    public BigDecimal getGoodsTotalAmount(){
    return this.goodsTotalAmount;
    }
    public void setOrderTotalAmount(BigDecimal orderTotalAmount){
    this.orderTotalAmount = orderTotalAmount;
    }
    public BigDecimal getOrderTotalAmount(){
    return this.orderTotalAmount;
    }
    public void setPayAmount(BigDecimal payAmount){
    this.payAmount = payAmount;
    }
    public BigDecimal getPayAmount(){
    return this.payAmount;
    }
    public void setPayTime(Date payTime){
    this.payTime = payTime;
    }
    public Date getPayTime(){
    return this.payTime;
    }
    public void setPayWay(String payWay){
    this.payWay = payWay;
    }
    public String getPayWay(){
    return this.payWay;
    }
    public void setPayStatus(Integer payStatus){
    this.payStatus = payStatus;
    }
    public Integer getPayStatus(){
    return this.payStatus;
    }
    public void setChannelWarehouseId(Long channelWarehouseId){
    this.channelWarehouseId = channelWarehouseId;
    }
    public Long getChannelWarehouseId(){
    return this.channelWarehouseId;
    }
    public void setChannelWarehouseCode(String channelWarehouseCode){
    this.channelWarehouseCode = channelWarehouseCode;
    }
    public String getChannelWarehouseCode(){
    return this.channelWarehouseCode;
    }
    public void setChannelWarehouseName(String channelWarehouseName){
    this.channelWarehouseName = channelWarehouseName;
    }
    public String getChannelWarehouseName(){
    return this.channelWarehouseName;
    }
    public void setDefaultWarehouseId(Long defaultWarehouseId){
    this.defaultWarehouseId = defaultWarehouseId;
    }
    public Long getDefaultWarehouseId(){
    return this.defaultWarehouseId;
    }
    public void setDefaultWarehouseCode(String defaultWarehouseCode){
    this.defaultWarehouseCode = defaultWarehouseCode;
    }
    public String getDefaultWarehouseCode(){
    return this.defaultWarehouseCode;
    }
    public void setDefaultWarehouseName(String defaultWarehouseName){
    this.defaultWarehouseName = defaultWarehouseName;
    }
    public String getDefaultWarehouseName(){
    return this.defaultWarehouseName;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setSellerRemark(String sellerRemark){
    this.sellerRemark = sellerRemark;
    }
    public String getSellerRemark(){
    return this.sellerRemark;
    }
    public void setThirdPartyId(String thirdPartyId){
    this.thirdPartyId = thirdPartyId;
    }
    public String getThirdPartyId(){
    return this.thirdPartyId;
    }

    public List<String> getPlatformOrderNoList() {
        return platformOrderNoList;
    }

    public void setPlatformOrderNoList(List<String> platformOrderNoList) {
        this.platformOrderNoList = platformOrderNoList;
    }

    public String getRdc() {
        return rdc;
    }

    public void setRdc(String rdc) {
        this.rdc = rdc;
    }

    public Integer getIfEas() {
        return ifEas;
    }

    public void setIfEas(Integer ifEas) {
        this.ifEas = ifEas;
    }

    public Integer getOrderBizType() {
        return orderBizType;
    }

    public void setOrderBizType(Integer orderBizType) {
        this.orderBizType = orderBizType;
    }

    public String getEasOrgId() {
        return easOrgId;
    }

    public void setEasOrgId(String easOrgId) {
        this.easOrgId = easOrgId;
    }

    public String getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(String deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getSendDate() {
        return sendDate;
    }

    public void setSendDate(String sendDate) {
        this.sendDate = sendDate;
    }

    public String getOldOrderId() {
        return oldOrderId;
    }

    public void setOldOrderId(String oldOrderId) {
        this.oldOrderId = oldOrderId;
    }

    public String getSourceOrderNo() {
        return sourceOrderNo;
    }

    public void setSourceOrderNo(String sourceOrderNo) {
        this.sourceOrderNo = sourceOrderNo;
    }

    public String getTransformOrderNo() {
        return transformOrderNo;
    }

    public void setTransformOrderNo(String transformOrderNo) {
        this.transformOrderNo = transformOrderNo;
    }

    public String getReTransformOrderNo() {
        return reTransformOrderNo;
    }

    public void setReTransformOrderNo(String reTransformOrderNo) {
        this.reTransformOrderNo = reTransformOrderNo;
    }

    public Integer getReleaseState() {
        return releaseState;
    }

    public void setReleaseState(Integer releaseState) {
        this.releaseState = releaseState;
    }

    public String getEasCode() {
        return easCode;
    }

    public void setEasCode(String easCode) {
        this.easCode = easCode;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getStoragePlace() {
        return storagePlace;
    }

    public void setStoragePlace(String storagePlace) {
        this.storagePlace = storagePlace;
    }

    public Long getStoragePlaceId() {
        return storagePlaceId;
    }

    public void setStoragePlaceId(Long storagePlaceId) {
        this.storagePlaceId = storagePlaceId;
    }

    public String getStoragePlaceName() {
        return storagePlaceName;
    }

    public void setStoragePlaceName(String storagePlaceName) {
        this.storagePlaceName = storagePlaceName;
    }

    public String getNewSaleOrderNo() {
        return newSaleOrderNo;
    }

    public void setNewSaleOrderNo(String newSaleOrderNo) {
        this.newSaleOrderNo = newSaleOrderNo;
    }

    public String getActualCustomerCode() {
        return actualCustomerCode;
    }

    public void setActualCustomerCode(String actualCustomerCode) {
        this.actualCustomerCode = actualCustomerCode;
    }

    public Long getActualCustomerId() {
        return actualCustomerId;
    }

    public void setActualCustomerId(Long actualCustomerId) {
        this.actualCustomerId = actualCustomerId;
    }

    public String getActualCustomerName() {
        return actualCustomerName;
    }

    public void setActualCustomerName(String actualCustomerName) {
        this.actualCustomerName = actualCustomerName;
    }

    public String getAllotType() {
        return allotType;
    }

    public void setAllotType(String allotType) {
        this.allotType = allotType;
    }

    public String getAllotOutWarehouseCode() {
        return allotOutWarehouseCode;
    }

    public void setAllotOutWarehouseCode(String allotOutWarehouseCode) {
        this.allotOutWarehouseCode = allotOutWarehouseCode;
    }

    public String getAllotOutWarehouseName() {
        return allotOutWarehouseName;
    }

    public void setAllotOutWarehouseName(String allotOutWarehouseName) {
        this.allotOutWarehouseName = allotOutWarehouseName;
    }

    public String getAllotInWarehouseCode() {
        return allotInWarehouseCode;
    }

    public void setAllotInWarehouseCode(String allotInWarehouseCode) {
        this.allotInWarehouseCode = allotInWarehouseCode;
    }

    public String getAllotInWarehouseName() {
        return allotInWarehouseName;
    }

    public void setAllotInWarehouseName(String allotInWarehouseName) {
        this.allotInWarehouseName = allotInWarehouseName;
    }
}
