package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderAddrRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 平台订单地址服务接口
*
* @author zimu
* @since 2022-03-08
*/
@Api(tags = {"平台订单地址服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-IPlatformOrderAddrApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/orderAddr",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPlatformOrderAddrApi {

/**
* 新增平台订单地址
*
* @param addReqDto 平台订单地址请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增平台订单地址", notes = "新增平台订单地址")
RestResponse<Long> addPlatformOrderAddr(@RequestBody PlatformOrderAddrReqDto addReqDto);

    /**
    * 修改平台订单地址
    *
    * @param modifyReqDto 平台订单地址请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改平台订单地址", notes = "修改平台订单地址")
    RestResponse<Void> modifyPlatformOrderAddr(@RequestBody PlatformOrderAddrReqDto modifyReqDto);

    /**
    * 删除平台订单地址
    *
    * @param ids        平台订单地址删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除平台订单地址", notes = "删除平台订单地址")
    RestResponse<Void> removePlatformOrderAddr(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
