package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 平台订单表服务接口
*
* @author zimu
* @since 2022-03-08
*/
@Api(tags = {"平台订单表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-IPlatformOrderApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/order",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPlatformOrderApi {

/**
* 新增平台订单表
*
* @param addReqDto 平台订单表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增平台订单表", notes = "新增平台订单表")
RestResponse<Long> addPlatformOrder(@RequestBody PlatformOrderReqDto addReqDto);

    /**
    * 修改平台订单表
    *
    * @param modifyReqDto 平台订单表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改平台订单表", notes = "修改平台订单表")
    RestResponse<Void> modifyPlatformOrder(@RequestBody PlatformOrderReqDto modifyReqDto);

    /**
    * 删除平台订单表
    *
    * @param ids        平台订单表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除平台订单表", notes = "删除平台订单表")
    RestResponse<Void> removePlatformOrder(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    @PutMapping("/goBackCancelPlatformOrder")
    @ApiOperation(value = "经销商采购订单（非药业-财务前置）-CSP反审,回滚操作", notes = "经销商采购订单（非药业-财务前置）-CSP反审,回滚操作")
    RestResponse<Void> goBackCancelPlatformOrder(@RequestParam("id") Long id);


    @PostMapping("/invalidPlatformOrderByPlatform")
    @ApiOperation(value = "根据平台单号作废平台单", notes = "根据平台单号作废平台单销售订单释放库存")
    RestResponse<Void> invalidPlatformOrderByPlatform(@RequestParam("platformOrderNo") String platformOrderNo);
}
