package com.dtyunxi.yundt.cube.center.transform.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 平台订单商品Eo对象
*
* @author zimu
* @since 2022-04-14
*/
@ApiModel(value = "SaleRefundOrderItemReqDto", description = "平台订单商品Eo对象")
public class SaleRefundOrderItemReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  订单id
    */
    @ApiModelProperty(name = "orderId", value = "订单id")
    private Long orderId;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  商品ID
    */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
    *  商品编码
    */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
    *  商品数量
    */
    @ApiModelProperty(name = "itemNum",required = true, value = "商品数量")
    private BigDecimal itemNum;
    /**
    *  商品批次号
    */
    @ApiModelProperty(name = "batchNo", value = "商品批次号")
    private String batchNo;
    /**
    *  单价
    */
    @ApiModelProperty(name = "price", value = "单价")
    private BigDecimal price;
    /**
    *  skuId
    */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    /**
    *  sku编码
    */
    @ApiModelProperty(name = "skuCode",required = true, value = "sku编码")
    private String skuCode;
    /**
    *  规格名称
    */
    @ApiModelProperty(name = "skuName", value = "规格名称")
    private String skuName;
    /**
    *  是否赠品：0否，1是
    */
    @ApiModelProperty(name = "gift",required = true, value = "是否赠品：0否，1是")
    private Integer gift;
    /**
    *  退货仓库code
    */
    @ApiModelProperty(name = "refundWarehouseCode", value = "退货仓库code")
    private String refundWarehouseCode;
    /**
    *  计量单位
    */
    @ApiModelProperty(name = "itemUnit",required = true, value = "计量单位")
    private String itemUnit;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrderId(Long orderId){
    this.orderId = orderId;
    }
    public Long getOrderId(){
    return this.orderId;
    }
    public void setItemName(String itemName){
    this.itemName = itemName;
    }
    public String getItemName(){
    return this.itemName;
    }
    public void setItemId(Long itemId){
    this.itemId = itemId;
    }
    public Long getItemId(){
    return this.itemId;
    }
    public void setItemCode(String itemCode){
    this.itemCode = itemCode;
    }
    public String getItemCode(){
    return this.itemCode;
    }
    public void setItemNum(BigDecimal itemNum){
    this.itemNum = itemNum;
    }
    public BigDecimal getItemNum(){
    return this.itemNum;
    }
    public void setBatchNo(String batchNo){
    this.batchNo = batchNo;
    }
    public String getBatchNo(){
    return this.batchNo;
    }
    public void setPrice(BigDecimal price){
    this.price = price;
    }
    public BigDecimal getPrice(){
    return this.price;
    }
    public void setSkuId(Long skuId){
    this.skuId = skuId;
    }
    public Long getSkuId(){
    return this.skuId;
    }
    public void setSkuCode(String skuCode){
    this.skuCode = skuCode;
    }
    public String getSkuCode(){
    return this.skuCode;
    }
    public void setSkuName(String skuName){
    this.skuName = skuName;
    }
    public String getSkuName(){
    return this.skuName;
    }
    public void setGift(Integer gift){
    this.gift = gift;
    }
    public Integer getGift(){
    return this.gift;
    }
    public void setRefundWarehouseCode(String refundWarehouseCode){
    this.refundWarehouseCode = refundWarehouseCode;
    }
    public String getRefundWarehouseCode(){
    return this.refundWarehouseCode;
    }
    public void setItemUnit(String itemUnit){
    this.itemUnit = itemUnit;
    }
    public String getItemUnit(){
    return this.itemUnit;
    }
}
