package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 平台订单商品服务接口
*
* @author zimu
* @since 2022-03-08
*/
@Api(tags = {"平台订单商品服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-IPlatformOrderItemQueryApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/orderItem",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPlatformOrderItemQueryApi {

    /**
    * 根据id查询平台订单商品
    *
    * @param id 平台订单商品id
    * @return   平台订单商品数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询平台订单商品", notes = "根据id查询平台订单商品")
    RestResponse<PlatformOrderItemRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 平台订单商品分页数据
    *
    * @param filter   平台订单商品查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 平台订单商品分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "平台订单商品分页数据", notes = "根据filter查询条件查询平台订单商品数据，filter=PlatformOrderItemReqDto")
    RestResponse<PageInfo<PlatformOrderItemRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @GetMapping("/queryListByOrderId")
    @ApiOperation(value = "根据平台单id查询平台订单商品", notes = "根据平台单id查询平台订单商品")
    RestResponse<List<PlatformOrderItemRespDto>> queryListByOrderId(@RequestParam("orderId") Long orderId);
}
